/**
 * Copyright shmdmoto ( http://wonderfl.net/user/shmdmoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/483s
 */

// forked from shmdmoto's 曲線を描く
package 
{
    import frocessing.display.F5MovieClip2D;
    /**
     * 五芒星形を描く
     * @author shmdmoto
     */
    public class GraphicExample extends F5MovieClip2D
    {
        public function setup() : void
        {
            var i:int;
            colorMode(HSB, 360, 100, 100, 100);
            noStroke();
            for( i = 0 ; i < 100 ; i++ ){
                fill(random(360), 80, 100, 50);
                drawPentagram(random(465),random(465),random(10,40));  
            }
        }
        // 五芒星形を描く
        // x,y : 中心点の座標
        // r : 半径
        private function drawPentagram( x:Number, y:Number, r:Number) : void
        {
            var i:int;
            var small_r:Number;
            
            small_r = r * (3. - sqrt(5))/2.
            beginShape();
            for( i = 0 ; i < 5 ; i++) {
                vertex( x + r * sin( 2.0 * PI / 5 * i),
                        y - r * cos( 2.0 * PI / 5 * i) );
                vertex( x + small_r * sin( 2.0 * PI / 5 * i + PI / 5.),
                        y - small_r * cos( 2.0 * PI / 5 * i + PI / 5.) );
            }
            endShape(CLOSE);
 
        }
    }
}