/**
 * Copyright christian ( http://wonderfl.net/user/christian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/47Uz
 */

package 
{
    import flash.geom.*;
    import flash.display.*;
    import flash.events.Event;

    public class SPIRAL extends Sprite 
    {
        private var w : uint = 465, h : uint = 465,

                    t : ColorTransform = new ColorTransform (1, 1, 1, 0.999),
                    b : BitmapData = new BitmapData (w, h, false, 0),
                    r : Rectangle = new Rectangle (0, 0, w, h),
                    m : Matrix = new Matrix (),

                    d : Vector.<Number>, // data
                    c : Vector.<int>,    // commands
                    s : Shape,

                    angle : Number = 0;


        public function SPIRAL () : void 
        {
            with (stage) { quality = StageQuality.HIGH_16X16; color = 0x0; scaleMode = 'noScale'; }

            //

            c = new <int>[1];

            d = new <Number>[0, 0];

            for (var i : int = 0; i < 300; i++)  // spiral length
            {
                c.push (2);

                var l : Point = Point.polar (i * i / 250, i * (PI / 35));

                d.push (l.x, l.y);
            }

            s = new Shape ();
            s.graphics.lineStyle (1, 0xFFFFFF);
            s.graphics.drawPath (c, d);

            addChild (new Bitmap (b));

            addEventListener (Event.ENTER_FRAME, render);
        }

        private function render (e : Event) : void 
        {
            angle -= 1 % 360;

            m.identity ();
            m.translate (w / 2, h / 2);
            m.translate (-r.width / 2,-r.height / 2);
            m.rotate (angle * (PI / 180));
            m.translate ( r.width / 2, r.height / 2);

            b.colorTransform (r, t);
            b.draw (s, m);
        }

        private var PI : Number = Math.PI;
    }
}