/**
 * Copyright contest.start ( http://wonderfl.net/user/contest.start )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/47Q5
 */

package
{
    import flash.text.TextField;
       
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.utils.Timer;
    
    [SWF(width="500", height="500" , frameRate="30", backgroundColor="#FFFFFF")]
    public class FlashTest extends Sprite
    { 
        //
        private var _bitmap:Bitmap;
        
        private var _bitmapDataA:BitmapData;
        private var _bitmapDataB:BitmapData;
        
        private var _timer:Timer;
        
        private var _sourceRect:Rectangle;
        private var _point:Point;
        
        private var _seed:Number;
        private var _numberOfPixels:uint = 800;
        private var _fillColor:uint = 0x00FF0000;
        
        private var _pixelTotal:int;
        private var _dissolvedPixelCount:int;
        
        private var _btn:Sprite;
        
        private var _canDissolv:Boolean = true;
        
        private var _t:TextField = new TextField();
        
        public function FlashTest()
        {
            super();
            initialize();
        }
        private function initialize():void
        {            
            createMember();
            deployDisplayObject();  
            addMemberListener();          
        }
        private function createMember():void
        {                 
            _timer = new Timer(0.1);            
            _point = new Point(0,0);            
            _dissolvedPixelCount = 0;            
            _bitmapDataA = new BitmapData(400 , 300 ,false , Math.round(Math.random()* 0xFFFFFF));
           
            _bitmap = new Bitmap(_bitmapDataA);    
            
            _btn  = new Sprite();
            _btn.graphics.beginFill(0x536CE5);
            _btn.graphics.drawRect(0,0,100,20);
            _btn.graphics.endFill();
            _btn.buttonMode = true;
            _btn.useHandCursor = true;
            _btn.mouseEnabled = true;
            
           
           
        }           
        private function deployDisplayObject():void
        {
            this.addChild(_bitmap);   
            _btn.y = _bitmap.y + _bitmap.height + 10;
            this.addChild(_btn);            
            _t.text = 'Click Me Start';
            _t.selectable = false;            
            _btn.addChild(_t);
        }
        private function addMemberListener():void
        {
            _timer.addEventListener(TimerEvent.TIMER, timerHandler);
            _btn.addEventListener(MouseEvent.MOUSE_DOWN , onDown);
           
        }
        
        
        private function onDown(e:MouseEvent):void
        {
             startDissolv();
        }        
        
        public function startDissolv():void
        {
            
            if(_canDissolv)
            {
                _bitmapDataB = new BitmapData(400 , 300 ,false , Math.round(Math.random()* 0xFFFFFF));
                _canDissolv = false;                
                _sourceRect = _bitmapDataA.rect;                
                _seed =  Math.floor(Math.random() * int.MAX_VALUE);                        
                _pixelTotal = _bitmapDataA.width * _bitmapDataA.height;
                _dissolvedPixelCount = 0;            
                _timer.start();
            }
        }    
        
        private function timerHandler(e:TimerEvent):void
        {
             dissolve();
        }        
        private function dissolve():void 
        {            
             _seed = _bitmapDataA.pixelDissolve(_bitmapDataB, _sourceRect, _point, _seed, _numberOfPixels, _fillColor);
            
             _dissolvedPixelCount += _numberOfPixels;
            
             if(_dissolvedPixelCount > _pixelTotal)
             {
                _timer.stop();                
                _canDissolv = true;               
             }
        }               
    }
}