/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/46Bq
 */

package 
{
    import flash.desktop.Clipboard;
    import flash.desktop.ClipboardFormats;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite
	import flash.events.Event;
	import flash.events.FocusEvent;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.net.FileFilter;
	import flash.net.FileReference;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.utils.ByteArray;
	import flash.utils.setTimeout;
	
	import mx.graphics.codec.PNGEncoder;
	import mx.utils.Base64Encoder;
	
	/**
	 * ...
	 * @author 9re
	 */
	[SWF(backgroundColor="#ffffff", frameRate="31", width="465", height="465")]
	public class Main extends Sprite 
	{
		public var fileReference:FileReference;
		private var _input:TextField;
		private var _tfBase64:TextField;
		
		public function Main():void 
		{
			var btn:Button = new Button("Select Image");
			btn.move(28, 20);
			btn.addEventListener(MouseEvent.CLICK, clickHandler);
			addChild(btn);
			
			var tfm:TextFormat = new TextFormat("_sans", 14, 0x333333, true);
			var tf:TextField = new TextField();
			tf.defaultTextFormat = tfm;
			tf.text = "scale: ";
			tf.selectable = false;
			tf.mouseEnabled = false;
			tf.y = btn.y;
			tf.x = stage.stageWidth - 140;
			
			addChild(tf);
			
			tf = new TextField();
			tf.defaultTextFormat = tfm;
			tf.type = TextFieldType.INPUT;
			tf.width = 50;
			tf.height = 20;
			
			tf.addEventListener(FocusEvent.FOCUS_IN, focusInHandler);

			tf.x = stage.stageWidth - 80;
			tf.y = btn.y;
			
			graphics.lineStyle(2, 0x666666);
			graphics.drawRect(tf.x, tf.y, tf.width, tf.height);
			
			tf.text = "1.0";
			_input = tf;
			addChild(tf);
			
			tf = new TextField();
			tf.defaultTextFormat = tfm;
			tf.wordWrap = true;
			tf.width = 300;
			tf.height = 300;
			tf.x = (stage.stageWidth - tf.width) / 2;
			tf.y = stage.stageHeight - 80 - tf.height;
			tf.addEventListener(FocusEvent.FOCUS_IN, focusInHandler);
			
			_tfBase64 = tf;
			addChild(tf);
			graphics.drawRect(tf.x, tf.y, tf.width, tf.height);
			
			btn = new Button("Copy to Clipboard");
			btn.move((stage.stageWidth - btn.width) / 2, ( -80 - btn.height) / 2 + stage.stageHeight);
			btn.addEventListener(MouseEvent.CLICK, copyToClipboad);
			addChild(btn);
		}
		
		private function copyToClipboad(e:MouseEvent):void 
		{
			focusInHandler(null);
			Clipboard.generalClipboard.clear();
			Clipboard.generalClipboard.setData(ClipboardFormats.TEXT_FORMAT, _tfBase64.text);
			
		}
		
		private function focusInHandler(e:FocusEvent):void 
		{
			setTimeout(selectText, 100, e.target);
		}
		
		private function selectText(textField:TextField):void
		{
			textField.setSelection(0, textField.length);
		}
		
		private function clickHandler(e:MouseEvent):void 
		{
			fileReference = new FileReference();
			fileReference.browse([new FileFilter("Images(*.jpg, *.jpeg, *.png)", "*.jpg;*.jpeg;*.png;")]);
			fileReference.addEventListener(Event.SELECT, selectHandler);
			
			_tfBase64.text = "";
		}
		
		private function selectHandler(e:Event):void 
		{
			fileReference.addEventListener(Event.COMPLETE, onComplete);
			fileReference.load();
			
			_tfBase64.text = "";
		}
		
		private function onComplete(e:Event):void 
		{
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoaded, false, 0, true);
			loader.loadBytes(fileReference.data);
		}
		
		private function imageLoaded(e:Event):void 
		{
			var loader:Loader = e.target.loader as Loader;
			var scale:Number = parseFloat(_input.text);
			var mat:Matrix = new Matrix();
			mat.scale(scale, scale);
			var bd:BitmapData = new BitmapData(loader.width * scale, loader.height * scale);
			bd.draw(loader, mat, null, null, null, true);
			
			var encoder:PNGEncoder = new PNGEncoder();
			var bytes:ByteArray = encoder.encode(bd);
			
			var base64Encoder:Base64Encoder = new Base64Encoder();
			base64Encoder.encodeBytes(bytes);
			
			_tfBase64.text = base64Encoder.toString();
		}
		
	}
	
}

import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class Button extends Sprite {
	public function Button($label:String) {
		var tf:TextField = new TextField();
		tf.defaultTextFormat = new TextFormat("_sans", 16, 0x333333, true);
		tf.selectable = false;
		tf.mouseEnabled = false;
		tf.autoSize = TextFieldAutoSize.LEFT;
		tf.width = 0;
		tf.text = $label;
		
		graphics.lineStyle(2, 0x666666);
		graphics.drawRoundRect( -8, -3, tf.width + 16, tf.height + 6, 15);
		addChild(tf);
		
		var sp:Sprite = new Sprite();
		sp.graphics.beginFill(0x3399ff, 0.3);
		sp.graphics.drawRoundRect( -8, -3, tf.width + 16, tf.height + 6, 15);
		sp.graphics.endFill();
		sp.buttonMode = true;
		sp.tabEnabled = false;
		addChild(sp);
		sp.alpha = 0;
		
		sp.addEventListener(MouseEvent.MOUSE_OVER, overHandler);
		sp.addEventListener(MouseEvent.MOUSE_OUT, outHandler);
	}
	
	public function move($x:Number, $y:Number):void {
		x = $x;
		y = $y;
	}
	
	private function outHandler(e:MouseEvent):void 
	{
		e.target.alpha = 0;
	}
	
	private function overHandler(e:MouseEvent):void 
	{
		e.target.alpha = 1;
	}
}