/**
 * Copyright chimanaco ( http://wonderfl.net/user/chimanaco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/46A7
 */

/**
* ▼多角形を描くクラスは以下のサイトを参考にさせていただきました。
* http://feb19.jp/blog/archives/000145.php
*/
package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.utils.Timer;
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
	public class Polygon extends Sprite {
		private var _centerX:Number = stage.stageWidth / 2;
		private var _centerY:Number = stage.stageHeight / 2;
		private var _r:uint = 5;
		private var _num:uint = 3;
		private var _alpha:Number = .8;
		private var _pScale:Number = 2;
		private var _mAlpha:Number = .01;
		//コンストラクタ
		public function Polygon() {
			var timer:Timer = new Timer(2000);
			timer.start();
			timer.addEventListener(TimerEvent.TIMER, timerHandler);
			stage.addEventListener(Event.ENTER_FRAME, makePolygon);
		}
		//多角形作成
		private function makePolygon(e:Event):void {
			var sp:Sprite = makeSprite();
			var color:uint = Math.random() * 0x555555;
			drawPolygon(sp, _r, color, _alpha, _num);
		}
		//sprite作成
		private function makeSprite():Sprite {
			var sp:Sprite = new Sprite();
			sp.x = _centerX;
			sp.y = _centerY;
			addChild(sp);
			sp.addEventListener(Event.ENTER_FRAME, enterFrame);
			return sp;
		}
		//多角形を描く
		private function drawPolygon(sp:Sprite, size:uint, color:uint, alpha:Number, vertex:uint = 5):void {
			sp.graphics.lineStyle(1, color, alpha, true, "none");
			//rotation
			var ro:uint;
			if (vertex % 2 == 0) {
				//Even Number
				ro = 0;
			} else {
				//Odd Number
				ro = 180 / vertex * Math.PI / 180 / 2;
			}
			//point
			var points:Array = new Array();
			for (var i:Number = 0; i < vertex; i++) {
				var p:Point = new Point();
				var vertexDegree:Number = 360 / vertex * i * Math.PI / 180 - ro;
				p = Point.polar(size, vertexDegree);
				points.push(p);
			}
			//draw
			sp.graphics..moveTo(points[0].x, points[0].y);
			for (i = 1; i < points.length; i++) {
				sp.graphics.lineTo(points[i].x, points[i].y);
			}
			sp.graphics.lineTo(points[0].x, points[0].y);
		}
		private function enterFrame(e:Event):void {
			var sp:Sprite = e.target as Sprite;
			if (sp.alpha > 0) {
				sp.scaleX = sp.scaleY += _pScale;				
				sp.alpha -= _mAlpha;
			}else {
				sp.graphics.clear();
				sp.removeEventListener(Event.ENTER_FRAME, enterFrame);
				removeChild(sp);
				sp = null;
			}
		}
		//TimerEvent
		private function timerHandler(e:TimerEvent):void {
			_num = Math.floor(Math.random() * 8) + 3;
			_r = Math.floor(Math.random() * 6) + 2;
		}
				
    }
}