/**
 * Copyright curvedstraightline ( http://wonderfl.net/user/curvedstraightline )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/465h
 */

// forked from curvedstraightline's forked from: perlineNoiseのテスト1
// forked from curvedstraightline's perlineNoiseのテスト1
package {
    import flash.display.Sprite;
   import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.geom.Point;
    
    public class FlashTest extends Sprite
    {
    		public var bg_sp:Sprite = new Sprite();
    		public var bg_bp:Bitmap;
    		public var bg_bmd:BitmapData;
    		
    		public var perlin_sp:Sprite = new Sprite();
    		public var perlin_bp:Bitmap;
    		public var perlin_bmd:BitmapData;
    		
    		public const STAGE_SCALE:int = 6;
    		public const STAGE_WIDTH:int = stage.stageWidth / STAGE_SCALE;
    		public const STAGE_HEIGHT:int = stage.stageHeight / STAGE_SCALE;
    		
        public function FlashTest()
        {
        		init();
        }
        public function init():void
        {
        		bg_bmd = new BitmapData(
        			STAGE_WIDTH,
        			STAGE_HEIGHT,
        			false,
        			0xffffff
        		);
        		bg_bp = new Bitmap();
        		bg_bp.bitmapData = bg_bmd;
        		bg_bp.scaleX = bg_bp.scaleY = STAGE_SCALE + .1;
        		bg_sp.addChild(bg_bp);
        		stage.addChild(bg_sp)
        		
        		
        		perlin_bmd = new BitmapData(
        			STAGE_WIDTH,
        			STAGE_HEIGHT,
        			false,
        			0xffffff
        		);
        		perlin_bp = new Bitmap();
        		perlin_bp.bitmapData = perlin_bmd;
        		perlin_bp.scaleX = perlin_bp.scaleY = STAGE_SCALE + .1; 
        		perlin_sp.addChild(perlin_bp);
        		stage.addChild(perlin_sp);
        		perlin_sp.blendMode = BlendMode.MULTIPLY;
        		
        		stage.addEventListener(Event.ENTER_FRAME,bgAction);
        		stage.addEventListener(Event.ENTER_FRAME,perlinAction);
        }
        
        public const BASE_X:int = stage.stageWidth / 7;
        public const BASE_Y:int = stage.stageHeight /2;
        
        public const OCTAVE_NUMBER:uint = 4;
        public var RANDOM_SEED:int = Math.floor(Math.random() * 0xffffff);
        public var CHANNEL_OPTION:int = 15;//BitmapDataChannel.RED |BitmapDataChannel.BLUE;//7;
        public var offset_array:Array = [new Point(),new Point(), new Point()];
        
        public function bgAction(evt:Event):void
        {
        		bg_bmd.perlinNoise(
        			BASE_X,
        			BASE_Y,
        			OCTAVE_NUMBER,
        			RANDOM_SEED,
        			false,
        			true,
        			CHANNEL_OPTION,
        			true,
        			offset_array
        		);
        		offset_array[0].y += 0.1;
        		offset_array[1].x += 0.1;
        		offset_array[2].y -= 0.1;
        }
        
        public function perlinAction(evt:Event):void
        {
        		perlin_bmd.perlinNoise(
        			BASE_X,
        			BASE_Y,
        			OCTAVE_NUMBER,
        			RANDOM_SEED,
        			false,
        			true,
        			CHANNEL_OPTION,
        			false,
        			offset_array
        		);
        		offset_array[0].y += 0.5;
        		offset_array[1].x -= 0.7;
        		offset_array[2].y -= 0.8;
        		
        }
    }
}