/**
 * Copyright plus-tic ( http://wonderfl.net/user/plus-tic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/45Hp
 */

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.geom.Rectangle;
    
    public class Main extends Sprite {
        
        
        	private var player:Sprite;
        	private var left:Boolean = false;
        	private var right:Boolean = false;
        	private var top:Boolean = false;
        	private var bottom:Boolean = false;
        	
        	private var vx:int = 0;
        	private var vy:int = 0;
        	private var isMoving:Boolean = false;
        	private const SIZE:int = 60;
        	private const SPEED:int = 10;
        	
        
        public function Main() {   	
        	    var bd:BitmapData = new BitmapData(SIZE,SIZE,false,0xdddddd);
            bd.fillRect(new Rectangle(1,1,SIZE-2,SIZE-2),0xFFFFFF);
       		graphics.beginBitmapFill(bd);
       		graphics.drawRect(0,0,465,465);
       		graphics.endFill();
       		
       		player = new Sprite;
       		player.graphics.beginFill(0xFF0000);
       		player.graphics.drawCircle(SIZE/2,SIZE/2,SIZE/2-2);
       		player.graphics.endFill();
       		player.x = player.y = 0;
       		addChild(player);
       		
       		addEventListener(Event.ENTER_FRAME,onEF);
       		stage.addEventListener(KeyboardEvent.KEY_DOWN,onKD);
       		stage.addEventListener(KeyboardEvent.KEY_UP,onKU);
        }
        
        private function onKD(e:KeyboardEvent):void{
        	if(e.keyCode == 37) left = true;
        	if(e.keyCode == 39) right = true;
        	if(e.keyCode == 38) top = true;
        	if(e.keyCode == 40) bottom = true;
        }
        
        private function onKU(e:KeyboardEvent):void{
        	if(e.keyCode == 37)left = false;
        	if(e.keyCode == 39)right = false;
        	if(e.keyCode == 38)top = false;
        	if(e.keyCode == 40)bottom = false;
        }
        
        private function onEF(e:Event = null):void{
        if(isMoving){
        	player.x += vx;
        	player.y += vy;
        	
        	if(vx && player.x%SIZE == 0)isMoving = false;
        	if(vy && player.y%SIZE == 0)isMoving = false;
        }else{
        		//初期化
        		vx = vy = 0;
        		//押されたキーに対して移動量を設定
        		if(left)vx = -SPEED;
        		else if(right)vx = SPEED;
        		else if(top)vy = -SPEED;
        		else if(bottom)vy = SPEED;        
        
        		if(vx||vy){
        			isMoving = true;
        			onEF();        
        		}
        }
        
        
        	
        
        
        }
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
    }
}