/**
 * Copyright kinoppy ( http://wonderfl.net/user/kinoppy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/454j
 */

// forked from yoshihiko's Thermo
//温度センサーっぽいもの（要Webカメラ）
//白っぽい服を着ると、心の温かい人になれます。
//黒っぽい服を着ると、心の冷たい人になれます。
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.media.Camera;
    import flash.media.Video;
    import frocessing.color.ColorRGB;
    import frocessing.color.ColorHSV;
    
    [SWF(backgroundColor=0x000000, frameRate=30)]
    import flash.ui.Keyboard;
    public class Thermo extends Sprite {
        private var _camera:Camera
        private var _video:Video
        private var _bitmap:Bitmap
        
        public function Thermo() {
            ready();
            start();
        }
        
        public function ready():void{
            _bitmap = new Bitmap();
            _bitmap.x = (stage.stageWidth-320)/2;
            _bitmap.y = (stage.stageHeight-240)/2;
            addChild(_bitmap);
        }
        
        public function start():void{
            var camera:Camera = Camera.getCamera();
                
            //camera
            if (camera != null) {
                _camera = camera;
            
                _camera.setMode(640, 480, 15, true);
                _camera.setQuality(0, 100);
                
                _video = new Video(320,240);
                _video.attachCamera(_camera);
                _video.width = 80;
                _video.height = 60;
                _video.x = _bitmap.x + 230;
                _video.y = _bitmap.y + 10;
                addChild(_video);
            }
            
            addEventListener(Event.ENTER_FRAME, update);            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
            
            camera = null;
        }
        
        private function update(e:Event):void {
            var i:int, j:int, pixelValue:int;
            var rgb:ColorRGB;
            var hsv:ColorHSV;
            
            var bitmapData:BitmapData = new BitmapData(320, 240, true, 0x00FFFFFFF);
            bitmapData.draw(_video);
            
            bitmapData.lock();
            
            var w:int = bitmapData.width;
            var h:int = bitmapData.height;
                
            for (i = 0; i < w; i++) {
                for (j = 0; j < h; j++) {
                    pixelValue = bitmapData.getPixel(i, j);
                    
                    rgb = new ColorRGB(pixelValue >> 16 & 0xFF, pixelValue >> 8 & 0xFF, pixelValue & 0xFF);
                    hsv = rgb.toHSV();
                    
                    hsv.h = (1 - hsv.v) * 270;
                    hsv.s = 1;
                    hsv.v = 1;
                        
                    bitmapData.setPixel(i, j, hsv.value);
                }
            }
            
            bitmapData.unlock();
            
            _bitmap.bitmapData = bitmapData;
            
            bitmapData = null;
            rgb = null;
            hsv = null;
        }
        private function keyDownHandler(e:KeyboardEvent):void
        {
            _video.visible = !_video.visible;
        }
    }
}