/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4544
 */

// forked from codeonwort's striped line
package {
    
    import flash.geom.Point
    import flash.display.Graphics
    import flash.display.Shape
    import flash.display.Sprite
    import flash.events.Event
    import flash.events.MouseEvent
    
    [SWF(width=500, height=400, backgroundColor=0x0099cc, frameRate=30)]
    public class FlashTest extends Sprite {
        
        private var line:StripedLine
        
        public function FlashTest() {
            if(stage) init()
            else addEventListener("added", function(e:Event):void{init()})
        }
        
        private function init():void {
            line = addChild(new StripedLine) as StripedLine
            stage.addEventListener("mouseDown", md)
            stage.addEventListener("mouseUp", mu)
        }
        
        private function md(e:MouseEvent):void {
            line.start(e.stageX, e.stageY)
            stage.addEventListener("mouseMove", mm)
        }
        private function mu(e:MouseEvent):void {
            stage.removeEventListener("mouseMove", mm)
        }
        private function mm(e:MouseEvent):void {
            line.to(e.stageX, e.stageY)
        }
        
    }
    
}

////////////////////////////////////////////////////////////////////////////

import flash.display.Shape
import flash.geom.Point

internal class StripedLine extends Shape {
    
    private const color1:uint = 0x000000
    private const color2:uint = 0xffff00
    private const colorWidth:Number = 20
    private const thickness:Number = 12
    
    private var prev:Position
    private var curr:Position
    private var curr_color:uint = 0x000000
    private var rest:Number = colorWidth
    
    private var startx:Number=NaN, starty:Number=NaN
    public function start(x:Number, y:Number):void {
        startx = x
        starty = y
        rest = colorWidth
    }
    public function to(tx:Number, ty:Number):void {
        if(isNaN(startx) == false){
            prev = new Position(startx-(tx-startx),starty-(ty-starty), startx,starty, thickness)
            curr = new Position(startx,starty, tx,ty, thickness)
            startx = NaN
            starty = NaN
        }else{
            prev = curr
            curr = new Position(prev.x,prev.y, tx,ty, thickness)
        }
        draw(prev, curr)
    }
    
    private function draw(p0:Position, p1:Position):void {
        var d:Number = Math.sqrt( (p1.x-p0.x)*(p1.x-p0.x) + (p1.y-p0.y)*(p1.y-p0.y) )
        if(d <= rest){
            fill(p0, p1)
            rest -= d
        }else{
            var pt:Position = Position.interpolate(p0, p1, rest, thickness)
            fill(p0, pt)
            curr_color = curr_color==color1 ? color2 : color1
            rest = colorWidth
            draw(pt, p1)
        }
    }
    
    private function fill(p0:Position, p1:Position):void {
        graphics.beginFill(curr_color, 1)
        graphics.moveTo(p0.upper.x, p0.upper.y)
        graphics.lineTo(p0.lower.x, p0.lower.y)
        graphics.lineTo(p1.lower.x, p1.lower.y)
        graphics.lineTo(p1.upper.x, p1.upper.y)
        graphics.endFill()
    }
    
}

internal class Position {
    
    private var _x:Number, _y:Number;
    private var _upper:Point, _lower:Point; 
    private static var movement:Point;
    
    public function Position(prevx:Number,prevy:Number, x:Number,y:Number, thickness:Number) {
        _x = x
        _y = y
        
        movement = new Point(x - prevx , y - prevy)
        var normal:Point = new Point(movement.y, -movement.x)
        var factor:Number = 0.5 * thickness / normal.length
        normal.x *= factor
        normal.y *= factor
        
        _upper = new Point(x+normal.x, y+normal.y)
        _lower = new Point(x-normal.x, y-normal.y)
    }
    
    public function get upper():Point { return _upper }
    public function get lower():Point { return _lower }
    public function get x():Number { return _x }
    public function get y():Number { return _y }
    
    public static function interpolate(p0:Position, p1:Position, rest:Number, thickness:Number):Position {
        movement = new Point(p1.x - p0.x , p1.y - p0.y)
        var factor:Number = rest / movement.length
        movement.x *= factor
        movement.y *= factor
        var px:Number = p0.x + movement.x
        var py:Number = p0.y + movement.y
        
        var p:Position = new Position(p0.x,p0.y, px,py, thickness)
        return p
    }
    
}