/**
 * Copyright dory ( http://wonderfl.net/user/dory )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/43uX
 */

// forked from dory's flash on 2010-1-30
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import idv.cjcat.stardust.common.actions.Age;
    import idv.cjcat.stardust.common.actions.AlphaCurve;
    import idv.cjcat.stardust.common.actions.DeathLife;
    import idv.cjcat.stardust.common.actions.ScaleCurve;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.initializers.Life;
    import idv.cjcat.stardust.common.math.UniformRandom;
    import idv.cjcat.stardust.twoD.actions.Damping;
    import idv.cjcat.stardust.twoD.actions.Move;
    import idv.cjcat.stardust.twoD.emitters.Emitter2D;
    import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
    import idv.cjcat.stardust.twoD.initializers.Position;
    import idv.cjcat.stardust.twoD.initializers.Velocity;
    import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
    import idv.cjcat.stardust.twoD.zones.LazySectorZone;
    import idv.cjcat.stardust.twoD.zones.SinglePoint;
    
    /**
     * Stardust Test...
     * dory
     */
    [SWF(backgroundColor="#2f0f00", width="465", height="465", frameRate=60)]
    public class Main extends Sprite 
    {
        private var emitter:Emitter2D;
        private var renderer:DisplayObjectRenderer;
        private var point:SinglePoint;

        private var perticle:Perticle;
        
        public function Main():void 
        {
            drawBackground();
            emitter = new Emitter2D(new SteadyClock(1.2));
            addInitializers();
            addActions();
            renderer = new DisplayObjectRenderer(this);
            renderer.addEmitter(emitter);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function addInitializers():void {
            emitter.addInitializer(new DisplayObjectClass(Perticle));
            emitter.addInitializer(new Life(new UniformRandom(50, 5)));
            point = new SinglePoint();
            emitter.addInitializer(new Position(point));
            emitter.addInitializer(new Velocity(new LazySectorZone(10, 3)));
        }
        
        private function addActions():void {
            emitter.addAction(new Age());
            emitter.addAction(new DeathLife());
            emitter.addAction(new Move());
            emitter.addAction(new Damping(0.05));
            emitter.addAction(new AlphaCurve(0, 20));
            emitter.addAction(new ScaleCurve(50, 100));
        }
        
        private function onEnterFrame(event:Event):void {
            point.x = mouseX;
            point.y = mouseY;
            emitter.step();
        }
        
        private function drawBackground():void {
/*            var back:Sprite = new Sprite();
            back.graphics.beginFill( 0x2f0f00 );
            back.graphics.drawRect( 0, 0, 465, 465 );
            back.graphics.endFill();
            addChild( back );
*/
            graphics.beginFill( 0x2f0f00 );
            graphics.drawRect( 0, 0, 465, 465 );
            graphics.endFill();
        }

    }
}

import flash.display.Sprite;
import flash.filters.BlurFilter;
import flash.geom.Matrix;
import idv.cjcat.stardust.twoD.zones.SinglePoint;
    
/**
 * Perticle Class
 * @author dory
 */
class Perticle extends Sprite
{
    private const COL_RANDOM:Number = Math.random() * 100 + 1;
    
    private var p:Array = [
        {x:11, y:-16, anchorX:16, anchorY:-6},
        {x:20, y:6, anchorX:0, anchorY:16},
        {x:-20, y:6, anchorX:-16, anchorY:-6},
        {x:-11, y:-16, anchorX:0, anchorY:0},
    ];
    
    public function Perticle() 
    {
        draw();
    }
    
    private function draw():void {
        fillDraw();
        lineDraw();

        var blur:BlurFilter = new BlurFilter(8, 8);
        filters = [blur];
    }

    private function fillDraw():void {
        var scaleRandom:Number = Math.random() + 0.5;
        
        var col1:uint = 0xcc6666 + COL_RANDOM;
        var col2:uint = 0x663333 + COL_RANDOM;
        
        graphics.beginGradientFill("radial", [col1, col2], [1, 1], [0, 127]);
        graphics.moveTo(0, 0);
        for (var i:int = 0; i < p.length; i++ ) {
            graphics.curveTo(p[i].x * scaleRandom, p[i].y * scaleRandom, p[i].anchorX * scaleRandom, p[i].anchorY * scaleRandom);
        }
        graphics.endFill();
    }

    private function lineDraw():void {
        var posRandomX:Number = Math.random() * 20 - 10;
        var posRandomY:Number = Math.random() * 30 - 15;
        var scaleRandom:Number = Math.random() * 1.5 + 1.0;
        
        var col:uint = 0xcc6666 + COL_RANDOM;
        
        graphics.lineStyle(1, col);
        graphics.moveTo(posRandomX, posRandomY);
        for (var i:int = 0; i < p.length; i++ ) {
            graphics.curveTo(p[i].x * scaleRandom + posRandomX, p[i].y * scaleRandom + posRandomY,             p[i].anchorX * scaleRandom + posRandomX,                 p[i].anchorY * scaleRandom + posRandomY);
        }
        graphics.endFill();
    }
}
