/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/43EQ
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

	[SWF(framerate="30",width="480",height="480",backgroundColor="0x000000")]
	public class Practice01 extends Sprite
	{
		private var val1:int = 0;
		private var val2:int = 180;
		private var radius:Number = 240;
		private var centerX:Number = 240;
		private var centerY:Number = 240;
		
		public function Practice01() 
		{
			stage.addEventListener(MouseEvent.CLICK, onClick);
			stage.addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function onClick(e:MouseEvent):void {
			addCircle(e.stageX,e.stageY);
		}
		
		private function update(e:Event):void {
			val1 += 10;
			val2 += 10;
			updateImage(val1);
			updateImage(val2);
			if (val1 % 540 == 0) {
				centerX = ((Math.random() + Math.random()) / 2) * 480;
				centerY = ((Math.random() + Math.random()) / 2) * 480;
			}
		}
		
		private function updateImage(val:Number):void {
			var rad:Number = Math.PI/180.0*(val % 360);
			var xx:Number = Math.cos(rad)*radius+radius;
			var yy:Number = Math.sin(rad)*radius+radius;
			addCircle(xx, yy);	
			if (val % 60 == 0) {
				addCircle(Math.random() * radius*2, Math.random() * radius*2);
			}
		}
		
		private function addCircle(cx:Number,cy:Number ):void {
			var r:int = Math.ceil(Math.random() * 20) + 10;
			var c:int = Math.floor(Math.random() * 0xffffff);
			var circle:Circle = new Circle(cx, cy, r, c, centerX, centerY);
			this.addChild(circle);
		}
	}

}
import flash.display.MovieClip;
import caurina.transitions.Tweener;

class Circle extends MovieClip {
	
	public function Circle(x:int, y:int, r:int, c:int,cx:int,cy:int) {
		graphics.lineStyle(2, c) ;
		graphics.beginFill(c);
		graphics.drawCircle(x, y, r);
		graphics.endFill();
		Tweener.addTween( this, { x:cx, y:cy, scaleX:0.05, scaleY:0.05, time:30, useFrames:true, transition:"easeOutExpo",onComplete:complete});
	}
	
	private function complete():void {
		this.parent.removeChild(this);
	}
}