/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/42wF
 */

// forked from yprops's Array.concat() テスト
package {
    import flash.events.*;
    import flash.display.*;
    import flash.text.*;
    import flash.net.*;
    public class DebugText extends Sprite {
        public function DebugText() {
            addDeb(450, 450);
            addDebLine("SharedObject利用について。");
            addDebLine("「コンテキストメニュー」→「設定」で記憶領域を0にしても、getLocal()できるし、値も書き込める。ただし保存はされない/されていない。");
            addDebLine("「グローバル記憶領域設定」で「サードパーティ～」をオフにすると、getLocal()がエラーを返す。");
            addDebLine("http://www.macromedia.com/support/documentation/jp/flashplayer/help/settings_manager03.html");
            addDebLine("SharedObject利用中に、別窓で「サードパーティ～」をオフにしても、保存できないだけで突然エラーを返すことはない。");
            addDebLine();
            stage.addEventListener(MouseEvent.CLICK, main);
            main();
        }
        
        
        //-----------------メイン---------------------
            
        private function main(ev:Event = null) :void{
            addDebLine(
                "SharedObject チェック",
                soGetProp("tes0", -1)
            );
            
            addDebLine("SharedObject 書き込み");
            soSetProp("tes0", 10);
            
            addDebLine(
                "SharedObject 再チェック",
                soGetProp("tes0", -1),
                "\n"
            );
            
        }
        
        
        //------------Shared Object用----------------
        
        private var _so :SharedObject;
        private function get so() :SharedObject {
            if(!_so) _so = SharedObject.getLocal("local");
            return _so;
        }
        private function soSetProp(name :String, value :Object) :void {
            so.setProperty(name, value);
        }
        private function soGetProp(name:String, alternative :Object) :Object {
            return (so.data.hasOwnProperty(name))? so.data[name] : alternative;
        }
        
                
        
        //------------テキスト出力用-------------------
        
        private var deb :TextField;
        private function addDeb(w:uint, h:uint) :void{
                deb = new TextField();
                deb.wordWrap = true;
                deb.width = w;
                deb.height = h;
                deb.border = true;
                deb.borderColor = 0;
                deb.background = true;
                deb.backgroundColor = 0x99ffffff;
                deb.text = "beginDebugText-------\n";
                addChild(deb);
        }
        private function addDebLine(...args) :void{
                deb.appendText(args.join(" ") + "\n");
                deb.scrollV = deb.maxScrollV;
        }
        
        
        
    }
}