/**
 * Copyright h_kamizono ( http://wonderfl.net/user/h_kamizono )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/42kF
 */

/*

You are writing an application which continuously receives integer values between 1 and 10,000. 
Your job is, once the input stream ceases, to output each integer received in ascending order.
You don't know how many there will be, and you can only use a page (4KB) of memory.  
What do you do?

http://undiscoveredfeatures.blogspot.com/2010/12/10000-ints-in-1-page-of-memory-4kb.html
*/

package {
    import flash.display.Sprite;
    import flash.text.*;
    public class FlashTest extends Sprite {
        private var testData:Array;
        private var _field:TextField;
        public function FlashTest() {
            // write as3 code here..
            
            init();
            setTest();
            
            var hoge:Vector.<uint> = new Vector.<uint>(314);
            for (var i:uint = 0; i < testData.length; ++i)
            {
                // uint is 32bit
               var tmpIndex:uint = (testData[i]) / 32;
               hoge[tmpIndex] |= ( 1 << ((testData[i]) % 32) );
            }
            
            // print result
            for (i = 0; i < 314; ++i)
            {
                var r:uint = hoge[i];
                for (var j:uint = 0; j < 32; ++j, r >>= 1)
                {
                    if (r & 1) 
                    {
                        var output:uint = (32*i) + j;
                        print(""+output);
                    }
                }
            }
        }
        
        private function init():void
        {
            _field = new TextField();
            _field.width = stage.stageWidth;
            _field.height = stage.stageHeight;
            var format:TextFormat = _field.defaultTextFormat;
            format.font = "_sans";
            _field.defaultTextFormat = format;
        
            addChild(_field);
        }

        
        private function setTest():void
        {
            testData= new Array( 2,3454,6666,1666,1234,1532,532,1235,6543,3434,2432,555,232,1555,6432,6789,8767,6766,8766,12);
      
        }
        
        private function print(log:String):void
        {
            _field.appendText(log + "\n");
        }
    
        
    }
}