/**
 * Copyright devon_o ( http://wonderfl.net/user/devon_o )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/42T5
 */

package
{
    import com.adobe.utils.AGALMiniAssembler;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display3D.Context3D;
    import flash.display3D.Context3DProgramType;
    import flash.display3D.Context3DTextureFormat;
    import flash.display3D.Context3DVertexBufferFormat;
    import flash.display3D.IndexBuffer3D;
    import flash.display3D.Program3D;
    import flash.display3D.textures.Texture;
    import flash.display3D.VertexBuffer3D;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.geom.Matrix;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="#000000")]
    public class Main extends Sprite
    {

        private var mContext3d:Context3D;
        private var mVertBuffer:VertexBuffer3D;
        private var mIndexBuffer:IndexBuffer3D; 
        private var mProgram:Program3D;
        private var mTexture:Texture;
        private var mTextureData:BitmapData;
        
        private var mMatrix:Matrix3D = new Matrix3D();
        
        
        public function Main()
        {    
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);    
        }
        
        private function init(event:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            
            initStage();
            loadImage();
            
            addEventListener(Event.ENTER_FRAME, onTick);
            
            //addChild(new Stats());
        }
        
        private function loadImage():void {
            var l:Loader = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoad);
            l.load(new URLRequest("http://assets.wonderfl.net/images/related_images/b/b2/b2ef/b2ef871ed9c581dad8a218e46eefea2e305d04af"), new LoaderContext(true));
        }
        
        private function onImageLoad(event:Event = null):void
        {
            event.currentTarget.removeEventListener(Event.COMPLETE, onImageLoad);
            var l:Loader = event.currentTarget.loader;
            mTextureData = (l.content as Bitmap).bitmapData;

            stage.stage3Ds[0].addEventListener( Event.CONTEXT3D_CREATE, initStage3d );
            stage.stage3Ds[0].requestContext3D();
            
        }
        
        private function initStage():void
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
        }
        
        private function initStage3d(event:Event):void
        {
            mContext3d = stage.stage3Ds[0].context3D;        
            mContext3d.enableErrorChecking = false;
            
            mContext3d.configureBackBuffer(stage.stageWidth, stage.stageHeight, 4, true);
            
            var vertices:Vector.<Number> = Vector.<Number>([
                -1.0, -1.0,  0,   0, 0, 
                -1.0,  1.0,  0,   0, 1,
                 1.0,  1.0,  0,   1, 1,
                 1.0, -1.0,  0,   1, 0  ]);
            
            mVertBuffer = mContext3d.createVertexBuffer(4, 5);
            mVertBuffer.uploadFromVector(vertices, 0, 4);
            mIndexBuffer = mContext3d.createIndexBuffer(6);            
            mIndexBuffer.uploadFromVector (Vector.<uint>([0, 1, 2, 2, 3, 0]), 0, 6);
            
            mTexture = mContext3d.createTexture(mTextureData.width, mTextureData.height, Context3DTextureFormat.BGRA, true);
            mTexture.uploadFromBitmapData(mTextureData);

            mContext3d.setVertexBufferAt(0, mVertBuffer, 0, Context3DVertexBufferFormat.FLOAT_3);
            mContext3d.setVertexBufferAt(1, mVertBuffer, 3, Context3DVertexBufferFormat.FLOAT_2);
            
            generateMicroProg();
            
            mContext3d.setTextureAt(0, mTexture);
            mContext3d.setProgram(mProgram);
        }
        
        private function generateMicroProg():void
        {
            var vertexShaderAssembler : AGALMiniAssembler = new AGALMiniAssembler();
            vertexShaderAssembler.assemble( Context3DProgramType.VERTEX,
                "m44 op, va0, vc0\n" + // pos to clipspace
                "mov v0, va1" // copy uv
            );
            var fragmentShaderAssembler : AGALMiniAssembler= new AGALMiniAssembler();
            fragmentShaderAssembler.assemble( Context3DProgramType.FRAGMENT,
                "mov ft2, fc1    \n" +
                "div ft2, v0.xy, fc0.xy    \n" +
                "mul ft2, ft2, fc2.y    \n" +
                "sub ft2, ft2, fc2.x    \n" +
                "dp3 ft1, ft2, ft2    \n" +
                "sqt ft1.x, ft1    \n" +
                "abs ft3.z, ft2.x    \n" +
                "abs ft3.w, ft2.y    \n" +
                "max ft3.x, ft3.z, ft3.w    \n" +
                "min ft3.y, ft3.z, ft3.w    \n" +
                "rcp ft4.x, ft3.x    \n" +
                "mul ft4.x, ft4.x, ft3.y    \n" +
                "mul ft3.x, ft4.x, ft4.x    \n" +
                "mul ft3.y, ft3.x, fc10.z    \n" +
                "add ft3.y, ft3.y, fc10.w    \n" +
                "mul ft3.y, ft3.y, ft3.x    \n" +
                "add ft3.y, ft3.y, fc11.x    \n" +
                "mul ft3.y, ft3.y, ft3.x    \n" +
                "add ft3.y, ft3.y, fc11.y    \n" +
                "mul ft3.y, ft3.y, ft3.x    \n" +
                "add ft3.y, ft3.y, fc11.z    \n" +
                "mul ft3.y, ft3.y, ft3.x    \n" +
                "add ft3.y, ft3.y, fc11.w    \n" +
                "mul ft4.x, ft4.x, ft3.y    \n" +
                "sub ft3.x, fc12.x, ft4.x    \n" +
                "slt ft3.w, ft3.z, ft3.w    \n" +
                "mul ft3.y, ft3.w, ft3.x    \n" +
                "sub ft3.w, fc10.y, ft3.w    \n" +
                "mul ft3.w, ft3.w, ft4.x    \n" +
                "add ft3.w, ft3.w, ft3.y    \n" +
                "sub ft3.z, fc12.y, ft3.w    \n" +
                "slt ft3.x, ft2.x, fc10.x    \n" +
                "mul ft3.y, ft3.x, ft3.z    \n" +
                "sub ft3.x, fc10.y, ft3.x    \n" +
                "mul ft3.x, ft3.x, ft3.w    \n" +
                "add ft3.x, ft3.x, ft3.y    \n" +
                "neg ft3.y, ft4.x    \n" +
                "slt ft4.x, ft2.y, fc10.x    \n" +
                "mul ft3.z, ft4.x, ft3.y    \n" +
                "sub ft4.x, fc10.y, ft4.x    \n" +
                "mul ft4.x, ft4.x, ft3.x    \n" +
                "add ft4.x, ft4.x, ft3.z    \n" +
                "mov ft0, fc1    \n" +
                "mov ft0.x, ft4.x    \n" +
                "mul ft2.x, fc2.w, ft0.x    \n" +
                "cos ft2.x, ft2.x    \n" +
                "mul ft2.x, fc2.z, ft2.x    \n" +
                "add ft2.x, ft2.x, fc2.z    \n" +
                "mov ft5.x, fc3.x    \n" +
                "mov ft4, fc1    \n" +
                "max ft2.x, ft2.x, fc3.y    \n" +
                "min ft2.x, ft2.x, ft5.x    \n" +
                "sub ft2.x, ft2.x, fc3.y    \n" +
                "sub ft4.x, ft5.x, fc3.y    \n" +
                "rcp , ft4.x, ft4.x    \n" +
                "mul ft4.x, ft2.x, ft4.x    \n" +
                "mul ft2.x, ft4.x, ft4.x    \n" +
                "mul ft4.x, ft2.x, ft4.x    \n" +
                "mul ft4.x, ft4.x, fc2.y    \n" +
                "mul ft2.x, ft2.x, fc5.y    \n" +
                "sub ft2.x, ft2.x, ft4.x    \n" +
                "mov ft4, fc1    \n" +
                "max ft2.x, ft2.x, fc3.y    \n" +
                "min ft2.x, ft2.x, ft5.x    \n" +
                "sub ft2.x, ft2.x, fc3.y    \n" +
                "sub ft4.x, ft5.x, fc3.y    \n" +
                "rcp , ft4.x, ft4.x    \n" +
                "mul ft4.x, ft2.x, ft4.x    \n" +
                "mul ft2.x, ft4.x, ft4.x    \n" +
                "mul ft4.x, ft2.x, ft4.x    \n" +
                "mul ft4.x, ft4.x, fc2.y    \n" +
                "mul ft2.x, ft2.x, fc5.y    \n" +
                "sub ft2.x, ft2.x, ft4.x    \n" +
                "mov ft4, fc1    \n" +
                "max ft2.x, ft2.x, fc3.y    \n" +
                "min ft2.x, ft2.x, ft5.x    \n" +
                "sub ft2.x, ft2.x, fc3.y    \n" +
                "sub ft4.x, ft5.x, fc3.y    \n" +
                "rcp , ft4.x, ft4.x    \n" +
                "mul ft4.x, ft2.x, ft4.x    \n" +
                "mul ft2.x, ft4.x, ft4.x    \n" +
                "mul ft4.x, ft2.x, ft4.x    \n" +
                "mul ft4.x, ft4.x, fc2.y    \n" +
                "mul ft2.x, ft2.x, fc5.y    \n" +
                "sub ft2.x, ft2.x, ft4.x    \n" +
                "mov ft4, fc1    \n" +
                "max ft2.x, ft2.x, fc3.y    \n" +
                "min ft2.x, ft2.x, ft5.x    \n" +
                "sub ft2.x, ft2.x, fc3.y    \n" +
                "sub ft4.x, ft5.x, fc3.y    \n" +
                "rcp , ft4.x, ft4.x    \n" +
                "mul ft4.x, ft2.x, ft4.x    \n" +
                "mul ft2.x, ft4.x, ft4.x    \n" +
                "mul ft4.x, ft2.x, ft4.x    \n" +
                "mul ft4.x, ft4.x, fc2.y    \n" +
                "mul ft2.x, ft2.x, fc5.y    \n" +
                "sub ft2.x, ft2.x, ft4.x    \n" +
                "mov ft3, fc1    \n" +
                "mul ft3.x, fc5.x, ft2.x    \n" +
                "add ft3.x, ft3.x, ft1.x    \n" +
                "div ft3.x, fc2.x, ft3.x    \n" +
                "add ft3.x, ft3.x, fc4.x    \n" +
                "mul ft3.y, ft0.x, fc5.y    \n" +
                "div ft3.y, ft3.y, fc3.z    \n" +
                "mov ft4, fc1    \n" +
                "mul ft4.x, ft2.x, fc2.z    \n" +
                "add ft4.x, ft4.x, fc2.z    \n" +
                "mul ft4.x, ft4.x, ft1    \n" +
                "mul ft4.x, ft4.x, ft1    \n" +
                "tex ft5, ft3, fs0<2d, repeat, linear, nomip>    \n" +
                "mov ft5.w, fc3.x    \n" +
                "mov ft7, fc1    \n" +
                "mul ft7.x, fc2.w, ft0.x    \n" +
                "cos ft7.x, ft7.x    \n" +
                "mul ft7.x, ft7.x, fc2.z    \n" +
                "add ft7.x, ft7.x, fc2.z    \n" +
                "mul ft7.x, ft7.x, ft1.x    \n" +
                "mul ft7.x, ft7.x, fc2.z    \n" +
                "sub ft7.x, fc2.x, ft7.x    \n" +
                "mov ft6, fc1    \n" +
                "mul ft6.x, ft5, ft4.x    \n" +
                "mul ft6.x, ft6.x, ft7.x    \n" +
                "mul ft6.y, ft5, ft4.x    \n" +
                "mul ft6.y, ft6.y, ft7.x    \n" +
                "mul ft6.z, ft5, ft4.x    \n" +
                "mul ft6.z, ft6.z, ft7.x    \n" +
                "mov ft6.w, fc2.x    \n" +
                "mov oc, ft6    \n"
            );
            
            mProgram = mContext3d.createProgram();
            mProgram.upload( vertexShaderAssembler.agalcode, fragmentShaderAssembler.agalcode);
        }
        

        
        private var mTime:Number = 0.0;
        private function onTick(event:Event):void
        {
            if ( !mContext3d ) 
                return;
            
            mContext3d.clear ( 0, 0, 0, 1 );
            mContext3d.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, mMatrix, true);

            // RES
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, Vector.<Number>( [ 1, 1, 1, 1 ]) );
            
            // ONE
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 1, Vector.<Number>( [ 1, 1, 1, 1 ]) );
            
            // CONSTANTS
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 2, Vector.<Number>( [ 1, 2, .5, 7 ]) );
            
            // MORE CONSTANTS
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 3, Vector.<Number>([1, 0, Math.PI, 1, 1, 1 ]));
            
            // TIME
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 4, Vector.<Number>( [ mTime, mTime * .5, 1, 1 ]) );
            
            // MORE CONSTANTS
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 5, Vector.<Number>( [ .2, 3, .4, .7 ]) );
            
            
            // stuff for atan2
            
            //fc10 = [ 0, 1, -0.013480470, 0.057477314 ];
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 10, Vector.<Number>( [ 0, 1, -0.013480470, 0.057477314 ]) );
            //fc11 = [ -0.121239071, 0.195635925, -0.332994597, 0.999995630 ]
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 11, Vector.<Number>( [ -0.121239071, 0.195635925, -0.332994597, 0.999995630 ]) );
            //fc12 = [ 1.570796327, 3.141592654, 1, 1 ]
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 12, Vector.<Number>( [ 1.570796327, 3.141592654, 1, 1 ]) );
            
            mContext3d.drawTriangles(mIndexBuffer);
            mContext3d.present();
            
            mTime += .010;
        }
    }
}