/**
 * Copyright royi ( http://wonderfl.net/user/royi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/41q2
 */

package {
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.Sprite;
    public class Main extends Sprite {
        public static var inst:Main;
        public var debug:TextField = new TextField();
        private var sliders:Sprite = new Sprite();
        public function Main() {
            inst = this;
            
            debug.defaultTextFormat = new TextFormat("Arial", 16, 0xff00ff);
            debug.autoSize = "left";
            debug.x = debug.y = 20;
            dbg = "debug";
            
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            var slider1:Slider = new Slider(0, 100, 20, callback);
            var slider2:Slider = new Slider(0, 100, 50, callback, 0xffff00, 100, 8.3, 0);
            slider2.y = 30;
            var slider3:Slider = new Slider(0, 100, 100, callback, 0x00ffff, 150, 1, 4);
            slider3.y = 60;
            sliders.addChild(slider1);
            sliders.addChild(slider2);
            sliders.addChild(slider3);
            sliders.x = 20;
            sliders.y = 80;
            addChild(sliders);
            
            addChild(debug);
        }
        
        private function callback(value:int):void {
            dbg = String(value);
        }
        
        public function get dbg():String {
            return debug.text;
        }
        public function set dbg(text:String):void {
            debug.text = text;
        }
    }
}

import flash.geom.Rectangle;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.display.Sprite;

class Slider extends Sprite {
    private var minValue:Number;
    private var maxValue:Number;
    private var callback:Function;
    private var color:uint;
    private var track:Sprite = new Sprite();
    private var trackGlow:Sprite = new Sprite();
    private var handle:Sprite = new Sprite();
    private var bounds:Rectangle;
    private var trackLength:uint;
    private var trackThickness:uint;
    private var handleRadius:uint;
    private var mouseOut:Boolean;
    
    public function Slider(minValue:Object,
                           maxValue:Object,
                           initValue:Object,
                           callback:Function,
                           color:Object = 0xff00ff,
                           trackLength:uint = 100,
                           trackThickness:uint = 5,
                           handleRadius:uint = 5,
                           darkTheme:Boolean = false) {
        this.minValue = Number(minValue);
        this.maxValue = Number(maxValue);
        this.callback = callback;
        this.color = uint(color);
        this.trackLength = trackLength;
        this.trackThickness = trackThickness;
        this.handleRadius = handleRadius;
        
        bounds = new Rectangle(handleRadius, handleRadius, trackLength - (handleRadius * 2), 0);
        
        buttonMode = true;
        
        graphics.beginFill(0xff00ff, 0);
        graphics.drawRect(0, 0, trackLength, handleRadius * 2);
        graphics.endFill();
        
        var mask:Sprite = new Sprite();
        mask.graphics.beginFill(0xffffff);
        mask.graphics.drawRoundRect(0, 0, trackLength, trackThickness, trackThickness);
        mask.graphics.endFill();
        mask.y = handleRadius - int(trackThickness * .5);
        
        
        
        track.graphics.beginFill(0xffffff);
        track.graphics.drawRect(0, 0, trackLength, trackThickness);
        track.graphics.endFill();
        track.y = mask.y;
        track.mask = mask;
        
        trackGlow.graphics.beginFill( brightness(this.color, .7) );
        trackGlow.graphics.drawRect(0, 0, trackLength, trackThickness);
        trackGlow.graphics.endFill();
        
        if (handleRadius > 0) {
            handle.graphics.beginFill(uint(color));
            handle.graphics.drawCircle(0, 0, handleRadius);
            handle.graphics.endFill();
            handle.x = handleRadius;
            handle.y = handleRadius;
        }
        
        addChild(track);
        track.addChild(trackGlow);
        addChild(mask);
        addChild(handle);
        
        value = Number(initValue);
        
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    private function onMouseDown(e:MouseEvent):void {
        e.target.stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        e.target.stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        e.target.stage.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        e.target.stage.addEventListener(Event.MOUSE_LEAVE, onMouseLeave);
        mouseOut = false;
        handle.x = handle.parent.mouseX;
        if (handle.x < bounds.left) handle.x = bounds.left;
        if (handle.x > bounds.right) handle.x = bounds.right;
        handle.startDrag(false, bounds);
        callback(value);
        update();
    }
    
    private function onMouseUp(e:MouseEvent):void {
        e.target.stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        e.target.stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        e.target.stage.removeEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        e.target.stage.removeEventListener(Event.MOUSE_LEAVE, onMouseLeave);
        handle.stopDrag();
    }
    
    private function onMouseMove(e:MouseEvent):void { callback(value); update(); }
    
    private function onMouseOut(e:MouseEvent):void { mouseOut = true; }
    
    private function onMouseLeave(e:MouseEvent):void {
        if (mouseOut) {
            onMouseUp(e);
        }
    }
    
    private function update():void { trackGlow.width = handle.x; }
    
    private function brightness(color:uint, brightness:Number = 1):uint {
        var r:int = color >>> 16;
        var g:int = (color >>> 8) & 0xFF;
        var b:int = color & 0xFF;
        r = (uint)(r * brightness);
        g = (uint)(g * brightness);
        b = (uint)(b * brightness);
        if (r > 0xFF) {r = 0xFF;}
        if (g > 0xFF) {g = 0xFF;}
        if (b > 0xFF) {b = 0xFF;}
        return r << 16 | g << 8 | b;
    }

    
    private function get value():Number { return (handle.x - handleRadius) * (maxValue - minValue) / (trackLength - handle.width) + minValue; }
    private function set value(v:Number):void { handle.x = v + handleRadius; update(); }
}
