/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/40mO
 */

package {
    import flash.display.*;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            add(OpenIcon);
            add(BackIcon);
            add(PlayIcon);
            add(PauseIcon);
            add(StopIcon);
            add(NextIcon);
            add(SearchIcon);
            add(MuteIcon);
            add(Vol0Icon);
            add(Vol1Icon);
            add(Vol2Icon);
            add(Vol3Icon);
        }
        
        
        private var ax:Number = 50;
        private var ay:Number = 50;
        
        //アイコンボタン作成
        private function add(i:Class):void{
            var btn:IconBtn = new IconBtn(i);
            btn.init({width:40});
            //openBtn.text = "File";
            btn.x = ax;
            btn.y = ay;
            addChild(btn);
            ax += 50;
            if(400<ax){ 
                ay+=40; 
                ax=50;
            }
        }

    }
}



//////////////////////////////////////////////////
// IconBtnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;

class IconBtn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var icon:Shape;
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var upColorTrans:ColorTransform;
    private static var overColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private var cColor:uint = 0x0099FF;
    private var colorGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function IconBtn(Icon:Class) {
        icon = new Icon();
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        if (option.color != undefined) cColor = option.color;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        colorGlow = new GlowFilter(cColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        upColorTrans = new ColorTransform();
        upColorTrans.color = upColor;
        overColorTrans = new ColorTransform();
        overColorTrans.color = overColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(icon);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, cColor);
        light.filters = [colorGlow];
        createBase(base, _width, _height, corner, bColor);
        icon.y = -1;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        icon.y = -1;
        icon.transform.colorTransform = upColorTrans;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        icon.y = -1;
        icon.transform.colorTransform = overColorTrans;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        icon.y = 0;
        icon.transform.colorTransform = overColorTrans;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        icon.y = 0;
        icon.transform.colorTransform = offColorTrans;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        if (_clicked) {
            _down();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
        } else {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}




//////////////////////////////////////////////////
// Iconクラス
//////////////////////////////////////////////////

import flash.display.Shape;

class PlayIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function PlayIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(-4, -6);
        graphics.lineTo(-4, 6);
        graphics.lineTo(8, 0);
        graphics.endFill();
    }

}

class PauseIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function PauseIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-5, -5, 4, 10);
        graphics.endFill();
        graphics.beginFill(bColor);
        graphics.drawRect(3, -5, 4, 10);
        graphics.endFill();
    }

}

class StopIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function StopIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-5, -5, 10, 10);
        graphics.endFill();
    }

}

class NextIcon extends Shape {
    private static var bColor:uint = 0x000000;
    public function NextIcon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(-14, -6);
        graphics.lineTo(-14, 6);
        graphics.lineTo(0, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.moveTo(0, -6);
        graphics.lineTo(0, 6);
        graphics.lineTo(12, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(12,-6, 4, 12);
        graphics.endFill();
    }

}

class BackIcon extends Shape {
    private static var bColor:uint = 0x000000;
    public function BackIcon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(12, -6);
        graphics.lineTo(12, 6);
        graphics.lineTo(0, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.moveTo(0, -6);
        graphics.lineTo(0, 6);
        graphics.lineTo(-12, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(-15,-6, 4, 12);
        graphics.endFill();
    }

}

//検索
class SearchIcon extends Shape {
    private static var bColor:uint = 0x000000;
    public function SearchIcon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawCircle(0,-1,5);
        graphics.drawCircle(0,-1,6.2);
        graphics.endFill();
        
        graphics.lineStyle(3,bColor);
        graphics.moveTo(-7,7); 
        graphics.lineTo(-4,4);
    }

}

class Vol0Icon extends Shape {
    private static var bColor:uint = 0x000000;
    public function Vol0Icon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(3-3, -6);
        graphics.lineTo(3-3, 6);
        graphics.lineTo(-6-3, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(-6-3,-3, 8, 6);
        graphics.endFill();
        
    }

}

class Vol1Icon extends Shape {
    private static var bColor:uint = 0x000000;
    public function Vol1Icon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(3-3, -6);
        graphics.lineTo(3-3, 6);
        graphics.lineTo(-6-3, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(-6-3,-3, 8, 6);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(2,-3, 2, 6);
        graphics.endFill();
        
    }

}


class Vol2Icon extends Shape {
    private static var bColor:uint = 0x000000;
    public function Vol2Icon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(3-3, -6);
        graphics.lineTo(3-3, 6);
        graphics.lineTo(-6-3, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(-6-3,-3, 8, 6);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(2,-3, 2, 6);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(5,-5, 2, 10);
        graphics.endFill();
        
    }

}

class Vol3Icon extends Shape {
    private static var bColor:uint = 0x000000;
    public function Vol3Icon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(3-3, -6);
        graphics.lineTo(3-3, 6);
        graphics.lineTo(-6-3, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(-6-3,-3, 8, 6);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(2,-3, 2, 6);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(5,-5, 2, 10);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(8,-7, 2, 14);
        graphics.endFill();
    }

}

class MuteIcon extends Shape {
    private static var bColor:uint = 0x000000;
    public function MuteIcon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(3-3, -6);
        graphics.lineTo(3-3, 6);
        graphics.lineTo(-6-3, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(-6-3,-3, 8, 6);
        graphics.endFill();
        
        
        graphics.lineStyle(2,bColor);
        graphics.moveTo(3+6, -3);
        graphics.lineTo(-3+6, 3);
        graphics.moveTo(3+6, 3);
        graphics.lineTo(-3+6, -3);
        
        
        
    }

}
class OpenIcon extends Shape {
    private static var bColor:uint = 0x000000;
    public function OpenIcon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-8,4, 16, 3);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.moveTo(-8, 2);
        graphics.lineTo(8, 2);
        graphics.lineTo(0, -7);
        graphics.endFill();
    }

}





