/**
 * Copyright blamfantastico ( http://wonderfl.net/user/blamfantastico )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/40hn
 */

// forked from Nyarineko's 四畳半神話大系的な何か
package
{
    import flash.display.*;
    import flash.events.*;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;

    [SWF(width = "465", height = "465", backgroundColor = "0x505050")]
    public class Main extends Sprite
    {
        private const EZ:Number = .6; //速度が変わるよ！
        private var _tw:ITween;
        private var _container:Sprite = new Sprite();
        
        private var MAX:int = 20;
        private var _cnt:int = 0;
        private var _topBox:Box;
        private var _lastBox:Box;
        
        public function Main():void
        {
            var w:Number = Math.random()*200 + 50;
            var h:Number = Math.random()*200 + 50;
            var box:Box = new Box(w,h);
            _topBox = box;
            _lastBox = box;
            
            _container.rotationZ = Math.random() * 180 - 90;
            _container.x = 165;
            _container.y = 165;
                
            //_boxs = box;
            
            addChild(_container);
            _container.addChild(box);
            
            _tw = BetweenAS3.parallel(
                BetweenAS3.tween(box,{width:box.width},{width:0},EZ,Quint.easeInOut),
                BetweenAS3.tween(box,{height:box.height},{height:0},EZ,Quint.easeInOut));
            _tw.addEventListener(TweenEvent.COMPLETE,compTween);
            _tw.play();
        }
        
        private function compTween(e:TweenEvent):void
        {
            _tw.removeEventListener(TweenEvent.COMPLETE,compTween);
            _cnt++;
            
            var twArray:Array = [];
            var w:Number = Math.random()*200 + 50;
            var h:Number = Math.random()*200 + 50;
            
            var box:Box = _topBox;
            //途中の部屋
            while(box.linkBox){
                if(_lastBox.width>_lastBox.height){
                    twArray.push(BetweenAS3.parallel(
                        BetweenAS3.tween(box,{x:box.x - _lastBox.width/2},null,EZ,Quint.easeInOut),
                        BetweenAS3.tween(box,{y:box.y - _lastBox.height+2},null,EZ,Quint.easeInOut)
                    ));
                }else{
                    twArray.push(BetweenAS3.parallel(
                        BetweenAS3.tween(box,{x:box.x - _lastBox.width+2},null,EZ,Quint.easeInOut),
                        BetweenAS3.tween(box,{y:box.y - _lastBox.height/2},null,EZ,Quint.easeInOut)
                    ));
                }
                box = box.linkBox;
            }
            
            //最後の部屋と新しい部屋
            var box_new:Box = new Box(w,h);
            _container.addChild(box_new);
            
            if(box.width>box.height){
                twArray.push(BetweenAS3.parallel(
                    BetweenAS3.tween(box,{x:box.x - box.width/2},null,EZ,Quint.easeInOut),
                    BetweenAS3.tween(box,{y:box.y - box.height+2},null,EZ,Quint.easeInOut),
                    BetweenAS3.tween(box_new,{x:0},{x:box.width/2},EZ,Quint.easeInOut),
                    BetweenAS3.tween(box_new,{y:0},{y:box.height},EZ,Quint.easeInOut)
                ));
            }else{
                twArray.push(BetweenAS3.parallel(
                    BetweenAS3.tween(box,{x:box.x - box.width+2},null,EZ,Quint.easeInOut),
                    BetweenAS3.tween(box,{y:box.y - box.height/2},null,EZ,Quint.easeInOut),
                    BetweenAS3.tween(box_new,{x:0},{x:box.width},EZ,Quint.easeInOut),
                    BetweenAS3.tween(box_new,{y:0},{y:box.height/2},EZ,Quint.easeInOut)
                ));
            }
            twArray.push(BetweenAS3.parallel(
                BetweenAS3.tween(box_new,{width:w},{width:0},EZ,Quint.easeInOut),
                BetweenAS3.tween(box_new,{height:h},{height:0},EZ,Quint.easeInOut)));
            
            //新しい配列をリストに追加
            box.linkBox = box_new;
            _lastBox = box_new;
            //１０個以上になったら古いの消すよ
            if(_cnt > 10){
                var bufBox:Box = _topBox.linkBox;
                _container.removeChild(_topBox);
                _topBox = bufBox;
            }
            //ちょいちょい角度を変えてみる
            if(_cnt % 3 == 0){
                twArray.push(BetweenAS3.tween(_container,{rotationZ:Math.random() * 180 - 90},null,EZ,Quint.easeInOut),
                BetweenAS3.tween(_container,{z:Math.random() * 1000},null,EZ,Quint.easeInOut));
            }
            _tw = BetweenAS3.parallelTweens( twArray );
            _tw.addEventListener(TweenEvent.COMPLETE,compTween);
            
            _tw.play();
        }
    }
}

import flash.display.Sprite;

class Box extends Sprite
{
    public var linkBox:Box = null;
    public function Box(w:Number,h:Number):void
    {
        var lineColor:uint = 0x000000;
        var fillColor:uint = randomColor(); 
        
        graphics.lineStyle();
        graphics.beginFill(fillColor);
        graphics.drawRect(0,0,w,h);
        graphics.endFill();
    }
}

  /**
  * Get a random color.
  * @param col Base Color to randomly vary from.
  * @param hue.
  * @param saturation.
  * @param lightness.
  */
  function randomColor(baseH:int = 180, rangeH:Number = 360, baseS:Number = 1, rangeS:Number = 0, baseL:Number = 0.5, rangeL:Number = 0):uint {
     var hsl:Object = {hue: baseH, saturation: baseS, lightness: baseL}; 
     var hrand:int = (hsl.hue - rangeH/2 + Math.random()*rangeH)%360;
     var srand:Number = Math.max(0,Math.min(1,hsl.saturation - rangeS/2 + Math.random()*rangeS));
     var lrand:Number = Math.max(0,Math.min(1,hsl.lightness - rangeL/2 + Math.random()*rangeL));
     
     var col:uint = HSLtoRGB(1, hrand, srand, lrand);
     return col
  }
  
 /**
  * Convert HSL to RGB.
  * http://en.wikipedia.org/wiki/HSL_and_HSV#From_HSL
  * @param a Alpha.
  * @param h Hue
  * @param s Saturation
  * @param l Lightness
  */
  function HSLtoRGB(a:Number=1, h:Number=0, s:Number=0.5, l:Number=1):uint{
     h = h % 360;
     if (h < 0) h += 360;
     h /= 60;
     s = Math.min(1, Math.max(0, s));
     l = Math.min(1, Math.max(0, l));;
     a = Math.min(1, Math.max(0, a));;
     var c:Number = (1 - Math.abs((2 * l) - 1)) * s;
     var x:Number = c * (1 - Math.abs((h % 2) - 1));
     var m:Number = (l - (c / 2)) * 255;
     var cm:Number = (c * 255) + m;
     var xm:Number = (x * 255) + m;
     var rgb:uint = uint(a * 255) << 24;
     if (h < 1)      rgb |= (cm << 16) | (xm << 8) | m;
     else if (h < 2) rgb |= (xm << 16) | (cm << 8) | m;
     else if (h < 3) rgb |= (m  << 16) | (cm << 8) | xm;
     else if (h < 4) rgb |= (m  << 16) | (xm << 8) | cm;
     else if (h < 5) rgb |= (xm << 16) | (m  << 8) | cm;
     else if (h < 6) rgb |= (cm << 16) | (m  << 8) | xm;
     return rgb;
  }
  
  
  
  
  
 
  
  