/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/40Uy
 */

// forked from atsonic's 動体検知のテスト
package
{
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.filters.ConvolutionFilter;
    /**
     * 動体検知のテスト。
     * 精度は微妙。
     * @author atsonic
     */
    public class FlashTest extends Sprite
    {
        private var cameraW:uint;
        private var cameraH:uint;
        private var _camera:Camera;
        private var _video:Video;
        private var _bmp:Bitmap;
        private var _bmd:BitmapData;
        private var _rect:Rectangle;
        private var _point:Point;
        private var _type:String;
        private var _typeArray:Array;
        private var _now:BitmapData;
        private var _old:BitmapData;
        private var _square:Sprite;
        private var _convolutionFilter:ConvolutionFilter;
        /**
         * constructor
         */
        public function FlashTest ()
        {
            cameraW = 465;
            cameraH = 465;
            _rect = new Rectangle(0, 0, cameraW, cameraH);
            _point = new Point(0, 0);
            _type = "normal";
            
            _camera = Camera.getCamera();
            if (_camera != null)
            {
                stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
                _camera.setMode(cameraW / 2, cameraH / 2, 30);
                _video = new Video(cameraW, cameraH);
                _video.attachCamera(_camera);
            }
            else
            {
                trace("You need a camera.");
            }
            var array:Array = [1,  1,  1,
                           1,  16,  1,
                       1,  1,  1];
            _convolutionFilter = new ConvolutionFilter(3, 3, array);
            _convolutionFilter.bias = -(0x1000 + 0x100 * 6);

            _bmd = new BitmapData(cameraW, cameraH , false, 0xFFFFFF);
            _bmp = new Bitmap(_bmd);
            _bmp.x = (stage.stageWidth - cameraW) / 2;
            _bmp.y = (stage.stageHeight - cameraH) / 2;
            //_bmp.alpha = 0.8;
            addChild(_video);
            addChild(_bmp);
            _square = new Sprite();
            addChild(_square);
            _now = new BitmapData(cameraW, cameraH);
            _old = new BitmapData(cameraW, cameraH);
        }
        /**
         * enterFrameHandler
         * @param event Event
         */
        private function enterFrameHandler(event:Event):void
        {
            if (_video == null || _camera == null)
            {
                return;
            }
            if (_camera.muted == true)
            {
                return;
            }
            _now.draw(_video);
            _now.draw(_old, new Matrix(), new ColorTransform(), BlendMode.DIFFERENCE);
            _now.threshold(_now, _rect, _point, ">", 0xff111111, 0xffffffff);
            _now.applyFilter(_now, _rect, _point, _convolutionFilter);
            _old.draw(_video);
            
            _bmd.lock();
            _bmd.copyPixels(_now, _rect, _point);
            _bmd.unlock();
            /*
            var rect:Rectangle = _bmd.getColorBoundsRect( 0xFFFFFFFF, 0xFFFFFFFF, true );
            _square.graphics.clear();
            _square.graphics.lineStyle(1, 0xFF0000);
            _square.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
            */
                        
        }
    }
}