/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/40SM
 */

// forked from siouxcitizen's Away3D Gold Practice06 Cube 5つ表示
// forked from siouxcitizen's Away3D Gold Practice05 光のあて方よくわからない。。。
// forked from siouxcitizen's Away3D Gold Practice04 SphereとWireframeSphere表示
// forked from siouxcitizen's Away3D Gold Practice03 WireframePlane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice02 Plane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice01 Plane 1枚表示
//Away3D 4.0 Gold で複数Cubeを表示してみました
//
package {
    import away3d.containers.View3D;
    import away3d.containers.Scene3D;
    import away3d.cameras.Camera3D;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.materials.ColorMaterial;
    import away3d.primitives.CubeGeometry;
    import away3d.primitives.PrimitiveBase;
    import away3d.lights.DirectionalLight;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.lights.PointLight;

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Vector3D;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    public class SphereSample extends Sprite {

        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private var _view : View3D;
        private var _scene : Scene3D;
        private var _camera : Camera3D;
        private var _cubeGeo : PrimitiveBase;
        private var _cubeMat : ColorMaterial;
        private var _cube01 : Mesh;
        private var _cube02 : Mesh;
        private var _cube03 : Mesh;
        private var _cube04 : Mesh;
        private var _cube05 : Mesh;
        private var _direcLight : DirectionalLight;
        private var _pointLight : PointLight;
        public function SphereSample() {

            _view = new View3D();
            _scene = _view.scene;
            _camera = _view.camera;
            addChild(_view);

            _view.antiAlias = 0;
            _view.backgroundColor = 0x222222;

            _direcLight = new DirectionalLight();
            _direcLight.direction = new Vector3D(1, -1, 1);
            _direcLight.specular = 0.1;
            _direcLight.diffuse = 0.9;
            _direcLight.ambient = 0.1;
            _scene.addChild(_direcLight);

            var lightPicker:StaticLightPicker = new StaticLightPicker([_direcLight]);

            _cubeMat =  new ColorMaterial(0xff0000, 1);
            _cubeGeo = new CubeGeometry(160, 160, 160, 1, 1, 1);
            _cubeMat.lightPicker = lightPicker;
            _cube01 = new Mesh(_cubeGeo, _cubeMat);
            _cube01.y += 250;
            _scene.addChild(_cube01);

            _cubeMat =  new ColorMaterial(0x00ff00, 1);
            _cubeGeo = new CubeGeometry(160, 160, 160, 1, 1, 1);
            _cubeMat.lightPicker = lightPicker;
            _cube02 = new Mesh(_cubeGeo, _cubeMat);
            _cube02.x = -250;
            _scene.addChild(_cube02);

            _cubeMat =  new ColorMaterial(0x0000ff, 1);
            _cubeGeo = new CubeGeometry(160, 160, 160, 1, 1, 1);
            _cubeMat.lightPicker = lightPicker;
            _cube03 = new Mesh(_cubeGeo, _cubeMat);
            _cube03.x = 250;
            _scene.addChild(_cube03);

            _cubeMat =  new ColorMaterial(0xffff00, 1);
            _cubeGeo = new CubeGeometry(160, 160, 160, 1, 1, 1);
            _cubeMat.lightPicker = lightPicker;
            _cube04 = new Mesh(_cubeGeo, _cubeMat);
            _cube04.y = -250;
            _scene.addChild(_cube04);

            _cubeMat =  new ColorMaterial(0xff00ff, 1);
            _cubeGeo = new CubeGeometry(100, 100, 100, 1, 1, 1);
            //_cubeMat.lightPicker = lightPicker;
            _cube05 = new Mesh(_cubeGeo, _cubeMat);
            _cube05.x = 0;
            _cube05.y = 0;
            _scene.addChild(_cube05);
            
            _camera.x = -600;
            _camera.y = -600;
            _camera.z = -1200;

            addEventListener(Event.ENTER_FRAME, update);
                   
            addChild(new AwayStats());
        }

        private function update(event : Event) : void {

            _cube01.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _cube01.rotationY = -(stage.mouseX - (stage.stageWidth >> 1));

            _cube02.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _cube02.rotationY = -(stage.mouseX - (stage.stageWidth >> 1));

            _cube03.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _cube03.rotationY = -(stage.mouseX - (stage.stageWidth >> 1));

            _cube04.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _cube04.rotationY = -(stage.mouseX - (stage.stageWidth >> 1));

            _cube05.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _cube05.rotationY = -(stage.mouseX - (stage.stageWidth >> 1));

            _camera.lookAt(ZERO);
            _view.render();
        }
    }
}