/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/40KI
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
          stage.addEventListener(Event.ENTER_FRAME, onEnter);  
        }//ctor
        
        public var cx:Number = 230;
        public var cy:Number = 230; 
        public var cz:Number = 0; 
    
        public var wx:Number = 0;    public var wy:Number = 0;    public var wz:Number = 0;
    
        public var ori:xQuat = new xQuat();
        public var tq:xQuat = new xQuat();
    
        public function addImp(ax:Number, ay:Number, az:Number, ix:Number, iy:Number, iz:Number):void
        {
          var kx:Number; var ky:Number; var kz:Number;
          
          graphics.moveTo(ax,ay);
          graphics.lineTo(ax+ix*32,ay+iy*32);
          
          kx = ((ay - cy) * iz) - ((az - cz) * iy);
          ky = ((az - cz) * ix) - ((ax - cx) * iz);
          kz = ((ax - cx) * iy) - ((ay - cy) * ix);
      
          wx += kx * 0.0001;
          wy += ky * 0.0001;
          wz += kz * 0.0001;
          
        }//addimp
    
        
        public function onEnter(e:Event):void
        {
            var mx:Number; var my:Number;
            mx = stage.mouseX; my = stage.mouseY;
            
            graphics.clear();
            graphics.lineStyle(2, 0);
    
            addImp(230, my, 0,  0.5, 0, 0);
            wx *= 0.98; wy *= 0.98; wz *= 0.98;
            
            tq.w = 0;      tq.x = 0.5 * wx;      tq.y = 0.5 * wy;      tq.z = 0.5 * wz;      
            tq.mul(ori);  
            ori.w += tq.w;      ori.x += tq.x;      ori.y += tq.y;      ori.z += tq.z;
            ori.normalise();

            graphics.drawCircle(cx, cy ,8);
            graphics.drawCircle(cx,cy, 64);
            
            graphics.moveTo(cx,cy);
            graphics.lineTo(cx+ori.getSideVx()*64, cy+ori.getSideVy()*64);
            
        }//onenter
        
    }//classend
}

internal class xQuat
{
 public var x:Number = 0;        public var y:Number = 0;    
 public var z:Number = 0;        public var w:Number = 1;
 
   public function normalise():void
  { var mag:Number;  mag = (x * x) + (y * y) + (z * z) + (w * w);
    if (mag == 1.0) return; //already normal
    if (mag == 0) { x = 0;  y = 0;  z = 0;  w = 1; return; }
    mag = 1.0 / Math.sqrt(mag);  x *= mag; y *= mag; z *= mag; w *= mag;
  }//norm
  
  public function mul(a:xQuat):void
  {
    var tx:Number; var ty:Number; var tz:Number; var tw:Number;
    tx = (w * a.x + x * a.w + y * a.z - z * a.y);   ty = (w * a.y + y * a.w + z * a.x - x * a.z);
    tz = (w * a.z + z * a.w + x * a.y - y * a.x);   tw = (w * a.w - x * a.x - y * a.y - z * a.z);
    x = tx;   y = ty;  z = tz;    w = tw;
  }//mul
 
  public function getFrontVx():Number    { return  2.0 * ( x*z + y*w ); }        
  public function getFrontVy():Number    { return  2.0 * ( y*z - x*w );     }        
  public function getFrontVz():Number    { return  1.0 - 2.0 * ( x*x + y*y );  }
      
  public function getSideVx():Number     { return 1.0 - 2.0 * ( y * y + z * z ); }        
  public function getSideVy():Number     { return 2.0 * ( x * y + z * w ); }    
  public function getSideVz():Number     { return  2.0 * ( x * z - y * w ); }

 
}//xquat