/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3zyI
 */

/*
Matrix3D.prependScale();
と同じ機能の関数を作ってみる。
MAC 10,0,2,54,MAC 10,0,12,36で動作確認。


処理としては
パラメーターで作った行列にentity行列をprependする。

パラメーターで作る行列は
scaleを変えるだけなので対角行列になるが、
これはめんどくさいだけなので、
行列は作らずに、対応する要素毎に乗算するのみ。


各要素をrandomで値を入れて、prependScaleし、
行列の各要素を比較して確認とした。

prependScale
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/geom/Matrix3D.html#prependScale()

*/
package {
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.text.TextField;
	import flash.geom.Vector3D;
	import flash.system.Capabilities;
	public class FlashTest extends Sprite {
		public function FlashTest() {
			var txt:String="◆同機能関数Mtrx3D.prependScale\n"+Capabilities.version+"での実行結果\n\n";
			
			//確認用の値を用意
			var entity:Matrix3D=new Matrix3D(Util.random16());
			var parameter:Matrix3D=new Matrix3D(Util.random16());
			var entity1:Matrix3D=entity.clone();
			var entity2:Matrix3D=entity.clone();
			var xScale:Number=Math.random()*200-100;
			var yScale:Number=Math.random()*200-100;
			var zScale:Number=Math.random()*200-100;
			
			//実行
			entity1.prependScale(xScale,yScale,zScale);
			Mtrx3D.prependScale(entity2,xScale,yScale,zScale);
			
			//確認
			var entity1RawData:Vector.<Number>=entity1.rawData;
			txt+="↓Matrix3D.prependScaleの結果\n"+entity1RawData+"\n";
			var entity2RawData:Vector.<Number>=entity2.rawData;
			txt+="\n↓同機能関数Mtrx3D.prependScaleの結果\n"+entity2RawData+"\n\n";
			txt+=Util.hikaku(entity1RawData,entity2RawData);
			
			//テキストフィールドを作りtxtを流し込み。
			var tf:TextField = new TextField();
			tf.width=stage.stageWidth;
			tf.height=stage.stageHeight;
			tf.wordWrap=true;
			stage.addChild(tf);
			tf.text=txt;
		}
	}
}
import flash.display.Sprite;
class Mtrx3D extends Sprite {
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	public static function prependScale(entity:Matrix3D,xScale:Number,yScale:Number,zScale:Number):void {
		var e:Vector.<Number>=Vector.<Number>(entity.rawData);
		e[0]*=xScale;
		e[1]*=xScale;
		e[2]*=xScale;
		e[3]*=xScale;
		e[4]*=yScale;
		e[5]*=yScale;
		e[6]*=yScale;
		e[7]*=yScale;
		e[8]*=zScale;
		e[9]*=zScale;
		e[10]*=zScale;
		e[11]*=zScale;
		entity.rawData=e;
	}
}
class Util {
	public static function hikaku(v0:Vector.<Number>,v1:Vector.<Number>):String {
		var _str:String="↓二つのMatrix3Dの要素毎の差\n";
		var _n:int=v0.length;
		for (var i:int=0; i<_n; i++) {
			_str += "["+i+"]:"+(v0[i]-v1[i])+"\n";
		}
		return _str;
	}

	public static function random16():Vector.<Number> {
		var _v:Vector.<Number>=new Vector.<Number>(16,true);
		for (var i:int=0; i<16; i++) {
			_v[i]=Math.random()*200-100;
		}
		return _v;
	}
}