/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3zeZ
 */

// forked from Akiyah's QuickBox2D でぽにょぽにょさせてみた
package {
    import flash.events.Event;
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;
    import Box2D.Common.Math.b2Vec2;
    import com.bit101.components.PushButton;
    import com.bit101.components.TextArea;

    public class JointGrid extends MovieClip {
        private var frequencyHz:Number = 4;
        private const distance:Number = 1;
        private const dotNum:int = 4 + 1;
        private var sim:QuickBox2D;
        private var bGravity:Boolean;
        private var t:TextArea;
        private var dots:Array;
        

        public function JointGrid() {
            sim = new QuickBox2D(this, { debug:false });
            sim.gravity = new b2Vec2(0,10);
            bGravity = true;
            var center:Point = new Point(7*distance, 7*distance);
            dots = [];
            var i:int;
            var j:int;
            var dot:QuickObject;
            var angularDistance:Number = Math.PI * 2 / (dotNum)
            for (j = 0; j < dotNum; j++) {
                var line:Array = [];
                dots.push(line);
                for (i = 0; i < dotNum; i++) {
                    dot = sim.addCircle( 
                    {
                        x:center.x + (j+1)*distance*Math.cos(i*angularDistance),
                        y:center.y + (j+1)*distance*Math.sin(i*angularDistance),
                        radius:0.3,
                        groupIndex:-1,
                        fixedRotation:true,
                        friction:0.1,
                        density:1,
                        linearDamping:1,
                        allowSleep:false
                    });
                                    
                    line.push(dot);
                }
            }
            for (j = 0; j < dotNum; j++) {
                for (i = 1; i < dotNum; i++) {
                    addJoint(j,i-1,j,i,0xff0000);
                    addJoint(i-1,j,i,j,0x00ff00);
                }
            }

            for (j = 1; j < dotNum; j++) {
                for (i = 1; i < dotNum; i++) {
                    addJoint(j-1,i-1,j,i,0xff00ff);
                    addJoint(j-1,i,j,i-1,0xff9900);
                }
            }
            i = 0;
            for (i = 0; i < 5; i++) {
                addJoint(i,dotNum-1,i,0,0xff0000);
            }
            for (j = 1; j < dotNum; j++) {
                addJoint(j-1,dotNum-1,j,0,0xff00ff);
                addJoint(j-1,0,j,dotNum-1,0xff9900);
            }
            
            sim.createStageWalls(); 
            sim.start();  
            //sim.w.Step(sim.timeStep, sim.iterations);
            sim.mouseDrag();        
            new PushButton(this,0,0,"g",gravityToggle);
            new PushButton(this,105,0,"step",step);
            t = new TextArea(this, 200, 0, "");
            t.visible = false;
        }
        
        private function addJoint(h:int,i:int,j:int,k:int,colorArg:uint=0):void 
        {
            sim.addJoint({a:dots[ h ][ i ].body, b:dots[ j ][ k ].body, frequencyHz:frequencyHz,lineColor:colorArg});
        }
        
        
        private function step(e:Event):void 
        {
            
        }
        private function cTrace(msg:String):void
        {
            t.text +="\n"+msg;
        }

        private function gravityToggle(e:Event):void
        {
            bGravity=!bGravity;
            sim.stop();
            if(bGravity)
            {
               cTrace('true');
               //sim.w.SetGravity(new b2Vec2(0,10));
               sim.gravity = new b2Vec2(0,10);
            }
            else
            {
                cTrace('false');
                //sim.w.SetGravity(new b2Vec2(0,0));
                sim.gravity = new b2Vec2(0,0);
           }
            sim.start();
        }

    }
}

//