/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3zdl
 */

/*
UIのライブラリ「minimalcomps」のテスト

用意されているコンポーネント
0.
Component：以下、全てComponentのサブクラス
Panel
Window

1.ボタン
PushButton
RadioButton
CheckBox
RotarySelector：円形セレクター（初期値は2択）

2.スライダー
Slider：HSlider、VSliderの元
UISlider：HUISlider、VUISliderの元　スライダの値が最初から表示される
HSlider：横スライダ
VSlider：縦スライダ
HUISlider
VUISlider
Knob：円形スライダー
Meter：ガソリンメーター風スライダ？

3.テキスト
Label
Text
InputText

4.カラー
ColorChooser
Style：Panel全体の色を変更？初期化？（Componentのサブクラスではない）

5.その他
ProgressBar
WheelMenu：円グラフみたいなメニュー
IndicatorLight：光るもの


参考URL
http://hikipuro.is-a-geek.org/flash/game/sample/s092.php
*/

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import com.bit101.components.*;
    
    public class FlashTest extends Sprite {
        private var wheelMenu:WheelMenu;
        private var panel:Panel;
        private var infoLabel:Label;
        private var iLight:IndicatorLight;
        private var sliderWindow:Window;
        private var selectorWindow1:Window;
        private var selectorWindow2:Window;
        private var textWindow:Window;
        private var labelArray:Array = ["sliderWindow","selectorWindow1","selectorWindow2", "textWindow"];
        
        public function FlashTest() {
            //addChildしなくても、最初の引数に入れれば初期化時に勝手にやってくれる
            /*
                引数1：コンテナ:DisplayObjectContainter = null
                引数2：x座標:Number = 0
                引数1：y座標:Number = 0
                引数2：ラベル:String = ""
                引数2：イベントハンドラ:Function（MouseEvent.CLICK）= null
            */
            var bt0:PushButton = new PushButton(this, 20, 20, "Button01",showMenu);
            //addChildするパターン
            var bt2:PushButton = new PushButton();
            addChild(bt2);
            bt2.x = 20;
            bt2.y = 50;
            bt2.label = "Button02";
            bt2.addEventListener(MouseEvent.CLICK, showPanel);
            
            wheelMenu = new WheelMenu(this,5,30,5);
            wheelMenu.hide();
            
            var infoPanel:Panel = new Panel(this,0,stage.stageHeight-20);
            infoPanel.setSize(stage.stageWidth,20);
            infoPanel.color = 0xcccccc;
            infoLabel = new Label(infoPanel,6,0,"a");
            setWindow();

            var rSelector:RotarySelector = new RotarySelector(this,270,20,"RotarySelector",indicateLight);
            rSelector.numChoices = 3; //選択肢の数
            rSelector.labelMode = "numeric";
            var knob:Knob = new Knob(this, 180, 20,"Knob");
            var meter:Meter = new Meter(this, 180, 120, "Meter");
            iLight = new IndicatorLight(this, 350, 50,0xff5555,"IndicatorLight");
            iLight.isLit = true;
        }
        
        private function setWindow():void{
            //SliderWindow
            sliderWindow = new Window(null, 100, 100, "sliderWindow");
            sliderWindow.setSize(250,160);
            var hSlider:HSlider = new HSlider(sliderWindow, 10, 100);
            var huiSlider:HUISlider = new HUISlider(sliderWindow,1, 120);
            var vSlider:VSlider = new VSlider(sliderWindow, 200, 30);
            var vuiSlider:VUISlider = new VUISlider(sliderWindow, 220, 8);
            var closeBt00:PushButton = new PushButton(sliderWindow,230,3,"x",closeWindow);
            closeBt00.width = 15;
            closeBt00.height = 15;
            
            //CheckBox，RadioButtonWindow
            selectorWindow1 = new Window(null, 100, 100, "selectorWindow1");
            selectorWindow1.setSize(190,100);
            var chkBox0:CheckBox = new CheckBox(selectorWindow1, 15, 30, "CheckBox0");
            var chkBox1:CheckBox = new CheckBox(selectorWindow1, 15, 45, "CheckBox1");
            var chkBox2:CheckBox = new CheckBox(selectorWindow1, 15, 60, "CheckBox2");
            var chkBox3:CheckBox = new CheckBox(selectorWindow1, 15, 75, "CheckBox3");
            var rdoBt0:RadioButton = new RadioButton(selectorWindow1, 100, 30, "RadioButton1");
            var rdoBt1:RadioButton = new RadioButton(selectorWindow1, 100, 45, "RadioButton2");
            var rdoBt2:RadioButton = new RadioButton(selectorWindow1, 100, 60, "RadioButton3");
            var rdoBt3:RadioButton = new RadioButton(selectorWindow1, 100, 75, "RadioButton4");
            var closeBt01:PushButton = new PushButton(selectorWindow1,170,3,"x",closeWindow);
            closeBt01.width = 15;
            closeBt01.height = 15;
            
            //RadioButtonWindow
            //RadioButtonはステージ内で一つしか選べないらしい．
            selectorWindow2 = new Window(null, 100, 100, "selectorWindow2");
            selectorWindow2.setSize(230,160);
            var radioPanel1:Panel = new Panel(selectorWindow2,10,30);
            radioPanel1.setSize(100,120);
            var rdoBtA0:RadioButton = new RadioButton(radioPanel1, 10, 10, "RadioButtonA1");
            var rdoBtA1:RadioButton = new RadioButton(radioPanel1, 10, 27, "RadioButtonA2");
            var rdoBtA2:RadioButton = new RadioButton(radioPanel1, 10, 44, "RadioButtonA3"); 
            var rdoBtA3:RadioButton = new RadioButton(radioPanel1, 10, 61, "RadioButtonA4");
            var rdoBtA4:RadioButton = new RadioButton(radioPanel1, 10, 78, "RadioButtonA5");
            var rdoBtA5:RadioButton = new RadioButton(radioPanel1, 10, 95, "RadioButtonA6");
            var radioPanel2:Panel = new Panel(selectorWindow2,120,30);
            radioPanel2.setSize(100,120);
            var rdoBtB0:RadioButton = new RadioButton(radioPanel2, 10, 10, "RadioButtonB1");
            var rdoBtB1:RadioButton = new RadioButton(radioPanel2, 10, 27, "RadioButtonB2");
            var rdoBtB2:RadioButton = new RadioButton(radioPanel2, 10, 44, "RadioButtonB3"); 
            var rdoBtB3:RadioButton = new RadioButton(radioPanel2, 10, 61, "RadioButtonB4");
            var rdoBtB4:RadioButton = new RadioButton(radioPanel2, 10, 78, "RadioButtonB5");
            var rdoBtB5:RadioButton = new RadioButton(radioPanel2, 10, 95, "RadioButtonB6");
            var closeBt02:PushButton = new PushButton(selectorWindow2,210,3,"x",closeWindow);
            closeBt02.width = 15;
            closeBt02.height = 15;
            
            //TextWindow
            textWindow = new Window(null, 100, 100, "textWindow");
            textWindow.setSize(250,160);
            var label:Label = new Label(textWindow, 25, 25, "Label");
            var text:Text = new Text(textWindow, 25, 45, "Text");
            var inputText:InputText = new InputText(textWindow, 60, 25, "InputText");
            var closeBt03:PushButton = new PushButton(textWindow,230,3,"x",closeWindow);
            closeBt03.width = 15;
            closeBt03.height = 15;
        }
        
        private function indicateLight(event:Event):void{
            switch(event.target.choice){
                case 0:
                    iLight.isLit = true;
                break;
                case 1:
                    iLight.isLit = true;
                    iLight.flash(300);
                break;
                case 2:
                    iLight.isLit = false;
                break;
            }
        }
        
        private function showMenu(event:MouseEvent):void{
            if(wheelMenu) wheelMenu.show();
        }
        private function showPanel(event:MouseEvent):void{
            if(!panel){
                panel = new Panel(null,120,50);
                panel.setSize(104,114);

                var menuBt:PushButton;
                for(var i:uint;i<4;i++){
                    menuBt = new PushButton(panel,2,22*i+2,"show "+labelArray[i],hidePanel);
                }
                menuBt = new PushButton(panel,2,22*i+2,"close",hidePanel);
            }
            this.addChild(panel);
            //stage.addEventListener(MouseEvent.MOUSE_UP, hidePanel);
        }
        private function hidePanel(event:MouseEvent):void{
            var num:int = panel.getChildIndex(event.target as Sprite) - (panel.numChildren-5);
            var show:Boolean = (event.target.label.indexOf("show") == 0 ? true : false);
            infoLabel.text = event.target.label;
            switch(num){
                case 0:
                    if(show) {
                        this.addChild(sliderWindow);
                        event.target.label = "hide " + labelArray[0];
                    }
                    else {
                        event.target.label = "show " + labelArray[0];
                        this.removeChild(sliderWindow);
                    }
                break;
                case 1:
                    if(show) {
                        this.addChild(selectorWindow1);
                        event.target.label = "hide " + labelArray[1];
                    }
                    else {
                        event.target.label = "show " + labelArray[1];
                        this.removeChild(selectorWindow1);
                    }
                break;
                case 2:
                    if(show) {
                        this.addChild(selectorWindow2);
                        event.target.label = "hide " + labelArray[2];
                    }
                    else {
                        event.target.label = "show " + labelArray[2];
                        this.removeChild(selectorWindow2);
                    }
                break;
                case 3:
                    if(show) {
                        this.addChild(textWindow);
                        event.target.label = "hide " + labelArray[3];
                    }
                    else {
                        event.target.label = "show " + labelArray[3];
                        this.removeChild(textWindow);
                    }
                break;
            }
            this.removeChild(panel);
        }
        private function closeWindow(event:MouseEvent):void{
            this.removeChild(event.target.parent);
            var label:String = event.target.parent.title;
            (panel.getChildAt(labelArray.indexOf(label)+(panel.numChildren-5)) as PushButton).label = "show " + label;
        }
    }
}