/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3zEx
 */

// forked from fukt's forked from: Lines Instrument
// forked from zonnbe's Lines Instrument
package  {
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import frocessing.color.ColorHSV;
    
    public class line_music extends Sprite {
        private var soundBank:SoundBank = new SoundBank();
        private var dragging:Boolean = false;
        
        private var d:Array;
        private var lines:Array = new Array();
        private var slineA:Array = new Array();
        private var slineB:Array = new Array();
        private var line:MovieClip = new MovieClip();
        private var color:ColorHSV = new ColorHSV(0);
        private var current_lt:M;
        private var rleft:Boolean = false;
        private var rright:Boolean = false;
        private var rotate:Number = 0;
        private var cp:Dot = new Dot(stage.stageWidth/2, stage.stageHeight/2);

        public function line_music() {
            soundBank.addEventListener("loadComplete", loadGraphic);
        }
        
        private function loadGraphic(e:Event = null):void
        {
            init();
        }
        
        private function init(e:Event = null):void
        {
            var i:int = 0;
            var w:Number = stage.stageWidth / (soundBank.sounds.length+1);
            with(graphics)
            {
                for(i = 0; i < soundBank.sounds.length; i++)
                {
                    slineA.push(new Dot((i+1)*w, 0));
                    slineB.push(new Dot((i+1)*w, stage.stageHeight));
                }
            }
            addChild(line);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onmouseDown);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onmouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onmouseUp);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onkeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onkeyUp);
            stage.addEventListener(Event.ENTER_FRAME, processing);
        }

        private function processing(e:Event):void
        {
            update();
            paint();
        }
        
        private function update():void
        {
            var i:int = 0;
            
            for(i = 0; i < lines.length; i++)
            {
                if(lines[i].id != -1)
                {
                    
                    lines[i].animate();
                }
            }
            if(rleft) rotate -= 0.005;
            if(rright) rotate += 0.005;
            rotate *= 0.9;
            for(i = 0; i < slineA.length; i++)
            {
                slineA[i].rotate_around(cp, rotate);
                slineB[i].rotate_around(cp, rotate);
            }
        }
        
        private function paint():void
        {
            var i:int = 0;

            with(graphics)
            {
                clear();
                for(i = 0; i < slineA.length; i++)
                {
                    color.h = i*(3);
                    lineStyle(0.1, color.value);
                    moveTo(slineA[i].x, slineA[i].y);
                    lineTo(slineB[i].x, slineB[i].y);
                }
            }
        }
        
        private function onmouseDown(e:MouseEvent):void
        {
            dragging = true;
            current_lt = new M(lines.length, soundBank, mouseX, mouseY, slineA, slineB);
            lines.push(current_lt);
            addChild(current_lt);
        }
        
        private function onmouseMove(e:MouseEvent):void
        {
            if(dragging)
            {
                current_lt.record(mouseX, mouseY);
            }
        }
        
        private function onmouseUp(e:MouseEvent):void
        {
            dragging = false;
            current_lt.halt();
        }
        
        private function onkeyDown(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.LEFT:
                    rleft = true;
                    break;
                case Keyboard.RIGHT:
                    rright = true;
                    break;
            }
        }
        
        private function onkeyUp(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.LEFT:
                    rleft = false;
                    break;
                case Keyboard.RIGHT:
                    rright = false;
                    break;
            }
        }
    }
    
}

import flash.geom.Point;
import flash.display.MovieClip;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.text.TextField;
import flash.text.TextFormat;
import frocessing.color.ColorHSV;

class M extends MovieClip
{
    private var d:Array = new Array();
    private var current:Dot;
    private var target:Dot;
    private var last_dot:Dot;
    private var soundBank:SoundBank;
    public var id:int = -1;
    private var count:int = 0;
    private var pA:Dot = new Dot();
    private var pB:Dot = new Dot();
    private var lA:Array;
    private var lB:Array;
    private var len:Array = new Array();
    private var lightOfLine:MovieClip = new MovieClip();
    private var color:ColorHSV = new ColorHSV(0);
    
    public function M(id:int, s:SoundBank, px:Number, py:Number, la:Array, lb:Array)
    {
        addChild(lightOfLine);
        lightOfLine.x = -9999;
        with(lightOfLine.graphics)
        {
            beginFill(0xFF0000);
            drawRect(0,0,30,30);
            endFill();
        }
        soundBank = s;
        d.push(new Dot(px, py));
        current = d[d.length-1];
        lA = la;
        lB = lb;
    }
    
    public function record(px:Number, py:Number):void
    {
        if(px == current.x && py == current.y)
        {
            current.t++;
        } else {
            push(px, py);
        }
    }
    
    private function push(px:Number, py:Number):void
    {
        last_dot = d[d.length-1];
        d.push(new Dot(px, py));
        current = d[d.length-1];
        with(graphics)
        {
            lineStyle(0.1, 0xffffff);
            moveTo(last_dot.x, last_dot.y);
            lineTo(current.x, current.y);
        }
        var vx:Number = current.x - last_dot.x;
        var vy:Number = current.y - last_dot.y;
        len.push(Number(Math.sqrt(vx*vx+vy*vy)));
    }
    
    public function halt():void
    {
        next();
        //addEventListener(Event.ENTER_FRAME, animate);
    }
    
    public function animate(e:Event = null):void
    {
        var vx:Number = pA.x - current.x;
        var vy:Number = pA.y - current.y;
        var vlen:Number = Math.sqrt(vx*vx+vy*vy);
        if(vlen < len[id])
        {
            vx = target.x - current.x;
            vy = target.y - current.y;
            vlen = Math.sqrt(vx*vx+vy*vy);
            pA.x += vx/vlen * 2;
            pA.y += vy/vlen * 2;
            lightOfLine.x = pA.x;
            lightOfLine.y = pA.y;
            checking(pA, pB);
        } else {
            next();
        }
        pB.copy(pA);
    }
    
    private function next():void
    {
        if(id==-1) pB.copy(d[0]);
        if(++id==d.length)
        {
            id = 0;
        }
        current = d[id];
        target = d[(id+1)];
        pA.copy(current);
    }
        
    private function checking(p1:Dot, p2:Dot):void
    {
        var i:int = 0;
        for(i = 0; i < soundBank.sounds.length; i++)
        {
            if(intersected(p1,p2,lA[i],lB[i]))
            {
                soundBank.sounds[i].play(0,1);
                color.h = i*36;
                addChild(new Star(p1.x, p2.y, color.value));
                return;
            }
        }
    }
    
    public function intersected(p1:Dot, p2:Dot, p3:Dot, p4:Dot):Boolean
    {
        var s1_x:Number, s1_y:Number, s2_x:Number, s2_y:Number;
        s1_x = p2.x - p1.x;     s1_y = p2.y - p1.y;
        s2_x = p4.x - p3.x;     s2_y = p4.y - p3.y;
    
        var s:Number, t:Number;
        s = (-s1_y * (p1.x - p3.x) + s1_x * (p1.y - p3.y)) / (-s2_x * s1_y + s1_x * s2_y);
        t = ( s2_x * (p1.y - p3.y) - s2_y * (p1.x - p3.x)) / (-s2_x * s1_y + s1_x * s2_y);
    
        if (s >= 0 && s <= 1 && t >= 0 && t <= 1)
        {
            return true;
        }
        return false;
    }
}

class Dot
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var t:int = 0;
    
    public function Dot(px:Number = 0, py:Number = 0, pt:int = 0)
    {
        x = px; y = py; t = pt;
    }
    
    public function copy(p:Dot):Dot
    {
        x = p.x; y = p.y; return this;
    }
    
    public function rotate(radian:Number):Dot
    {
        var tx:Number = x;
        x = x * Math.cos(radian) - y * Math.sin(radian);
        y = tx * Math.sin(radian) + y * Math.cos(radian);
        return this;
    }
    
    public function sub_r(p:Dot):Dot {return new Dot(x-p.x, y-p.y);}
    
    public function rotate_around(c:Dot, radian:Number):Dot
    {
        var td:Dot = sub_r(c);
        td.rotate(radian);
        x = c.x + td.x;
        y = c.y + td.y;
        return this;
    }
}

class Star extends MovieClip
{
    public function Star(px:Number, py:Number, color:uint)
    {
        x = px;
        y = py;
        with(graphics)
        {
            lineStyle(0.1, color);
            var rad:Number = Math.PI*2/5;
            var rand:Number = Math.random() * Math.PI*2;
            var j:int = 0;
            for(var i:int = 0; i < 5; i++)
            {
                j = (i+1)%5;
                moveTo(Math.cos(i*rad + rand)*10, Math.sin(i*rad + rand)*10);
                lineTo(Math.cos(i*rad+rad/2 + rand)*5, Math.sin(i*rad+rad/2 + rand)*5);
                lineTo(Math.cos(j*rad + rand)*10, Math.sin(j*rad + rand)*10);
            }
        }
        addEventListener(Event.ENTER_FRAME, processing);
    }
    
    private function processing(e:Event):void
    {
        alpha-=0.1; scaleX += 0.1; scaleY += 0.1; rotationZ += 6;
        if(alpha<=0) dead();
    }
    
    private function dead():void
    {
        removeEventListener(Event.ENTER_FRAME, processing);
        parent.removeChild(this);
    }
}

import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.EventDispatcher;
import flash.media.Sound;
import flash.system.LoaderContext;
import flash.net.URLRequest;

class SoundBank extends EventDispatcher
{
    private var prefix:String = "http://assets.wonderfl.net/sounds/event/jam/";//http://assets.wonderfl.net/sounds/event/jam/
    public var urls:Array = ["drop1.mp3","drop2.mp3","drop3.mp3","drop4.mp3","drop5.mp3","drop6.mp3","drop7.mp3","drop8.mp3","drop9.mp3","drop10.mp3"];
    public var sounds:Array = new Array();
    
    public function SoundBank()
    {
        loadIt();
    }
    
    private function loadIt():void
    {
        var s:Sound = new Sound();
        sounds.push(s);
        s.addEventListener(Event.COMPLETE, soundComplete);
        s.load(new URLRequest(prefix + urls[0]));
    }
    
    private function soundComplete(e:Event):void
    {
        urls.splice(0,1);
        if(urls.length>0)
        {
            loadIt();
        } else {dispatchEvent(new Event("loadComplete"))}
    }
    
    public function play(p:int):void
    {
        sounds[p].play(0,1);
    }
}