/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3yeW
 */

package  
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * パーリンノイズの生成とフレームスキップ
     * 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private const OFFSET_SPEED:uint = 10;
        
        private var stageWidth:Number  = stage.stageWidth;
        private var stageHeight:Number = stage.stageHeight;
        
        private var frameSkipper:FrameSkipper;
        
        private var forceMapBitmap:Bitmap;
        private var forceMap:BitmapData;
        private var offsets:Array;
        
        
        public function Main() 
        {
            frameSkipper = new FrameSkipper( stage.frameRate );
            
            forceMap = new BitmapData( stageWidth, stageHeight );
            offsets = [ new Point( 0, 0 ) ];
            
            forceMapBitmap = new Bitmap( forceMap );
            addChild( forceMapBitmap );
            
            addEventListener( Event.ENTER_FRAME, enterFrameHandler );
            
            
            addChild(new Stats);
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            frameSkipper.update();
            
            if ( !frameSkipper.skip ) {
                
                offsets[0].x += ( frameSkipper.skipped + 1 ) * OFFSET_SPEED;
                forceMapBitmap.bitmapData.perlinNoise( 40, 40, 1, 0, true, true, 3, false, offsets );
            }
        }
    }
    
}

import flash.display.*;
import flash.events.*;
import flash.utils.*;

class FrameSkipper {
    
    /* ==================================================
     * property
     * ==================================================
     */
    
    /**
     * スキップされたフレーム数
     */
    public function get skipped():uint { return _skipped; }
    private var _skipped:uint = 0;
    
    
    /**
     * スキップするべきときなら true、そうでないなら false
     * 
     * --- 例 ---
     * if( !frameSkipper.skip )
     *     // フレームスキップしない時の処理（描画などの重い処理）
     * else 
     *     // フレームスキップするときの処理（描画をせずにデータ地だけ変更するなどの軽い処理）
     */
    public function get skip():Boolean { return skipCounter >= 0; }
    
    /**
     * 保ちたい fps 値
     */
    public var expectedFPS:uint;
    
    /**
     * 
     */
    public var margin:uint;
    
    
    
    /* ==================================================
     * field
     * ==================================================
     */
    private var previousTime:int = 0;
    private var currentTime:int = 0;
    private var skipCounter:int = 0;
    private var fps:uint;
    
    
    
    /* ==================================================
     * method
     * ==================================================
     */
    public function FrameSkipper( expectedFPS:uint = 60, margin:uint = 0 ):void {
        
        this.expectedFPS = expectedFPS;
        this.margin = margin;
    }
    
    public function update():void {
        
        currentTime = getTimer();
        
        
        
        fps = 1000 / ( currentTime - previousTime );
        
        if ( !skip && fps < expectedFPS ) {
            
            _skipped = expectedFPS / fps + margin;
            skipCounter = skipped;
            
        } else 
            skipCounter--;
        
        
        
        previousTime = currentTime;
    }
}