/**
 * Copyright nmtm ( http://wonderfl.net/user/nmtm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3ydn
 */

// forked from nmtm's forked from: Twitterの検索
// forked from umhr's Twitterの検索
/*
 * Twitter Search API Method: search
 * http://apiwiki.twitter.com/Twitter-Search-API-Method%3A-search
 * 
 * Twitter API 仕様書 (勝手に日本語訳シリーズ)
 * http://watcher.moe-nifty.com/memo/2007/04/twitter_api.html
 * */
package {
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.events.TextEvent;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldType;
	import flash.net.navigateToURL;
	/**
	 * ...
	 * @author umhr
	 *
	 /*/
	 [SWF(frameRate="30", width="180", height="700")]
	public class Main extends Sprite {
		private var _resultStage:Sprite = new Sprite();
		private var SearchText:String = "supercollider";
		private var captionY:int = 660;
		public function Main():void {

			
			
			//検索結果を配置するSpriteをaddChild
			_resultStage.y = 0;
			addChild(_resultStage);
			
			//初期状態で検索結果画面が出るように、検索を実行する。
			serch(SearchText);
			
			//futter
			//背景
			var titleArea:Shape = new Shape();
			titleArea.graphics.beginFill(0x696969);
			titleArea.graphics.drawRect(0, captionY, 180, 27);
			addChild(titleArea);
			
			//テキストの書式
             var tf:TextFormat = new TextFormat();
             tf.font = "_sans";
             tf.size = 12;
             tf.color = 0x111111;
                
			//Serchの文字
			var htmldata:String = "";
			htmldata = "<a href='http://twitter.com/onkan2010' target='_blank'> 'onkan2010' twitter</a>";
			
			var serchWord:TextField = new TextField();
			serchWord.defaultTextFormat = tf;
			serchWord.htmlText = htmldata;
			serchWord.width = 180;
			serchWord.height = 28;
			serchWord.x = 2;
			serchWord.y = captionY;
			serchWord.textColor = 0xFFFFFF;
			addChild(serchWord);
			
			
			
		}
		
		private function onKeyUp(e:KeyboardEvent):void {
			//Enterキーのキーコード13だったら、serchメソッドを実行。引数には適すと入力欄の文字列
			if (e.keyCode == 13) {
				serch(e.currentTarget.text)
			}
		}
		
		public function serch(serchWord:String):void {
			//検索APIにリクエストを投げる
			//http://search.twitter.com/crossdomain.xml上で許可をしているので
			//特に指定しなくても自動的に確認して、許可を得られる
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener(Event.COMPLETE, onCompleteXML);
			myURLLoader.addEventListener(IOErrorEvent.IO_ERROR, onIoError);
			var xmlURL:String = "http://search.twitter.com/search.atom?q=";
			//encodeURIComponent()を使うことによって、#や日本語にも対応
			xmlURL += encodeURIComponent(serchWord);		//*1
			myURLLoader.load(new URLRequest(xmlURL));
		}
		
		public function onIoError(e:IOErrorEvent):void {
			trace(e.type);
		}
        
		private function onCompleteXML(e:Event):void {
			//eventListenerを削除
			e.currentTarget.removeEventListener(Event.COMPLETE, onCompleteXML);
			//_resultStage上のオブジェクトを全て削除
			while (_resultStage.numChildren) {
				_resultStage.removeChildAt(0);
			}
			
			//XML型にキャスト
			var myXML:XML = new XML(e.currentTarget.data);
			//namespaceを設定
			default xml namespace = new Namespace("http://www.w3.org/2005/Atom");		//*2
			
			//ヘッダーの下
			var tfY:int = 0;
			//要素を取り出して、textFieldを作りならべる
			var itemLength:int = myXML.entry.length();
			
			for (var i:int = 0; i < 10; i++) {
				//xmlからlink,authorName,titleの各値を取得
				var link:String = myXML.entry[i].link[0].@href;
				var authorName:String = myXML.entry[i].author.name;
				var title:String = myXML.entry[i].title;
				//アイコン画像のURLを取得
				var imgURL:String = myXML.entry[i].link[1].@href;
				//bmpフォーマットのアイコン画像を使っている人も少なくないため、Flashで使えるファイルの拡張子かどうかを判別
				var extention:String = imgURL.substr( -4);
				extention = extention.toLowerCase();
				if (extention != ".jpg" && extention != ".gif" && extention != ".png") {
					//Flashで使える画像の拡張子ではなかった場合にはデフォルトアイコンを指定
					imgURL = "http://s.twimg.com/a/1254440757/images/default_profile_mini.png";
				}
				//画像のファイル名が日本語などの規定外の文字である場合を考慮しエンコードする
				imgURL = encodeURI(imgURL);		//*3
				//小さい画像で十分なので、名前を差し替える
				imgURL = imgURL.replace(/_normal\./, "_mini\.");
				
				//得られた各値をhtmlTextに入るように整形
				var htmldata:String = "";
				htmldata = "<a href='" + link + "' target='_blank'>";
				//htmldata += "<img src='" + imgURL + "' width='20' height='20' />";
				htmldata += "<b>" + authorName + "</b> " + title + "</a>";
				
				//テキストの書式
                var tf:TextFormat = new TextFormat();
                tf.font = "_sans";
                tf.size = 12;
                tf.color = 0x111111;
				
				//検索結果のテキストフィールド
				var myTextField:TextField = new TextField();
				myTextField.width = 180;
				myTextField.x = 0;
				myTextField.wordWrap = true;
				myTextField.background = true;
				myTextField.defaultTextFormat = tf;
				//myTextField.border = true;
				//myTextField.borderColor = 0x39CCFF;
				myTextField.backgroundColor = 0x7FFFD4;
				myTextField.htmlText = htmldata;
				myTextField.autoSize = "left";
				//テキストフィールドのy座標はtfYに加算していくことにより、決定
				myTextField.y = tfY;
				tfY += myTextField.height + 6;
				captionY = tfY + 6;
				_resultStage.addChild(myTextField);
			}
		}
	}
}