/**
 * Copyright darman ( http://wonderfl.net/user/darman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3xiD
 */

// forked from tktr90755's 流れ落ちる
package
{
	
	import flash.display.MovieClip;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.Stage;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	import flash.display.BlendMode;
	
	[SWF(frameRate="40",backgroundColor="#111111")] 
	public class Dots extends MovieClip
	{
		private var noteNumbers:Array = [60, 62, 64, 65, 67, 69, 71, 72];
		//コンテナ
		private var container:MovieClip;
		//噴出位置とリミット位置
		private var xLimit:Number;
		private var yLimit:Number;
		private var xAxis :Number;
		private var yAxis :Number;
		//色
		private var colors:Array = new Array("0xE89A0A", "0xE910DE", "0x0EEB10", "0xE9C010", "0xE2160F", "0xD6EB0B", "0xEB117C", "0xE81167", "0x7E11E8");
		
		private var counter:uint = 0;
		
		
		public function Dots()
		{
		   addEventListener(Event.ADDED_TO_STAGE, onAddedStage);
		}
		
		private function onAddedStage(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, onAddedStage);
			stage.scaleMode = "noScale";
			stage.align = "TL";
			
			stage.addEventListener (MouseEvent.MOUSE_DOWN, _onMouseDown);
			stage.addEventListener (MouseEvent.MOUSE_MOVE, _onMouseMove);
			
			container = new MovieClip();
			addChild (container);
			
			xLimit = stage.stageWidth * 2;
			yLimit = stage.stageHeight * 2;
			xAxis  = stage.mouseX;
			yAxis  = stage.mouseY;
			
			var textField:TextField=new TextField();
			textField.text="DRAG ME!";
			addChild(textField);
			textField.width = 400;
			textField.selectable = false;
			textField.x = stage.stageWidth / 2 - textField.width / 2;
			textField.y = stage.stageHeight / 2;
			
			var txtFmt:TextFormat = new TextFormat();
			txtFmt.bold = true;
			txtFmt.size = 22;
			txtFmt.color = "0x999999";
			txtFmt.align = "center";
			
			textField.setTextFormat(txtFmt);
		}
		private function _onMouseDown (e:Event):void
		{
			ring();
			addEventListener(Event.ENTER_FRAME, _onEnterFrame);
			stage.addEventListener(MouseEvent.MOUSE_UP, _onMouseUp);
		}
		private function _onMouseUp (e:Event):void
		{
			removeEventListener(Event.ENTER_FRAME, _onEnterFrame);
			stage.removeEventListener(MouseEvent.MOUSE_UP, _onMouseUp);
		}
		private function _onMouseMove (e:Event):void
		{
			//xAxis = Math.random() * stage.stageWidth;
			//yAxis = Math.random() * stage.stageHeight;
			
			//xAxis = stage.mouseX;
			//yAxis = stage.mouseY;
		}
		private function _onEnterFrame(e:Event):void
		{
			trace( "_onEnterFrame : " + _onEnterFrame );
			createClip (container, xAxis, yAxis);
			
			
			//10回に1回だけringを呼ぶ
			if (counter == 10) 
			{
				ring();
			}
			counter = (counter +1) % 11;
			trace( "counter : " + counter );
		}
		
		private function ring():void
		{
			if (noteNumbers.length == 0)
				return;
			
			var noteNumber:int = noteNumbers[int(Math.random() * noteNumbers.length)];	
			
			var attack:Number = Math.random() * 5;
			var decay:Number = Math.random() * 5;
			var release:Number = 10 - attack - decay;
			
			new Tone(noteNumber, 2, 8, attack, decay, 5, release).start();
			new Particle(noteNumber, 2, 8, attack, decay, 5, release, this).start();
		}
		
		private function createClip (a:MovieClip, b:Number, c:Number):void
		{
			xAxis = Math.random() * stage.stageWidth;
			yAxis = Math.random() * stage.stageHeight;
			//ランダムな数値
			var value1:Number = Math.floor(Math.random() * 10);
			var value2:Number = Math.floor(Math.random() * 10);
			var value3:Number = Math.floor(Math.random() * 10);
			//速さ [X軸,Y軸,回転]
			var xSpeed:Number = value1 - value2;
			var ySpeed:Number = value3 - 10;
			
			xSpeed = value1 - value2;
			ySpeed = value3 - 10;

			//減速率 [X軸,Y軸,回転]
			var xDeceleration:Number = 0.98;
			var yDeceleration:Number = 0.98;
			//var rotationDeceleration:Number = 0.98;

			//重力
			var gravity:Number = 0.1;
			var ms:Number = 0.98;
			var sc:Number = 0.25;
			var sa:Number = 0.05 * Math.random ();
			
			//shape生成と
			var shape:Shape = new Shape();
			a.addChild(shape);
			shape.graphics.beginFill(0xf00000 * Math.random());
			shape.graphics.drawCircle(0, 0, 10);
			shape.graphics.endFill();
			shape.blendMode  = BlendMode.DARKEN;    //BlendMove発動
			
			
			shape.x = b;
			shape.y = c;
			//shape.alpha=0;
			
			//流れ落ちる動き
			shape.addEventListener (Event.ENTER_FRAME,__onEnterFrame);
			function __onEnterFrame (e:Event):void
			{
				//shape.alpha=1;
				xSpeed = xSpeed * xDeceleration;
				ySpeed = ySpeed * yDeceleration + gravity;
				
				e.target.x = e.target.x + xSpeed;
				e.target.y = e.target.y + ySpeed;
				
				sc = sc + sa;
				
				//e.target.scaleX = 1 * Math.sin (3.141593 * sc);
				//e.target.scaleY = 1 * Math.cos (3.141593 * sc);
				//e.target.scaleX += 1 * 0.1;
				//e.target.scaleY += 1 * 0.1;
				
				if (e.target.x + 100 > xLimit || e.target.y + 100 > yLimit )
				{
					e.target.alpha = Math.round (yLimit - e.target.y);
					if (e.target.alpha<=0)
					{
						shape.removeEventListener (Event.ENTER_FRAME, __onEnterFrame);
						removeMC ();
					}
				}
			}
			function removeMC ():void
			{
				a.removeChild (shape);
			}
		}
		private function randomInt(max:int,min:int):int
		{
			var value:int = min + Math.floor(Math.random() * (max - min));
			return value;
		}
	}
}





import flash.display.Sprite;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.Timer;

class Particle extends Sprite
{
	public static const UNIT:int = 10;
	public static const TIMER_RATE:int = 20;
	
	public function Particle(noteNumber:uint, length:Number, volume:Number, attack:Number, decay:Number, sustain:Number, release:Number, parent:Sprite)
	{
		this.noteNumber = noteNumber;
		this.length = length;
		this.volume = volume;
		this.attack = attack;
		this.decay = decay;
		this.sustain = sustain;
		this.release = release;
		
		amplify = volume > sustain ? volume : sustain;
		
		parent.addChildAt(this, 0);
		
		check();
		initializeVelocity();
	}
	
	private var timer:Timer;
	
	private var radius:Number = 0;
	private var alphaValue:Number = 1;
	private var amplify:Number = 0;
	
	private var state:int = 1; // 1: Attack, 2: Decay, 3: Release
	
	private var noteNumber:uint;
	private var length:Number;
	private var volume:Number;
	private var attack:Number;
	private var decay:Number;
	private var sustain:Number;
	private var release:Number;
	
	private var v1:Number;
	private var v2:Number;
	private var v3:Number;
	
	private function check():void
	{
		if (attack + decay + release != UNIT)
		{
			attack = 0;
			decay = 5;
			release = 5;
		}
			
		if (volume > UNIT)
			volume = UNIT;
		
		if (volume < 0)
			volume = 0;
			
		if (sustain > UNIT)
			sustain = UNIT;
			
		if (sustain < 0)
			sustain = 0;
	}
	
	private function initializeVelocity():void
	{			
		v1 = volume / (TIMER_RATE * length * attack / UNIT);
		v2 = (volume - sustain) / (TIMER_RATE * length * decay / UNIT);
		v3 = sustain / (TIMER_RATE * length * release / UNIT);
		
		alphaValue = volume > sustain ? volume : sustain;
	}
	
	
	private function update():void
	{
		drawGraphics();
		updateParams();
	}
	
	private function drawGraphics():void
	{
		graphics.clear();
		
		graphics.beginFill(0xFFFFFF, alphaValue / 10);
		graphics.drawCircle(0, 0, radius * 1.5 * amplify);
		graphics.endFill();
	}
	
	private function updateParams():void
	{
		if (state == 1)
		{
			radius += v1;

			if (radius >= volume)
			{
				radius = volume;
				state = 2;
			}
		}
		else if (state == 2)
		{
			if (volume < sustain)
			{
				radius -= v2;
				
				if (radius >= sustain)
				{
					radius = sustain;
					state = 3;
				}
			}
			else
			{
				alphaValue -= v2;
				
				if (alphaValue <= sustain)
				{
					alphaValue = sustain;
					state = 3;
				}
			}	
		}
		else if (state == 3)
		{
			alphaValue -= v3;
			
			if (alphaValue <= 0)
			{
				alphaValue = 0;
				
				stop();
			}
		}
	}
	
	public function start():void
	{
		if (!parent)
			throw new Error("parent must be specified.");
		
		if (x == 0 && y == 0)
		{
			x = Math.random() * stage.stageWidth;
			y = Math.random() * stage.stageHeight;
		}
		
		timer = new Timer(1000 / TIMER_RATE);
		timer.addEventListener(TimerEvent.TIMER, timerHandler);
		timer.start();
	}
	
	public function stop():void
	{
		timer.removeEventListener(TimerEvent.TIMER, timerHandler);
		
		parent.removeChild(this);
		
		dispatchEvent(new Event(Event.COMPLETE));
	}
	
	private function timerHandler(event:TimerEvent):void
	{
		update();
	}
	
}

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.SampleDataEvent;
import flash.media.Sound;
import flash.utils.ByteArray;

class Tone extends EventDispatcher
{
	public static const SAMPLING_RATE:Number = 44100;
	public static const BUFFER_SIZE:int = 8192;
	public static const UNIT:int = 10;
	
	public function Tone(noteNumber:uint, length:Number, volume:Number, attack:Number, decay:Number, sustain:Number, release:Number)
	{
		this.frequency = noteNumber2frequency(noteNumber);
		this.length = length;
		this.volume = volume;
		this.attack = attack;
		this.decay = decay;
		this.sustain = sustain;
		this.release = release;
		
		check();
		initializeVelocity();
	}
	
	private var sound:Sound;
	
	private var phase:Number = 0;
	private var amplify:Number = 0;
	
	private var state:int = 1; // 1: Attack, 2: Decay, 3: Release
	
	private var frequency:Number;
	private var length:Number;
	private var volume:Number;
	private var attack:Number;
	private var decay:Number;
	private var sustain:Number;
	private var release:Number;
	
	private var v1:Number;
	private var v2:Number;
	private var v3:Number;
	
	private function check():void
	{
		if (attack + decay + release != UNIT)
		{
			 attack = 0;
			 decay = 5;
			 release = 5;
		}
			
		if (volume > UNIT)
			volume = UNIT;
		
		if (volume < 0)
			volume = 0;
			
		if (sustain > UNIT)
			sustain = UNIT;
			
		if (sustain < 0)
			sustain = 0;
	}
	
	private function initializeVelocity():void
	{			
		v1 = volume / (SAMPLING_RATE * length * attack / UNIT);
		v2 = (volume - sustain) / (SAMPLING_RATE * length * decay / UNIT);
		v3 = sustain / (SAMPLING_RATE * length * release / UNIT);
	}
	
	private function updateAmplify():void
	{
		if (state == 1)
		{
			amplify += v1;

			if (amplify >= volume)
			{
				amplify = volume;
				state = 2;
			}
		}
		else if (state == 2)
		{
			amplify -= v2;
			
			if (volume < sustain)
			{
				if (amplify >= sustain)
				{
					amplify = sustain;
					state = 3;
				}
			}
			else
			{
				if (amplify <= sustain)
				{
					amplify = sustain;
					state = 3;
				}
			}	
		}
		else if (state == 3)
		{
			amplify -= v3;
			
			if (amplify <= 0)
			{
				amplify = 0;
				
				stop();
			}
		}
	}
	
	public function start():void
	{					
		sound = new Sound();
		sound.addEventListener(SampleDataEvent.SAMPLE_DATA, soundSampleDataHandler);
		sound.play();
	}
	
	public function stop():void
	{
		sound.removeEventListener(SampleDataEvent.SAMPLE_DATA, soundSampleDataHandler);
		dispatchEvent(new Event(Event.COMPLETE));
	}
	
	private function soundSampleDataHandler(event:SampleDataEvent):void
	{	
		var bytes:ByteArray = new ByteArray();
		
		for (var i:int = 0; i < BUFFER_SIZE; ++i)
		{
			phase += frequency / SAMPLING_RATE;  
			
			var phaseAngle:Number = phase * Math.PI * 2;
			var sample:Number = Math.sin(phaseAngle) * amplify / UNIT;
			
			sample *= 0.2;
			
			bytes.writeFloat(sample);
			bytes.writeFloat(sample);
			
			updateAmplify();
		}
		event.data.writeBytes(bytes);
	}
	
}

function noteNumber2frequency(value:uint):Number
{
	if (value > 127)
		value = 127;
	
	return 440 * Math.pow(2, (value - 69) / 12);
}

