/**
 * Copyright dimitris.1972g ( http://wonderfl.net/user/dimitris.1972g )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3xUL
 */

package {
    import flash.display.Sprite;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.StatusEvent;
    import flash.events.MouseEvent;
    import flash.system.SecurityPanel;
    import flash.system.Security;

    public class Camera_getCameraExample extends Sprite {
        private var myTextField:TextField;
        private var cam:Camera;
        private var t:Timer = new Timer(1000);
        
        public function Camera_getCameraExample() {
            myTextField = new TextField();
            myTextField.x = 100;
            myTextField.y = 100;
            myTextField.background = true;
            myTextField.selectable = false;
            myTextField.autoSize = "left";
          
        
            cam = Camera.getCamera();
            
            if (!cam) {
                myTextField.text = "No camera is installed.";
                
            } else if (cam.muted) {
                myTextField.text = "To enable the use of the camera,\n"
                                 + "please click on this text field.\n" 
                                 + "When the Flash Player Settings dialog appears,\n"
                                 + "make sure to select the Allow radio button\n" 
                                 + "to grant access to your camera.";

                myTextField.addEventListener(MouseEvent.CLICK, clickHandler);

            }else {
                myTextField.text = "Connecting";
                connectCamera(); 
            }
   
            addChild(myTextField);

            t.addEventListener(TimerEvent.TIMER, timerHandler);
        }

        private function clickHandler(e:MouseEvent):void {
            Security.showSettings(SecurityPanel.PRIVACY);

            cam.addEventListener(StatusEvent.STATUS, statusHandler);

            myTextField.removeEventListener(MouseEvent.CLICK, clickHandler);
        }

        private function statusHandler(event:StatusEvent):void {

            if (event.code == "Camera.Unmuted") {
                connectCamera(); 
                cam.removeEventListener(StatusEvent.STATUS, statusHandler);
            }
        }

        private function connectCamera():void {
                var vid:Video = new Video(cam.width, cam.height);
                vid.x = 100;
                vid.y = 100;
                vid.attachCamera(cam);
                addChild(vid);    

                t.start();
        }

        private function timerHandler(event:TimerEvent):void {
            myTextField.y = cam.height + 200;
            myTextField.text = "100";
            myTextField.appendText("bandwidth: " + cam.bandwidth + "\n");
            myTextField.appendText("currentFPS: " + Math.round(cam.currentFPS) + "\n");
            myTextField.appendText("fps: " + cam.fps + "\n");
            myTextField.appendText("keyFrameInterval: " + cam.keyFrameInterval + "\n");
        }
    }
}