/**
 * Copyright cjcat2266 ( http://wonderfl.net/user/cjcat2266 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3xMX
 */

/**
 * Stardust Particle Engine
 * 
 * Homepage
 * 	http://code.google.com/p/stardust-particle-engine/
 * 
 * Documentation
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/docs/index.html
 * 
 * PDF Manual
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/manual/Stardust%20Particle%20Engine%20Manual.pdf
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import idv.cjcat.stardust.common.clocks.SteadyClock;
	import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
	
	[SWF(backgroundColor="#000000", frameRate=60)]
	
	public class Main extends Sprite {
		
		private var emitter:CircleEmitter;
		
		public function Main():void {
			emitter = new CircleEmitter(new SteadyClock(0.5));
			var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(this);
			renderer.addEmitter(emitter);
			
			addEventListener(Event.ENTER_FRAME, mainLoop);
		}
		
		private function mainLoop(e:Event):void {
			emitter.point.x = mouseX;
			emitter.point.y = mouseY;
			emitter.step();
		}
	}
}

//------------------------------------------------------------------------------------------------

import flash.display.BlendMode;
import flash.display.LineScaleMode;
import flash.display.Shape;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;

//------------------------------------------------------------------------------------------------

//I have no idea why this line must be added in order to compile successfully on Wonderfl.
//Just ignore this class :p
class BugFixer extends Shape { public function BugFixer() { } }

//------------------------------------------------------------------------------------------------

class CircleEmitter extends Emitter2D {
	
	public var point:SinglePoint;
	
	public function CircleEmitter(clock:Clock) {
		super(clock);
		
		//initializers
		point = new SinglePoint();
		addInitializer(new DisplayObjectClass(Circle));
		addInitializer(new Life(new UniformRandom(30, 10)));
		addInitializer(new Position(point));
		addInitializer(new Velocity(new LazySectorZone(1, 0.3)));
		addInitializer(new Scale(new UniformRandom(1.2, 0.6)));
		
		//actions
		addAction(new Age());
		addAction(new DeathLife());
		addAction(new Move());
		addAction(new ScaleCurve(5, 15));
	}
}

//------------------------------------------------------------------------------------------------

class Circle extends Shape {
	
	public function Circle() {
		blendMode = BlendMode.ADD;
		
		graphics.lineStyle(0, 0, 1, false, LineScaleMode.NONE);
		graphics.beginFill(uint(0x1000000 * Math.random()), 0.5 + 0.5 * Math.random());
		graphics.drawCircle(0, 0, 20);
	}
}