/**
 * Copyright komatsu ( http://wonderfl.net/user/komatsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3whw
 */

package {
	import flash.utils.Timer;
	import flash.events.TimerEvent;
    import flash.display.Sprite;
    import flash.events.EventDispatcher;
    import flash.events.Event;
    import caurina.transitions.Tweener;
     [SWF(backgroundColor="#000000", frameRate=30)]
    public class MaskImage extends Sprite {
    		private var sp:Sprite;
    		private var maskSp:Sprite;
    		private var stw:uint = stage.stageWidth;
    		private var sth:uint = stage.stageHeight;
    		private var circleTimer:Timer;
        public function MaskImage() {
            sp = new Sprite();
            var imgSp:LoadGraphic = new LoadGraphic(sp,"http://activefactor.jp/wonderfl/room.jpg");
            imgSp.addEventListener(Event.COMPLETE , testImageComp);
            addChild(sp);
       }
       
       private function testImageComp(evtObj:Event):void{
       		maskSp = new Sprite();
       		addChild(maskSp);
       		sp.mask = maskSp;
       		circleTimer = new Timer(20);
       		circleTimer.addEventListener(TimerEvent.TIMER,addCircle);
       		circleTimer.start();
       }
       private var xData:uint = 0;
       private var yData:uint = 0;
       private function addCircle(evtObj:TimerEvent):void{
       		var c:Sprite = new Sprite();
       		c.graphics.beginFill(0xFFFFFF);
       		c.graphics.drawCircle(0,0,20);
       		c.x = xData*c.width;
       		c.y = yData*c.height;
       		xData++;
       		if(xData > Math.ceil(stw/c.width)){
       			yData++;
       			xData = 0;
       			if(yData > Math.ceil(sth/c.height)){
       				circleTimer.stop();
       				Tweener.addTween(maskSp,{width:6000,height:6000,x:-3000,y:-3000,time:5,transition:"easeOutBack"});
       			}
       		}
       		maskSp.addChild(c);
       }
    }
}

import flash.display.Sprite;
import flash.net.URLRequest;
import flash.display.Loader;
import flash.events.EventDispatcher;
import flash.events.Event;
class LoadGraphic extends EventDispatcher{
   private var imgPath:URLRequest;
   private var imgLoader:Loader;  
   public function LoadGraphic(target:Sprite,url:String) {
     imgPath = new URLRequest(url);
     imgLoader = new Loader();
   	 imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE , loadComp);
   	 imgLoader.load(imgPath);
     target.addChild(imgLoader); 
   }
   private function loadComp(evtObj:Event):void{
 	  dispatchEvent(new Event(Event.COMPLETE));  	
   }
}