/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3vhF
 */

// forked from ohisama's flash on 2013-2-3
package 
{
    import flash.display.Sprite;
    import flash.events.*;
    import flash.media.Sound;
    import flash.utils.ByteArray;
    public class FlashTest extends Sprite 
    {
        private var _button : Button;
        public function FlashTest() : void
        {
            var labels : Array = "123A456B789C*0#D".split("");
            var freqs : Array = [697, 770, 852, 941, 1209, 1336, 1477, 1633];
            var button : Button;
            var WH:int = 36;
            
            for (var i : uint = 0; i < 16; i++)
            {
                var x : int = (i % 4) * 60;
                var y : int = uint(i / 4) * 60;
                button = new Button(WH, WH, WH*0.3, labels[i], int(WH*0.5));
                button.x = x;
                button.y = y;
                button.high = freqs[i % 4 + 4] * Math.PI / 44100;
                button.low = freqs[uint(i / 4)] * Math.PI / 44100;
                button.addEventListener(MouseEvent.MOUSE_DOWN, onButtonDown);
                addChild(button);
            }
            var sound : Sound = new Sound();
            sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onSample);
            sound.play();
        }
        private function onButtonDown(e : MouseEvent) : void
        {
            _button = e.currentTarget as Button;
            _button.addEventListener(MouseEvent.MOUSE_UP, onButtonUp);
        }
        private function onButtonUp(e : MouseEvent) : void
        {
            _button = null;
            _button.removeEventListener(MouseEvent.MOUSE_UP, onButtonUp);
        }
        private function onSample(e : SampleDataEvent) : void
        {
            var bytes : ByteArray = e.data;
            var pos : Number = e.position;
            var d : Number;
            var p : Number;
            for (var i : uint = 0; i < 4096; i++)
            {
                p = pos + i;
                d = _button === null ? 0 : (Math.sin(p * _button.high) + Math.sin(p * _button.low)) / 2;
                bytes.writeFloat(d);
                bytes.writeFloat(d);
            }
        }
    }
}
import flash.display.Sprite;
import flash.events.Event;
import flash.text.TextField;
import flash.geom.Matrix;
import flash.filters.ColorMatrixFilter;
import flash.filters.GlowFilter;
class Button extends Sprite
{
    private static const mono : ColorMatrixFilter = new ColorMatrixFilter([
        1 / 3, 1 / 3, 1 / 3, 0, 10,
        1 / 3, 1 / 3, 1 / 3, 0, 10,
        1 / 3, 1 / 3, 1 / 3, 0, 10,
            0,     0,     0, 1, 0
    ]);
    public var high : Number;
    public var low : Number;
    private var _hover : Boolean = false;
    public function get hover() : Boolean
    {
        return _hover;
    }
    public function set hover(value : Boolean) : void
    {
        if (_hover != value)
        {
            _hover = value;
            filters = (_hover ? null : [mono]);
        }
    }
    public function Button(W : Number = 20, H : Number = 20, R : Number = 6, label : String = "", size : int = 18)
    {
        var matrix : Matrix = new Matrix();
        matrix.createGradientBox(W, H, Math.PI / 2);
        var bg : Sprite = new Sprite();
        bg.graphics.beginGradientFill("linear", [0xDDE9F4, 0xD5E4F1, 0xBAD2E8], [1, 1, 1], [0, 120, 136], matrix);
        bg.graphics.drawRoundRect(0, 0, W, H, R, R);
        bg.graphics.endFill();
        bg.filters = [new GlowFilter(0xFFFFBE, .5, 10, 10, 2, 1, true)];
        addChild(bg);
        var line : Sprite = new Sprite();
        line.graphics.lineStyle(1.0, 0xBAD2E8, 1.0, true);
        line.graphics.drawRoundRect(0, 0, W, H, R, R);
        addChild(line);
        filters = [mono];
        buttonMode = true;
        mouseChildren = false;
        if (label != "")
        {
            var textField : TextField = new TextField();
            textField.selectable = false;
            textField.autoSize = "left";
            textField.htmlText = <font size={size} color="#6B8399">{label}</font>.toXMLString();
            textField.x = (W - textField.width) / 2;
            textField.y = (H - textField.height) / 2;
            addChild(textField);
        }
        addEventListener("rollOver", buttonRollOver);
        addEventListener("rollOut", buttonRollOut);
        addEventListener("removed", function(event : Event) : void
        {
            removeEventListener("rollOver", buttonRollOver);
            removeEventListener("rollOut", buttonRollOut);
            removeEventListener("removed", arguments.callee);
        });
    }
    protected function buttonRollOver(event : Event) : void
    {
        hover = true;
    }
    protected function buttonRollOut(event : Event) : void
    {
        hover = false;
    }
}

