/**
 * Copyright Erinco157 ( http://wonderfl.net/user/Erinco157 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3uMG
 */

// forked from Erinco157's forked from: 簡単なゲームのサンプル
// forked from lenonsun's 簡単なゲームのサンプル
// 簡単なゲームのサンプル
package 
{
    import flash.events.KeyboardEvent;
    
    import frocessing.display.F5MovieClip2D;
    /**
     * 簡単なゲームのサンプル
     * @author shmdmoto
     */
    public class miniGame4 extends F5MovieClip2D
    {

        public var bulletY:Interpolate; // 弾のY座標
        public var targetX:Array; // 的の中心のx座標
        public var targetY:Array; // 的の中心のy座標
        public var targetHit:Array;  // 的に命中したかどうか
        public var intR:Interpolate;   // 当たった時の演出の円の直径
        public var circX:Number; // 当たった時の演出の円の中心のx座標
        public var circY:Number; // 当たった時の演出の円の中心のy座標
        public var i:int, j:int;
        public function miniGame4() {
            super(false);
        }
        public function setup() : void
            {
            // 的の初期設定
            targetX = new Array(20);          
            targetY = new Array(20);          
            targetHit = new Array(20);          
            for( var i:int = 0 ; i < 10 ; i++ ) {
                targetX[i] = new LFO( random(10,20), 
                                      stage.stageWidth / 2, 
                                      stage.stageWidth / 2, 
                                      random(1.0));
                targetX[i].setType(LFO.TRI);
                targetY[i] = new Number();
                targetY[i] = 20 * ( i + 1);
                targetHit[i] = new Boolean();
                targetHit[i] = false;
            }
            // 弾のY座標
            bulletY = new Interpolate(1, stage.stageHeight,0);
            bulletY.pause();
            // 当たった時の演出
            intR = new Interpolate(1, 20, 100);
            intR.pause();
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
        public function draw() : void
        {
            // 弾の表示
            if( bulletY.isRunning() ) { // Interpolateが動作中ならば弾を表示
                for( var i:int = 0 ; i < 10 ; i++ ) {
                    if( !targetHit[i] ) { // 当たっていない弾と衝突判定
                        if( dist(targetX[i].val(), targetY[i], 
                            stage.stageWidth / 2, bulletY.val()) < 15 ) {
                            targetHit[i] = true;
                            bulletY.pause(); // 当たったら弾は無効
                            intR.start();    // 当たった時の演出開始
                            circX = targetX[i].val();
                            circY = targetY[i];
                            break; //一度に一つしか当たらない
                        } else {
                            noStroke();
                            fill(255,0,0);
                            ellipse(stage.stageWidth / 2, bulletY.val(), 10, 10);
                        }
                    }
                }
            }
            // 的の表示
            for( i = 0 ; i < 10 ; i++ ) {
                if( !targetHit[i] ) {
                    fill(0);
                    ellipse(targetX[i].val(), targetY[i], 20, 20);
                }
            }
            // 当たった時の演出表示
            if( intR.isRunning() ) {
                noFill();
                stroke( 255 * intR.val()/100);
                ellipse(circX, circY, intR.val(), intR.val() );
            }

        }
                    
        public function onKeyDown(event:KeyboardEvent) : void
        {
            // 弾を発射中は再度発射できない
            if( !bulletY.isRunning() ) {
                bulletY.start();
                
            }
        }
    }
}

// 以下は，動きを記述するためのクラスですので，編集しないでください．
import flash.utils.getTimer;
import frocessing.math.PerlinNoise;
/**
 * Interpolate:指定した時間で，開始値から終値までの過渡的を
 *             記述するクラス
 */
class Interpolate
{
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var duration  :Number;
    private var begin     :Number;
    private var end       :Number;
    private var pow       :Number;
    private var tOffset   :Number;
    private var tElapsed  :Number;
    private var prevVal   :Number;
    private var tRestart  :Number;
    public  var status    :int = NOINIT;
    public function Interpolate( t:Number, s:Number, f:Number,
                                 p:Number = 1) {
        begin = prevVal = s;
        end = f;
        duration = t;
        pow = p;
        tOffset = 0;
        tElapsed = 0;
    }
    public function val() :Number {
        var t :Number;
        if( status == NOINIT){
            tOffset = getTimer()/1000;
            prevVal = begin;
            status = RUNNING;
        } else if( status == RUNNING ) {
            t = getTimer()/1000;
            tElapsed = t -tOffset;
            if( tElapsed < duration ) {
                prevVal = begin + ( end - begin )*Math.pow(tElapsed/duration,pow);
            } else {
                prevVal = end;
                status = STOPPED;
            }
        } else if( status == WAITING){
            t = getTimer()/1000;
            if( t >= tRestart) {
                status = RUNNING;
                tOffset = t - tElapsed;        
            }
        }
        return prevVal;
    }
    public function pause() :void
    {
        status = STOPPED;
    }
    public function cont() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000-tElapsed;        
    }
    public function start() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000;                
    }
    public function wait( waitTime :Number ) :void
    {
        status = WAITING;
        tRestart = getTimer() + waitTime;
    }
    
    public function isRunning() :Boolean
    {
        if( status == RUNNING ) {
            return true;
        } else {
            return false;
        }
    }
    public function isStopped() :Boolean
    {
        if( status == STOPPED ) {
            return true;
        } else {
            return false;
        }
    }
    public function isEnd() :Boolean
    {
        if( prevVal >= end) {
            return true;
        } else {
            return false;
        }
    }
}
/**
 * LFO:指定した時間での周期的変動を記述するクラス
 */
class LFO {
    public static const SIN    :int = 1;
    public static const COS    :int = 2;
    public static const SAW    :int = 3;
    public static const TRI    :int = 4;
    public static const SQR    :int = 5;
    public static const ABSSIN :int = 6;
    public static const NOISE  :int = 7;
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var period    :Number;
    private var amplitude :Number;
    private var phase     :Number;
    private var offset    :Number;
    private var type      :int = SIN;
    private var isStart   :Boolean;
    private var t_offset  :Number;
    private var status    :int = NOINIT;
    
    public function LFO( prd :Number, amp :Number,
                         of :Number = 0, ph :Number = 0)
    {
        period    = prd;
        amplitude = amp;
        offset    = of;
        phase     = ph;
    }
    public function setPeak( min :Number, max :Number) :void
    {
        offset = (min + max) / 2;
        if( min < max ) {
            amplitude    = (max - min) / 2;
        } else {
            amplitude    = (min - max) / 2;
        }        
    }
    public function setType( t :int ) :void
    {
        type = t;
    }
    public function val( mul :Number=1.0 ) :Number {
        if(status == NOINIT) {
            status = RUNNING;
            t_offset = getTimer() / 1000.0;
            return val();
        } else if(status == RUNNING　) {
            var t :Number = getTimer() / 1000.0 - t_offset;
            var temp :Number;
            switch(type) {
                case SIN :
                    return  offset + mul * amplitude * 
                    Math.sin(2.0 * Math.PI *( t/period + phase) );
                case COS :
                    return  offset + mul * amplitude *
                    Math.cos(2.0 * Math.PI *( t/period + phase) );
                case SAW :
                    temp = t / period + 0.5 + phase - 
                    Math.floor( t / period + 0.5 + phase ) - 0.5;
                    return  offset + 2.0 * mul * amplitude * temp;
                case TRI :
                    temp = t / period + phase - 
                    Math.floor (t / period + phase );
                    if( 0.0 <= temp && temp < 0.25 ) {
                        return offset + mul * amplitude * 4.0 * temp;
                    } else if( temp < 0.75 ) {
                        return offset + mul * amplitude * (  2.0 - 4.0 * temp);
                    } else {
                        return offset + mul * amplitude * ( -4.0 + 4.0 * temp);
                    }
                case SQR :
                    temp = t/period + phase - 
                    Math.floor( t / period + phase);
                    if( temp < 0.5 ){
                        return offset + mul * amplitude;
                    } else {
                        return offset - mul * amplitude;
                    }
                case ABSSIN :
                    return  offset + 
                    Math.abs(mul * amplitude * Math.sin(2.0*Math.PI *( t/period + phase)));
                case NOISE :
                    var p :PerlinNoise = new PerlinNoise(); 
                    return offset -mul * amplitude + 2.0 * mul * amplitude * p.noise(t/period+phase,1);
                default :
                    return 0.0;
            }
        } else {
            return 0.0;
        }        
    }
}    