/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3u1f
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	
    public class FlashTest extends Sprite {
		private const WIDTH:uint = 40;
		private const HEIGHT:uint = WIDTH;
		
		private var _rectArray:Array;
		private var _logicArrayR:Array;
		private var _logicArrayG:Array;
		private var _logicArrayB:Array;
		private var _frame:uint;
		
        public function FlashTest() {
			this.graphics.beginFill(0x404040);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			_rectArray = new Array();
			_logicArrayR = new Array();
			_logicArrayG = new Array();
			_logicArrayB = new Array();
			_frame = 0;

			initLogic(_logicArrayR);
			initLogic(_logicArrayG);
			initLogic(_logicArrayB);
			initRect();
			
			this.addEventListener(Event.ENTER_FRAME, proc);
        }

		private function initLogic(a:Array):void {
			for (var y:uint = 0; y < HEIGHT + 2; ++y) {
				a.push(new Array());
				for (var x:uint = 0; x < WIDTH + 2; ++x) {
					if (x == 0 || y == 0 || x == WIDTH + 1 || y == HEIGHT + 1) {
						a[y].push(false);
					}
					else {
						var flag:Boolean = Math.random() < 0.25;
						a[y].push(flag);
					}
				}
			}			
		}

		private function initRect():void {
			for (var y:uint = 0; y < HEIGHT; ++y) {
				_rectArray.push(new Array());
				for (var x:uint = 0; x < WIDTH; ++x) {
					var r:Rect = new Rect();
					r.x = 12.5 + (11 * x);
					r.y = 12.5 + (11 * y);
					this.addChild(r);
					_rectArray[y].push(r);
				}
			}
		}
				
		private function proc(e:Event):void {
			++_frame;

			if (_frame < 5) return;
			_frame = 0;
			
			updateLogic(_logicArrayR);
			updateLogic(_logicArrayG);
			updateLogic(_logicArrayB);
			updateRect();
		}
		
		private function updateLogic(a:Array):void {
			for (var y:uint = 1; y < HEIGHT + 1; ++y) {
				for (var x:uint = 1; x < WIDTH + 1; ++x) {
					var num:uint = getNum(a, x, y);
					
					if (a[y][x]) {
						if (num <= 1 || num >= 4) {
							a[y][x] = false;
						}
					}
					else {
						if (num == 3) {
							a[y][x] = true;
						}
					}
				}
			}
		}
		
		private function updateRect():void {
			for (var y:uint = 0; y < HEIGHT; ++y) {
				for (var x:uint = 0; x < WIDTH; ++x) {
					_rectArray[y][x].update(_logicArrayR[y + 1][x + 1], _logicArrayG[y + 1][x + 1], _logicArrayB[y + 1][x + 1]);
				}
			}
		}
		
		private function getNum(a:Array, x:uint, y:uint):uint {
			var num:uint = 0;
			if (a[y - 1][x - 1]) ++num;
			if (a[y - 1][x]) ++num;
			if (a[y - 1][x + 1]) ++num;
			if (a[y][x - 1]) ++num;
			if (a[y][x + 1]) ++num;
			if (a[y + 1][x - 1]) ++num;
			if (a[y + 1][x]) ++num;
			if (a[y + 1][x + 1]) ++num;
			return num;
		}
    }
}

import flash.display.Sprite;
class Rect extends flash.display.Sprite
{
	public const SIZE:uint = 10;
	
	private const ROUND:uint = 4;
	
	private var _rgb:Sprite;
	private var _rg:Sprite;
	private var _gb:Sprite;
	private var _rb:Sprite;
	private var _r:Sprite;
	private var _g:Sprite;
	private var _b:Sprite;
	private var _none:Sprite;

	public function Rect() {
		_rgb = create(0xffffff);
		_rg = create(0xffff80);
		_gb = create(0x80ffff);
		_rb = create(0xff80ff);
		_r = create(0xff8080);
		_g = create(0x80ff80);
		_b = create(0x8080ff);
		_none = create(0x808080);
		this.addChild(_rgb);
		this.addChild(_rg);
		this.addChild(_gb);
		this.addChild(_rb);
		this.addChild(_r);
		this.addChild(_g);
		this.addChild(_b);
		this.addChild(_none);
	}
	
	private function create(color:uint):Sprite {
		var s:Sprite = new Sprite();
		s.graphics.beginFill(color);
		s.graphics.drawRoundRect(0, 0, SIZE, SIZE, ROUND, ROUND);
		s.graphics.endFill();
		return s;
	}
	
	public function update(r:Boolean, g:Boolean, b:Boolean):void {
		_rgb.visible = false;
		_rg.visible = false;
		_gb.visible = false;
		_rb.visible = false;
		_r.visible = false;
		_g.visible = false;
		_b.visible = false;
		_none.visible = false;

		if (r && g && b) _rgb.visible = true;
		else if (r && g) _rg.visible = true;
		else if (g && b) _gb.visible = true;
		else if (r && b) _rb.visible = true;
		else if (r) _r.visible = true;
		else if (g) _g.visible = true;
		else if (b) _b.visible = true;
		else _none.visible = true;
	}
}