/**
 * Copyright atsushieno ( http://wonderfl.net/user/atsushieno )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3toM
 */

// forked from paq's forked from: forked from: 水面ゆらゆら
// forked from hiphi's forked from: 水面ゆらゆら
// forked from cDa's 水面ゆらゆら
/*
	どこかで見覚えがある水面
	　ランダムで波が起きる
	　マウスを上下に動かすと波がぐわんぐわん起きる
	　ぎこちないので何とかする必要あり
*/

/**
 IOモジュールにつなげた感圧センサにさわると、
 圧力に応じて波がゆらゆらします。
 
 基本的なセットアップについては以下のURLを参照してください
 http://funnel.cc/Main/GettingStarted
*/

package {
	import flash.display.*;

        [SWF(width="300", height="300", backgroundColor="0xFFFFFF", frameRate="30")] 

	public class Main extends Sprite {
                
                public function Main():void {
                    
                    var mc:Wave = new Wave();
                    mc.colors = 0x000000
                    mc.y = 0;
                    addChild(mc);
                }
        }
}

	import flash.display.MovieClip;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import flash.utils.getTimer;
	import flash.geom.Point;
	import funnel.Gainer;
	import funnel.Scaler;
	import funnel.Convolution;
	import funnel.gui.GainerGUI;

    import flash.display.Sprite;
    import flash.external.ExternalInterface;
    import flash.system.Security;
    import flash.events.*;
	
    import org.si.sion.*;
    import org.si.sion.effector.*;
    import org.si.sion.events.*;
    import org.si.sion.sequencer.SiMMLTrack;
    import org.si.sion.utils.SiONPresetVoice;
    import org.si.sion.utils.Translator;

    	class Wave extends MovieClip
	{
		public const STAGE_W:uint = 400;
		public const STAGE_H:uint = 400;
		public const NUM:uint=600;	//頂点数
		
		private const MOUSE_DIFF_RATIO:Number=1;	// (0<) 大きい程マウスに反応する
		
		private var vertexes:Array=[];	//頂点
		private var mdlPt:Array=[];	//頂点の中点
		
		//頂点の基本波からの位相差分
		// 0:マウス
		// 1:オート
		private var diffPt:Array=[[], []];
		
		//波が起こるインデックス
		// 0:マウス
		// 1:オート
		private var startIndex:Array=[0,0];	
		
		private var mouseOldY:int;
		private var mouseNewY:int;
		private var mouseDiff:Number = 0;
		private var mouseDiffGoal:Number= 0;

	    public var colors:uint;
		
		public var gio:Gainer;
		public var gui:GainerGUI;
		public var sion:SionSample;

		public function Wave():void
		{
                        gio = new Gainer();
                        
			gio = new Gainer(Gainer.MODE1);
			gui = new GainerGUI();
			sion = new SionSample();
			gio.gui = gui;
			addChild(gui);
                        
			var smoother:Convolution = new Convolution(Convolution.MOVING_AVERAGE);
			var scaler:Scaler = new Scaler(0, 0.95, 0, STAGE_H, Scaler.LINEAR, true);
			gio.analogInput(0).filters = [smoother, scaler];
			
			for(var i:uint=0; i<NUM; i++){
				var vertex:Vertex=new Vertex( i, this );
				vertexes.push( vertex );
				
				//中点作成
				if(i>1){
					mdlPt.push( new Point( (vertexes[i-1].x+vertexes[i].x)*0.5, (vertexes[i-1].y+vertexes[i].y)*0.5 ) );
				}
				
				//差分
				diffPt[0].push( 0 );
				diffPt[1].push( 0 );
				
			}
			mouseNewY = mouseY;
			if(mouseNewY < 0){	mouseNewY = 0;	}
			else if(mouseNewY > STAGE_H){	mouseNewY = STAGE_H;	}
			
			mouseOldY = mouseNewY;
			
			addEventListener(Event.ENTER_FRAME, updateMouseDiff);
			addEventListener(Event.ENTER_FRAME, updateWave);
		}
		
		
		//--------------------------------------
		//	マウスY座標の差を計算
		//--------------------------------------
		private function updateMouseDiff(evt:Event):void
		{
			mouseOldY = mouseNewY;
			mouseNewY = gio.analogInput(0).value;
			if(mouseNewY < 0){	mouseNewY = 0;	}
			else if(mouseNewY > STAGE_H){	mouseNewY = STAGE_H;	}
			
			mouseDiffGoal = (mouseNewY - mouseOldY) * MOUSE_DIFF_RATIO;

if (sion) sion.volume (gio.analogInput(0).value / 32.0);
		}
		
		
		//---------------------------------------
		//	各種更新
		//---------------------------------------
		private function updateWave(evt:Event):void
		{
			graphics.clear();
			
			//それぞれの波の減衰
			mouseDiff -= (mouseDiff - mouseDiffGoal)*0.3;

			
			//-------------------------------------
			//波の基点
			//-------------------------------------
			//マウス波
			var mX:int = stage.stageWidth/2;
			
			startIndex[0] = 1+Math.floor( (NUM-2) * mX / STAGE_W );
			diffPt[0][startIndex[0]] -= ( diffPt[0][startIndex[0]] - mouseDiff )*0.99;
			
			var i:int;

			//-------------------------------------
			//差分更新
			//-------------------------------------
			//マウス波
			//左側
			var d:uint;
			for(i=startIndex[0]-1; i >=0; i--){
				d = startIndex[0] - i;
				if(d>15){	d=15;	}
				diffPt[0][i] -= ( diffPt[0][i] - diffPt[0][i+1] )*(1-0.01*d);
			}
			//右側
			for(i=startIndex[0]+1; i < NUM; i++){
				d = i - startIndex[0];
				if(d>15){	d=15;	}
				diffPt[0][i] -= ( diffPt[0][i] - diffPt[0][i-1] )*(1-0.01*d);
			}

			//オート波
			//左側
			for(i=startIndex[1]-1; i >=0; i--){
				d = startIndex[1] - i;
				if(d>15){	d=15;	}
				diffPt[1][i] -= ( diffPt[1][i] - diffPt[1][i+1] )*(1-0.01*d);
			}
			//右側
			for(i=startIndex[1]+1; i < NUM; i++){
				d = i - startIndex[1];
				if(d>15){	d=15;	}
				diffPt[1][i] -= ( diffPt[1][i] - diffPt[1][i-1] )*(1-0.01*d);
			}

			//-------------------------------------
			//各頂点更新
			//-------------------------------------
			for(i=0; i < NUM; i++){	vertexes[i].uodatePos( diffPt[0][i]+diffPt[1][i] );	}

			//-------------------------------------
			//中点更新
			//-------------------------------------
			for(i=0; i < NUM-2; i++){	mdlPt[i].y = (vertexes[i+1].y + vertexes[i+2].y)*0.5;	}

			drawWave();
		}
		
		
		//---------------------------------------
		//	描画
		//---------------------------------------
		private function drawWave():void
		{
			graphics.beginFill(colors, 1);

			graphics.moveTo(STAGE_W, STAGE_H);
			graphics.lineTo(0, STAGE_H);
			graphics.lineTo( vertexes[0].x, vertexes[0].y);
			graphics.curveTo( vertexes[1].x, vertexes[1].y, mdlPt[0].x, mdlPt[0].y);

			for(var i:uint=2; i<NUM-2; i++){
				graphics.curveTo( vertexes[i].x, vertexes[i].y, mdlPt[i-1].x, mdlPt[i-1].y);
			}
			graphics.curveTo( vertexes[NUM-2].x, vertexes[NUM-2].y, vertexes[NUM-1].x, vertexes[NUM-1].y);
			
			graphics.endFill();
		}
		
	}
	
	class AnoWave
	{

	}
	
	class Vertex
	{
		static const BASE_Y:uint = 150;
		static const BASE_R:uint = 10;
		static const PI:Number = Math.PI;
		static const FRICTION:Number = 0.1;
		static const DECELERATION:Number = 0.95;
		static const SPEED_OF_BASE_WAVE:uint = 2;
		
		private var theta:uint=0;
		private var goalY:Number=0;
		private var amp:Number=0;
		public var x:Number;
		public var y:Number;
		
		
		public function Vertex(prmID:uint, parent:Object):void
		{
			theta =  360 * prmID/( parent.NUM-1) ;
			x = prmID * parent.STAGE_W / (parent.NUM-1);
			y = BASE_Y +  BASE_R * Math.sin( theta * PI /180  );
		}
		
		
		public function uodatePos(diffVal:Number):void
		{
			theta += SPEED_OF_BASE_WAVE;
			if( theta>=360 ){	theta -= 360;	}
			
			goalY = BASE_Y +  BASE_R * Math.sin( theta * PI /180  );
			goalY += diffVal;

			
			amp += goalY - y;
			y += amp * FRICTION;
			amp *= DECELERATION;
		}
		
	}
	
	class SionSample
	{
    // variables
    //--------------------------------------------------
        public var driver:SiONDriver;
        public var mmldata:SiONData;
        private var presetVoice:SiONPresetVoice;
        private var currentVoice:SiONVoice;
        
            private var delaySendLevel:Number;
            private var chorusSendLevel:Number;
        
        
    // constructor
    //--------------------------------------------------
        public function SionSample(): void
        {
            Security.allowDomain('*');
            driver = new SiONDriver();
            mmldata = new SiONData();
            driver.autoStop = true;
            
            //new pcmExample(driver);

/*
            // register javascript interfaces
            ExternalInterface.addCallback("_compile", _compile);
            ExternalInterface.addCallback("_play",    _play);
            ExternalInterface.addCallback("_stop",    driver.stop);
            ExternalInterface.addCallback("_pause",   driver.pause);
            ExternalInterface.addCallback("_volume",  _volume);
            ExternalInterface.addCallback("_pan",     _pan);
            ExternalInterface.addCallback("_position",_position);
            ExternalInterface.addCallback("_noteOn",_noteOn);
            ExternalInterface.addCallback("_noteOff",_noteOff);
            
            // register handlers
            driver.addEventListener(SiONEvent.QUEUE_PROGRESS, _onCompileProgress);
            driver.addEventListener(SiONEvent.QUEUE_COMPLETE, _onCompileComplete);
            driver.addEventListener(ErrorEvent.ERROR,         _onError);
            driver.addEventListener(SiONEvent.STREAM,         _onStream);
            driver.addEventListener(SiONEvent.STREAM_START,   _onStreamStart);
            driver.addEventListener(SiONEvent.STREAM_STOP,    _onStreamStop);
            driver.addEventListener(SiONEvent.FADE_IN_COMPLETE,  _onFadeInComplete);
            driver.addEventListener(SiONEvent.FADE_OUT_COMPLETE, _onFadeOutComplete);
*/

_onCreateCore();

            // callback onLoad
//            ExternalInterface.call('SIOPM._internal_onLoad', SiONDriver.VERSION);
        }
        
		static const ToneMML = "%11@0,48,48,0,0,20s8 %11 v15";
		static const full_notes = ["c", "c+", "d", "d+", "e", "f", "f+", "g", "g+", "a", "a+", "b"];
		static const simple_notes = ["c", "d", "e", "f", "g", "a", "b"];

		private function doPlay(mml:String):void 
		{
			driver.compile(mml);
		}
        

	private function _onCreateCore() : void 
	{
		presetVoice = new SiONPresetVoice();
		currentVoice = presetVoice["midi.piano1"];

                delaySendLevel = 0.25;
                chorusSendLevel = 0;

                // effector setting
                var dly:SiEffectStereoDelay  = new SiEffectStereoDelay();
                dly.initialize();
                dly.setParameters(200,0.2,false);
                var cho:SiEffectStereoChorus = new SiEffectStereoChorus();
                cho.initialize();
                cho.setParameters(20,0.2,4,20);
                driver.effector.initialize();
                driver.effector.connect(1, dly);
                driver.effector.connect(2, cho);
                
                // start stream without initializing effector
//                driver.play(null, false);
                driver.play("@0 [c4]64", false);
        }
        
    // event handlers
    //--------------------------------------------------
        private function _onCompileProgress(e:SiONEvent) : void { ExternalInterface.call('SIOPM._internal_onCompileProgress', driver.jobProgress); }
        private function _onError(e:ErrorEvent)          : void { ExternalInterface.call('SIOPM._internal_onError', e.text); }
        private function _onStream(e:SiONEvent)          : void { ExternalInterface.call('SIOPM._internal_onStream'); }
        private function _onStreamStart(e:SiONEvent)     : void { ExternalInterface.call('SIOPM._internal_onStreamStart'); }
        private function _onStreamStop(e:SiONEvent)      : void { ExternalInterface.call('SIOPM._internal_onStreamStop'); }
        private function _onCompileComplete(e:SiONEvent) : void { ExternalInterface.call('SIOPM._internal_onCompileComplete', mmldata.title); }
        private function _onFadeInComplete(e:SiONEvent)  : void { ExternalInterface.call('SIOPM._internal_onFadeInComplete'); }
        private function _onFadeOutComplete(e:SiONEvent) : void { ExternalInterface.call('SIOPM._internal_onFadeOutComplete'); }
        
        
        
        
    // callback function
    //--------------------------------------------------
        private function _compile(mml:*) : Boolean
        {
            if (mml) {
                driver.compileQueue(mml, mmldata);
                driver.startQueue(200);
                return true;
            }
            return false;
        }
        
        
        private function _play() : void
        {
            driver.play(mmldata);
        }
        
        public function volume(v:*) : Number
	{
		return _volume(v);
	}

        private function _volume(v:*) : Number
        {
            var vol:Number = Number(v);
            if (!isNaN(vol)) {
                driver.volume = (vol<0) ? 0 : (vol>1) ? 1 : vol;
            }
            return driver.volume;
        }

    
        private function _pan(p:*) : Number
        {
            var pan:Number = Number(p);
            if (!isNaN(pan)) {
                driver.pan = (pan<-1) ? -1 : (pan>1) ? 1 : pan;
            }
            return driver.pan;
        }
        
        
        private function _position(p:*) : Number
        {
            var pos:Number = Number(p);
            if (!isNaN(pos)) {
                driver.position = pos;
            }
            return driver.position;
        }
        
        
        private function _fadeIn(t:*) : void
        {
            var time:Number = Number(t);
            if (!isNaN(time)) {
                driver.fadeIn(time);
            } else {
                driver.fadeIn(3);
            }
        }
        
        
        private function _fadeOut(t:*) : void
        {
            var time:Number = Number(t);
            if (!isNaN(time)) {
                driver.fadeOut(time);
            } else {
                driver.fadeOut(3);
            }
        }

        private function _noteOn(n:*) : *
        {
try {
                            var note:Number = Number(n);
                            var trk:SiMMLTrack = driver.noteOn(note, currentVoice, 0, 0, 0, 0, 0, 1, 1);
                            trk.channel.setStreamSend(1, delaySendLevel);
                            trk.channel.setStreamSend(2, chorusSendLevel);
			    return trk;
} catch (ex:*) {
return ex.toString();
}
        }

        private function _noteOff(n:*) : void
        {
          var note:Number = Number(n);
          driver.noteOff(note);
        }

		}