/**
 * Copyright Pelisalinet ( http://wonderfl.net/user/Pelisalinet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3tCZ
 */

package {
    import flash.utils.*;
    import flash.text.*;
    import flash.events.*;
    import flash.display.*;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    public class SimpleSmileyGame extends Sprite {
        
        private var manLoader:Loader = new Loader();
        private var enemyLoader:Loader = new Loader();
        private var enemyTimer:Timer = new Timer(800);
        private var enemys:Vector.<Bitmap> = new Vector.<Bitmap>();
        private var time:Timer = new Timer(1000);
        private var score:TextField = new TextField();
        private var sc:int = 0;
        private var enemyob:Bitmap = new Bitmap();
        private var t:TextField = new TextField();
        private var t2:TextField = new TextField();
        
        public function SimpleSmileyGame() {
            
            manLoader.load(new URLRequest('http://upload.wikimedia.org/wikipedia/commons/thumb/8/85/Smiley.svg/44px-Smiley.svg.png'), new LoaderContext(true));
            addChild(manLoader);
            
            enemyLoader.load(new URLRequest('http://pelisali.net/tanks/s/Skull2.png'), new LoaderContext(true));
            enemyLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, enemyComplete);
            
            enemyTimer.addEventListener(TimerEvent.TIMER, addEnemy);
            
            time.addEventListener(TimerEvent.TIMER, uTimer);
            time.start();
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            score.text = "0";
            score.width = stage.stageWidth;
            score.selectable = false;
            addChild(score);
        }
        
        private function hitTestHack (man:Loader, enemy:Bitmap):Boolean {
            // this function is form makc3d fork
            // man is 44px, enemy is 48 px
            // enemy is not perfect circle, but this is easiest way out
            var x1:Number = man.x + 22;
            var y1:Number = man.y + 22;
            var x2:Number = enemy.x + 24;
            var y2:Number = enemy.y + 24;
            return (x1 - x2)*(x1 - x2) + (y1 - y2)*(y1 - y2)*1.1 < 4 * 22 * 22;
        }        
        
        private function enemyComplete(e:Event):void {
            enemyLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, enemyComplete);
            enemyob = Bitmap(enemyLoader.content);
            enemyTimer.start();
        }
        
        private function uTimer(e:TimerEvent):void {
            sc++;
            score.text = sc.toString();
        }
        
        private function addEnemy(e:TimerEvent):void {
            var enemyBitmap:Bitmap = new Bitmap(enemyob.bitmapData);
            enemyBitmap.x = random(0, stage.stageWidth-48);
            addChild(enemyBitmap);
            enemys.push(enemyBitmap);
        }

        private function onEnterFrame(e:Event):void {
            for(var i:String in enemys){
                enemys[i].y += 1.5;
               
                if(enemys[i].y > stage.stageHeight){
                    removeChild(enemys[i]);
                    enemys.splice(int(i), 1);
                }else if(hitTestHack(manLoader,enemys[i])){
                    
                    enemyTimer.stop();
                    time.stop();
                    
                    var format:TextFormat = new TextFormat();
                    format.size = 35;
                    format.align = "center";
                    
                    t.text = "Game Over!";
                    t.setTextFormat(format);
                    t.y = stage.stageHeight/2;
                    t.width = stage.stageWidth;
                    t.selectable = false;
                    addChild(t);
                    
                    format.size = 15;
                    
                    t2.selectable = false;
                    t2.multiline = true;
                    t2.text = "Your score is "+sc+" seconds\nClick to play again.";
                    t2.setTextFormat(format);
                    t2.y = stage.stageHeight/2+40;
                    t2.width = t.width;
                    addChild(t2);
                    
                    stage.addEventListener(MouseEvent.CLICK, onClick);
                    removeEventListener(Event.ENTER_FRAME, onEnterFrame);
                    stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
                }
            }
        }
        
        private function onClick(e:Event):void {
            for(var i:String in enemys){
                removeChild(enemys[i]);
            }
            
            removeChild(t);
            removeChild(t2);
            
            enemys.length = 0;
            sc = 0;
            score.text = sc.toString();
            
            enemyTimer.start();
            time.start();
            
            stage.removeEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        
        private function random(low:Number=0, high:Number=1):Number{
            return Math.floor(Math.random() * (1+high-low)) + low;
        }
        
        private function onMouseMove(e:MouseEvent):void {
            manLoader.x = mouseX - 22;
            manLoader.y = mouseY - 22;
            if(manLoader.x < 0){ manLoader.x = 0;
            }else if(manLoader.x > stage.stageWidth-44){ manLoader.x = stage.stageWidth-44; }
            if(manLoader.y < 0){ manLoader.y = 0;
            }else if(manLoader.y > stage.stageHeight-44){ manLoader.y = stage.stageHeight-44; }
            e.updateAfterEvent();
        }

    }
}