/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3rrD
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	
	public class Main extends Sprite
	{
		private var bullets:Vector.<Bullet> = new Vector.<Bullet>();
		private var images:Array = new Array();
		private var canvas:BitmapData;
		private var frame:int = 0;
		
		public function Main()
		{		
			canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0);
			addChild(new Bitmap(canvas));
			
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
			loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/e/ee/ee9f/ee9f19360d9569ddcf91bc571f71488f3beb6840"), new LoaderContext(true));
		}
		
		private function initHandler(event:Event):void 
		{
			var loader:Loader = event.currentTarget.loader;
			
			for (var i:int = 0; i < 360; i++)
			{
				var matrix:Matrix = new Matrix();
				matrix.tx = -loader.width / 2;
				matrix.ty = -loader.height / 2;
				matrix.rotate(i * Math.PI / 180);
				matrix.tx += loader.width / 2;
				matrix.ty += loader.height / 2;
				
				var image:BitmapData = new BitmapData(loader.width, loader.height, false, 0x0);
				image.draw(loader, matrix);
				images.push(image);
			}
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(event:Event):void 
		{
			if (frame++ % 2 == 0)
			{
				var degree:int = Math.random() * 360;
				var tx:Number = 232 + Math.random() * 20 - 10;
				var ty:Number = 140 + Math.random() * 20 - 10;
				for (var d:int = degree; d < degree + 240; d += 10)
				{
					var bullet:Bullet = new Bullet();
					bullet.x = tx;
					bullet.y = ty;
					bullet.rotate = d % 360;
					bullet.tx = Math.cos(d * Math.PI / 180) * 5;
					bullet.ty = Math.sin(d * Math.PI / 180) * 5;
					bullets.push(bullet);
				}
			}
			canvas.fillRect(canvas.rect, 0x0);
			for (var i:int = 0; i < bullets.length; i++)
			{
				var b:Bullet = bullets[i];
				b.x += b.tx;
				b.y += b.ty;

				canvas.copyPixels(images[b.rotate], images[b.rotate].rect, new Point(b.x, b.y));

				if (b.x < -30 || 480 < b.x ||
					b.y < -30 || 480 < b.y) bullets.splice(i--, 1);
			}
		}
	}
}

class Bullet
{
	public var x:Number;
	public var y:Number;
	
	public var tx:Number;
	public var ty:Number;
	
	public var rotate:int;
}