/**
 * Copyright pego451 ( http://wonderfl.net/user/pego451 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3rZy
 */

package  {
    
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.events.Event;
    
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.events.InteractiveScene3DEvent;
    
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    
    import caurina.transitions.Tweener;
    
    [SWF(width = "465", height = "465", backgroundColor = "0", frameRate = "30")]
    
    public class Main extends Sprite {
        
        private const MAX:uint = 9;
        private const FIELDS_W:uint = 3000;
        
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var viewport:Viewport3D;
        private var render:BasicRenderEngine;
        
        private var isMouseTrace:Boolean = true;
        private var cube_vct:Vector.<Cube> = new Vector.<Cube>(MAX);
        
        public function Main() {
            // init
            scene = new Scene3D();
            viewport = new Viewport3D(0, 0, true, true);
            addChild(viewport);
            
            initCamera();
            initWall();
            initCube();
            initRender();
            
            onRenderEvent(true);
        };
        
        //init - camera
        private function initCamera():void {        
            camera = new Camera3D();
            camera.x = 0;
            camera.y = 0;
            camera.z = -5000;
            camera.focus = 100;
            camera.zoom = 10;
            camera.target = null;
        };
        
        //init - plane wall
        private function initWall():void {
            var color_mat:ColorMaterial = new ColorMaterial(0x000000, 1, true);
            
            var wall_plane:Plane = new Plane(color_mat, FIELDS_W, FIELDS_W, 20, 20);
            wall_plane.useOwnContainer = true;
            wall_plane.z = 500;
            
            var wall_do3d:DisplayObject3D = new DisplayObject3D();
            
            scene.addChild(wall_do3d);
            wall_do3d.addChild(wall_plane);
            
            wall_plane.addEventListener(InteractiveScene3DEvent.OBJECT_RELEASE, function() { isMouseTrace = true; } );
        };
        
        //init - cube
        private function initCube():void {
            for (var i:uint = 0; i < MAX; i++) {
                var nRandom = Math.floor(Math.random() * 0xffffffff);
                
                var color_mat:ColorMaterial = new ColorMaterial(nRandom);
                color_mat.interactive = true;
                
                var wire_mat:WireframeMaterial = new WireframeMaterial(0xffffff, 1, 1);
                
                var mList:MaterialsList = new MaterialsList(
                {
                   front:wire_mat,
                   back:color_mat,
                   right:wire_mat,
                   left:wire_mat,
                   top:wire_mat,
                   bottom:wire_mat
                }); 
                
                var cube:Cube = new Cube(mList, 280,  280,  280);
                cube.useOwnContainer = true;
                cube.extra = i;
                cube_vct[i] = cube;
                
                var btn:BtnPrimitive = new BtnPrimitive(cube, i, viewport);
                btn.addEventListener(CustomEvent.CUSTOM, monBtnPrimitiveRelease);
                
                scene.addChild(cube);
                
                cube_vct[i].x = Math.floor(i % 3) * 320 - 320;
                cube_vct[i].y = Math.floor(i / 3) * 320 - 320;
            }
        };
        
        //init - render
        private function initRender():void {
            render = new BasicRenderEngine();
        };
        
        private function onRenderEvent(b:Boolean):void {
            if (b) addEventListener(Event.ENTER_FRAME, render3D);
            else removeEventListener(Event.ENTER_FRAME, render3D);
        };
        
        private function render3D(evt:Event):void {
            render.renderScene(scene, camera, viewport);
            
            if (isMouseTrace) {
                var num:Number = mouseX / 465;
                onTweenCamera(num);
            }
        };
        
        public function onTweenCamera(percent:Number):void {
            var target_x:Number = 4000 * percent - 2000;
            var target_rot:Number = -40 * percent + 20;
            
            Tweener.addTween(camera, {
                x : target_x,
                y : 0,
                z : -5000,
                rotationY : target_rot,
                time : 2
            });
        };
        
        public function monBtnPrimitiveRelease(e:CustomEvent):void {
            isMouseTrace = false;
            
            var target_pos:DisplayObject3D = new DisplayObject3D();
            target_pos.copyTransform(e._obj);
            target_pos.moveBackward(1000);
            
            Tweener.addTween(camera, {
                x : target_pos.x,
                y : target_pos.y,
                z : target_pos.z,
                rotationX : target_pos.rotationX,
                rotationY : target_pos.rotationY,
                rotationZ : target_pos.rotationZ,
                time : 1.2,
                transition : "easeInOutExpo"
            });
        };
    }
};

//button
import flash.display.Sprite;
import flash.events.Event;
import org.papervision3d.events.InteractiveScene3DEvent;

class BtnPrimitive extends Sprite {
    private var _obj:*;
    private var _id:*;
    private var _vp:*;
    
    public function BtnPrimitive(obj:*, id:*, vp:*):void {            
        _obj = obj;
        _id = id;
        _vp = vp;
            
        _obj.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, monRollOver);
        _obj.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, monRollOut);
        _obj.addEventListener(InteractiveScene3DEvent.OBJECT_RELEASE, monRelease);
    };
    
    private function monRelease(e:InteractiveScene3DEvent):void {
        dispatchEvent(new CustomEvent(CustomEvent.CUSTOM, _obj));
    };
    
    private function monRollOver(e:InteractiveScene3DEvent):void {
        _vp.buttonMode = true;
    };
        
    private function monRollOut(e:InteractiveScene3DEvent):void {
        _vp.buttonMode = false;
    };
};

//event - custom
import flash.events.Event;

class CustomEvent extends Event {
    public static const CUSTOM:String = "custom";
    public var _obj:*;
    
    public function CustomEvent(type:String, obj:*) {
        super(type);
        _obj = obj;
    };
    
    public override function clone():Event {
        return new CustomEvent(type, _obj);
    };
    
    public override function toString():String {
        return formatToString("CustomEvent", "type", "bubbles", "cancelable", "eventPhase", "_obj");
    };
};