/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3qbe
 */

// This is something I wrote for the game I'm working on but removed a few days ago
// as I went in a different direction in the design. As the code is fairly self-contained
// I thought it might be of interest.

// The code generates a pie chart, entirely in code, though it could be easily used with art.
// It's designed to be dynamic so the chart can be re-drawn any time. Each chart is a BitmapData
// so easily added to the stage or drawn into another BitmapData.

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
[SWF(width="465", height="465", backgroundColor="0", frameRate="30")]
    public class FlashTest extends Sprite {
        public var aPie:Vector.<Pie>;
        public var aCharts:Vector.<Bitmap>;

        public function FlashTest() {
            var base:Bitmap = new Bitmap(new BitmapData(465, 465, false, 0xff000000));
            addChild(base);
            
            // write as3 code here..
            aPie = new Vector.<Pie>(4);
            aCharts = new Vector.<Bitmap>(4);
            aPie[0] = new Pie(30);
            aPie[1] = new Pie(40);
            aPie[2] = new Pie(40);
            aPie[3] = new Pie(30);

            aCharts[0] = new Bitmap(aPie[0]);
            aCharts[1] = new Bitmap(aPie[1]);
            aCharts[2] = new Bitmap(aPie[2]);
            aCharts[3] = new Bitmap(aPie[3]);

            aCharts[0].x = aCharts[1].x = 20;
            aCharts[2].x = aCharts[3].x = 150;
            aCharts[0].y = aCharts[2].y = 20;
            aCharts[1].y = aCharts[3].y = 150;

            addChild(aCharts[0]);
            addChild(aCharts[1]);
            addChild(aCharts[2]);
            addChild(aCharts[3]);

            aPie[0].Update(0.33333);
            aPie[1].Update(0.45);
            aPie[2].Update(0.7);
            aPie[3].Update(0.9);
        }
    }

}

	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.Graphics;
	import flash.display.Shape;

	import flash.filters.GlowFilter;
	import flash.filters.BitmapFilterQuality;

	import flash.geom.Point;

    class Pie extends BitmapData {
		
		public var fRadius:Number;
		public var fDiam:Number;
		public var datCirc:BitmapData;
		public var p0:Point;
		
		public var fCurr:Number, fAngle:Number;
		
		function Pie(fSize:Number) {
			fRadius = fSize;
			fDiam = fRadius * 2;
			super(fDiam, fDiam, true, 0);
			Make();
		} 
		
		public function Make():void {
			var shape:Shape, g:Graphics;
		
			datCirc = new BitmapData(fDiam, fDiam, true, 0);
			
			shape = new Shape();
			g = shape.graphics;
			g.beginFill(0xff0000);
			g.drawCircle(fRadius, fRadius, fRadius - 3);
			
			p0 = new Point();

			datCirc.draw(shape);
			datCirc.applyFilter(datCirc, rect, p0, 
				new GlowFilter(0xffff00, 0.7, 2, 2, 2, BitmapFilterQuality.HIGH, false, false));
			datCirc.copyChannel(datCirc, rect, p0, 
					BitmapDataChannel.RED, BitmapDataChannel.ALPHA);
			
			fCurr = 0;
		}
		
		public function Update(fFrac:Number):void {
			var  shape:Shape, g:Graphics;
			
			if (fFrac == fCurr) {
				return;
			}
			
			fCurr = fFrac;
			
			shape = new Shape();
			g = shape.graphics;

			fAngle = fCurr * 2 * Math.PI;
			var iOctant:int = fCurr * 8;
			g.beginFill(0xffffff);
			g.moveTo(fRadius, fRadius);
			g.lineTo(fRadius, 0);
			
			switch (iOctant) {
				case 0:
					g.lineTo((1 + Math.sin(fAngle)) * fRadius, 0);
					break;
				case 1:
				case 2:
					g.lineTo(fDiam, 0);
					g.lineTo(fDiam, (1 - Math.cos(fAngle)) * fRadius);
					break;
				case 3:
				case 4:
					g.lineTo(fDiam, 0);
					g.lineTo(fDiam, fDiam);
					g.lineTo((1 + Math.sin(fAngle)) * fRadius, 2 * fRadius);
					break;
				case 5:
				case 6:
					g.lineTo(fDiam, 0);
					g.lineTo(fDiam, fDiam);
					g.lineTo(0, fDiam);
					g.lineTo(0, (1 - Math.cos(fAngle)) * fRadius);
					break;
				case 7:
					g.lineTo(fDiam, 0);
					g.lineTo(fDiam, fDiam);
					g.lineTo(0, fDiam);
					g.lineTo(0, (1 - Math.cos(fAngle)) * fRadius);
					break;
			}
			
			g.lineTo(fRadius, fRadius);
			g.endFill();
			
			draw(shape);
			copyChannel(this, rect, p0, 
					BitmapDataChannel.RED, BitmapDataChannel.ALPHA);
//			copyPixels(this, rect, p0, datCirc);
			copyPixels(datCirc, rect, p0, this);
			
			
		}
	}
