/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3pfM
 */

package  
{
	import flash.display.Sprite;
	
	/**
	 * FlashDevelop でトレースを表示する。
	 * @author jc at bk-zen.com
	 */
	public class FDTraceTest extends Sprite
	{
		
		public function FDTraceTest() 
		{
			FCLite.trace("test");
			FCLite.trace("FlashDevelop の Output Panel に表示されるよ。", "まぁあんまり意味ないけどｗ");
		}
		
	}
	
}
import flash.events.DataEvent;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.SecurityErrorEvent;
import flash.net.XMLSocket;
import flash.utils.clearInterval;
import flash.utils.setInterval;
import flash.xml.XMLDocument;
import flash.xml.XMLNode;

/**
* Connects a flash movie thru XmlSocket to the FlashDevelop program.
* org.flashdevelop.utils.FlashConnect を 簡易バージョンにしました。
* あと FlashConnect は名前が長いので短くした。ごめんなさい。
* @author Mika Palmu
* @version 3.1
*/
class FCLite
{
	public static var status: Number = 0;
	public static var limit: Number = 1000;
	public static var host: String = "localhost";
	public static var port: Number = 1978;
	
	private static var socket: XMLSocket;
	private static var messages: Array;
	private static var interval: Number;
	private static var counter: Number;
	
	/**
	 * Add a trace command to the mesage stack, AS3 style
	 * @param	...rest
	 */
	public static function trace(...rest): void
	{
		var result: String = rest.join(",");
		var message: XMLNode = createMsgNode(result, 1);
		FCLite.send(message);
	}
	
	static private function createMsgNode(message: String, level: Number): XMLNode
	{
		if (isNaN(level)) level = 1;
		var msgNode:XMLNode = new XMLNode(1, null);
		var txtNode:XMLNode = new XMLNode(3, encodeURI(message));
		msgNode.attributes.state = level.toString();
		msgNode.attributes.cmd = "trace";
		msgNode.nodeName = "message";
		msgNode.appendChild(txtNode);
		return msgNode;
	}
	
	public static function send(message: XMLNode): void
	{
		if (messages == null) initialize();
		messages.push(message);
	}
	
	private static function initialize():void
	{
		counter = 0;
		messages = [];
		socket = new XMLSocket();
		socket.addEventListener(DataEvent.DATA, onData);
		socket.addEventListener(Event.CONNECT, onConnect);
		socket.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
		socket.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onSecurityError);
		interval = setInterval(sendStack, 50);
		socket.connect(host, port);
	}
	
	static private function sendStack():void
	{
		if (messages.length > 0 && status == 1)
		{
			var message: XMLDocument = new XMLDocument();
			var rootNode: XMLNode = message.createElement("flashconnect");
			while (messages.length > 0)
			{
				counter++;
				if (counter > limit)
				{
					clearInterval(interval);
					var errorNode: XMLNode = createMsgNode("FlashConnect aborted. You have reached the limit of maximum messages.", 3);
					rootNode.appendChild(errorNode);
					break;
				}
				else
				{
					var msgNode: XMLNode = XMLNode(messages.shift());
					rootNode.appendChild(msgNode);
				}
			}
			message.appendChild(rootNode);
			socket.send(message);
		}
	}
	
	private static function onConnect(e:Event):void { FCLite.status = 1; }
	
	private static function onData(e:DataEvent):void { FCLite.status = 1; }
	
	private static function onIOError(e:IOErrorEvent):void { FCLite.status = -1; }
	
	private static function onSecurityError(e:SecurityErrorEvent):void { FCLite.status = -1; }
	
	
	
}
