/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3onB
 */

// 雪っぽく
// マウスオーバーで詳細表示 (MouseOver to print description)
// クリックで固定 (Click to hook)
// forked from Event's CBC NET
package {
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.text.TextField;
    import jp.progression.commands.net.*;
    import flash.net.*;
    import flash.filters.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.display.*;
    
    public class FlashTest extends Sprite {
        private var _tf : TextField;
        
        private var _tfDesc : TextField;
        
        private static const XML_PATH:String = 'http://assets.wonderfl.net/static/assets/session5/cbcnet_feed.xml';
        private var _data : Array = [];
        private var _W : Number;
        private var _H : Number;
        
        public function FlashTest() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _tfDesc = new TextField();
            addChild(_tfDesc);
            _tfDesc.alpha = 0.6;
            _tfDesc.background = true;
            _tfDesc.backgroundColor = 0xffff77;
            _tfDesc.wordWrap = true;
            _tfDesc.multiline = true;
            
            addEventListener(Event.RESIZE, onResize);
            onResize(null);
            
            _tf = new TextField();
//            addChild(_tf);
            
            _bmdSnow = new BitmapData(20, 20, true, 0x00000000);
            var sh : Shape = new Shape();
            var mat : Matrix = new Matrix();
            mat.createGradientBox(20, 20);
            sh.graphics.beginGradientFill("radial", [0xffffff, 0x000000], [1, 1], [0x00, 0xff], mat);
            sh.graphics.drawRect(0, 0, 20, 20);
            sh.graphics.endFill();
            _bmdSnow.draw(sh);
            // ineffecient
            for(var y : uint = 0;y < 20;y++){
                for(var x : uint = 0;x < 20;x++){
                    var u : uint = _bmdSnow.getPixel(x, y);
                    _bmdSnow.setPixel32(x, y, (uint((u & 255) / 2) << 24) | u);
                }
            }

            
            var lu : LoadURL = new LoadURL(new URLRequest(XML_PATH));
            lu.onComplete = function() : void {
                var xml : XML = XML(lu.data);
                var len : uint = xml.channel.item.length();
                for(var i : uint = 0;i < len;i++){
                    var item : XML = xml.channel.item[i];
                    _data.push({
                        title : item.title.toString(),
                        image : item.image.toString(),
                        link : item.link.toString(),
                        category : item.category.toString(),
                        tag : item.tag.toString(),
                        description : item.description.toString(),
                        bmd : null
                    });
                }
                
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
            };
            lu.execute();
        }
        
        private function onResize(e : Event) : void
        {
            _W = stage.stageWidth;
            _H = stage.stageHeight;
            _tfDesc.x = 0;
            _tfDesc.width = _W;
            _tfDesc.y = _H - 200;
            _tfDesc.height = 200;
            var mat : Matrix = new Matrix();
            mat.createGradientBox(_W, _H, 1.57);

            graphics.clear();
            graphics.beginGradientFill("linear", [0x07070f, 0x37377f], [1, 1], [0x00, 0xff], mat);
            graphics.drawRect(0, 0, _W, _H);
            graphics.endFill();
        }
        
        private var _t : int = -Math.random() * 99999999;
        
        private function onEnterFrame(e : Event) : void
        {
            if(_t % 30 == 0)appendItem();
            if(_t % 5 == 0)setupSnow();
            moveThumbs();
            moveSnows();
            _t++;
        }
        
        private function moveThumbs() : void
        {
            for(var i : uint = 0;i < _thumbs.length;i++){
                var th : Object = _thumbs[i];
                if(th.moving){
                    th.theta += th.omega;
                    th.spr.rotation = 30 * Math.sin(th.theta);
                    th.spr.x += th.vx;
                    th.spr.y += th.vy;
                    if(th.bmp.y >= _H){
                        removeChild(th.spr);
                        if(i == _thumbs.length - 1){
                            _thumbs.pop();
                        }else{
                            _thumbs[i] = _thumbs.pop();
                            i--;
                        }
                    }
                }
            }
        }
        
        private function moveSnows() : void
        {
            for(var i : uint = 0;i < _snows.length;i++){
                var sn : Object = _snows[i];
                sn.vx += (Math.random() - 0.5) * 0.1;
                sn.bmp.x += sn.vx;
                sn.bmp.y += sn.vy;
                if(sn.bmp.y >= _H){
                    removeChild(sn.bmp);
                    if(i == _snows.length - 1){
                        _snows.pop();
                    }else{
                        _snows[i] = _snows.pop();
                        i--;
                    }
                }
            }
        }
        
        private function appendItem() : void
        {
            var ind : uint = Math.random() * _data.length;
            if(_data[ind].bmd == null){
                var li : LoadBitmapData = new LoadBitmapData(new URLRequest(_data[ind].image));
                li.onComplete = function() : void {
                    _data[ind].bmd = li.data;
                    setupThumb(ind);
                };
                li.execute();
            }else{
                setupThumb(ind);
            }
        }
        
        private var BW : uint = 130;
        private var BH : uint = 130;
        private var _thumbs : Array = [];
        private var _snows : Array = [];
        private var _bmdSnow : BitmapData = null;
        
        private function setupThumb(ind : uint) : void
        {
            var x : Number = Math.random() * _W;
            var bmp : Bitmap = new Bitmap(_data[ind].bmd);
            bmp.scaleX = BW / _data[ind].bmd.width;
            bmp.scaleY = BH / _data[ind].bmd.height;
            bmp.x = -BW / 2;
            bmp.y = -10;
            
            var spr : Sprite = new Sprite();
            spr.x = x;
            spr.y = 0 - BH * 1.5;
            spr.mouseChildren = false;
            spr.addChild(bmp);
            spr.addEventListener(MouseEvent.CLICK, onClick);
            spr.addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
            spr.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
            addChildAt(spr, 0);
            _thumbs.push({
                spr : spr,
                ind : ind,
                bmp : bmp, 
                vx : Math.random() * 2 - 1, 
                vy : Math.random() * 1 + 1, 
                theta : Math.random() * 3.14, 
                omega : Math.random() * 0.03 + 0.03,
                moving : true
                });
        }
        
        private function setupSnow() : void
        {
            var x : Number = Math.random() * _W;
            var bmp : Bitmap = new Bitmap(_bmdSnow);
            bmp.x = x;
            bmp.y = -20;
            
            addChildAt(bmp, 0);
            _snows.push({
                bmp : bmp, 
                vx : Math.random() * 2 - 1, 
                vy : Math.random() * 1 + 1
                });
        }
        
        private function onMouseOver(e : MouseEvent) : void
        {
            var spr : Sprite = e.target as Sprite;
            // ineffecient
            for(var i : uint = 0;i < _thumbs.length;i++){
                if(_thumbs[i].spr === spr){ 
                    _tfDesc.htmlText = "<b>" + _data[_thumbs[i].ind].title + "</b><br>" + _data[_thumbs[i].ind].description;
                    break;
                }
            }
        }

        private function onMouseOut(e : MouseEvent) : void
        {
            _tfDesc.text = "";
        }
        
        private function onClick(e : MouseEvent) : void
        {
            var spr : Sprite = e.target as Sprite;
            // ineffecient
            for(var i : uint = 0;i < _thumbs.length;i++){
                if(_thumbs[i].spr === spr){
                    _thumbs[i].moving = !_thumbs[i].moving;
                    break;
                }
            }
        }
        
        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
        }
    }
    
}