/**
 * Copyright tequibo ( http://wonderfl.net/user/tequibo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3oZz
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Rectangle;
    
    /**
     * ...
     * @author tequibo
     */
    public class Digger extends Sprite {
        private var bmapData:BitmapData;
        private var bitmap:Bitmap;
        private var diggersArr:Array;
        private var blurrr:BlurFilter;
        private var size:Number = 3;
        public function Digger():void {
            if (stage)
                init();
            else
                addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            //diggersArr = [newDigger(50,50,0xffffff*Math.random())]
            diggersArr = []
            bmapData = new BitmapData(800, 600, false, 0x1E1E1E)
            blurrr = new BlurFilter(2, 2, 3)
            bitmap = new Bitmap(bmapData);
            addChild(bitmap)
            addEventListener(Event.ENTER_FRAME, onFrame)
            stage.addEventListener(MouseEvent.CLICK, onClick)
            stage.addEventListener(KeyboardEvent.KEY_DOWN, stage_keyDown);
        }
        
        private function stage_keyDown(e:KeyboardEvent):void {
            if (e.keyCode == 32) {
                diggersArr = [];
                bmapData.fillRect(new Rectangle(0, 0, 500, 500), 0x1E1E1E);
            }
        }
        
        private function onClick(e:MouseEvent):void {
            //size = Math.random() * 13 + 1;
            diggersArr = [];
            bmapData.fillRect(new Rectangle(0, 0, 500, 500), 0x1E1E1E);
            diggersArr.push(newDigger(mouseX/(size+1), mouseY/(size+1), 0xffffff*Math.random(), size));
            //diggersArr.push(newDigger(mouseX/(size+1), mouseY/(size+1), 0xffffff, size));
        }
        private function newDigger(setX:Number, setY:Number, setColor:Number, setSize:Number = 3):Object {
            var _digger:Object = { x: setX, y: setY, dx: 0, dy: 0, hp: 300, color: setColor, childs:0, size:setSize };
            return _digger;
        }
        public function random2(min:Number, max:Number):Number {
            return Math.floor(min + Math.random() * (max - min + 1));
        }
        public static function interpolateColor(fromColor:uint, toColor:uint, progress:Number):uint
        {
            var q:Number = 1-progress;
            var fromA:uint = (fromColor >> 24) & 0xFF;
            var fromR:uint = (fromColor >> 16) & 0xFF;
            var fromG:uint = (fromColor >>  8) & 0xFF;
            var fromB:uint =  fromColor        & 0xFF;
            var toA:uint = (toColor >> 24) & 0xFF;
            var toR:uint = (toColor >> 16) & 0xFF;
            var toG:uint = (toColor >>  8) & 0xFF;
            var toB:uint =  toColor        & 0xFF;
            var resultA:uint = fromA*q + toA*progress;
            var resultR:uint = fromR*q + toR*progress;
            var resultG:uint = fromG*q + toG*progress;
            var resultB:uint = fromB*q + toB*progress;
            var resultColor:uint = resultA << 24 | resultR << 16 | resultG << 8 | resultB;
            return resultColor;
        }
        private function onFrame(e:Event):void {
            for (var i:int = 0; i < diggersArr.length; i++){
                var _digger:Object = diggersArr[i];
                //trace(Helpers.random2(0,3))
                if (Math.random() > .4){
                    switch (random2(0, 3)){
                        case 0: 
                            _digger.dy = -1;
                            _digger.dx = 0;
                            break;
                        case 1: 
                            _digger.dy = 0;
                            _digger.dx = 1;
                            break;
                        case 2: 
                            _digger.dy = 1;
                            _digger.dx = 0;
                            break;
                        case 3: 
                            _digger.dx = -1;
                            _digger.dy = 0;
                            break;
                    }
                }
                _digger.x += _digger.dx;
                _digger.y += _digger.dy;
                _digger.hp -= 1;
                //bmapData.setPixel(_digger.x, _digger.y, _digger.color)
                bmapData.fillRect(new Rectangle(_digger.x*(_digger.size+1), _digger.y*(_digger.size+1), _digger.size, _digger.size), interpolateColor(_digger.color,0xffffff,1-_digger.hp/300))
                if ((Math.random() > .95) && (diggersArr.length < 100) && (_digger.childs < 1)){
                    //diggersArr.push(newDigger(_digger.x, _digger.y, interpolateColor(_digger.color,0xffffff,.1), Math.random()*11+1))
                    diggersArr.push(newDigger(_digger.x, _digger.y, Math.random()*0xffffff, size))
                    //diggersArr.push(newDigger(_digger.x, _digger.y, 0xffffff, Math.random()*3+1))
                    _digger.childs += 1;
                }
                if (_digger.hp < 0){
                    diggersArr.splice(i, 1)
                }
            }
        }
    }
}