/**
 * Copyright keno42 ( http://wonderfl.net/user/keno42 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3oLT
 */

package {
    import flash.display.*;
    import flash.media.*;
    import flash.text.*;
    import com.bit101.components.*;
    import flash.events.*;
    public class FlashTest extends Sprite {
        private var stopBtn:PushButton;
        private var startBtn:PushButton;
        private var bmp:Bitmap;
        private var infoTxt:TextField = new TextField();
        private var video:Video = new Video(465, 465*240/320);
        private var mpA:MovablePoint = new MovablePoint(3, 0xFF0000, true);
        private var mpB:MovablePoint = new MovablePoint(3, 0xFF0000, true);
        private var drawingLayer:Sprite = new Sprite();
        public function FlashTest() {
            // write as3 code here..
            startCamera();
            addChild(video);
            bmp = new Bitmap( new BitmapData( video.width, video.height ) );
            bmp.visible = false;
            addChild(bmp);
            infoTxt.autoSize = "left";
            infoTxt.x = 5;
            infoTxt.y = bmp.bitmapData.height + 5;
            addChild(infoTxt);
            addChild(drawingLayer);
            stopBtn = new PushButton(this, 5, 440, "stop camera", onStop);
            startBtn = new PushButton(this, 5, 440, "start camera", onStart);
            stopBtn.visible = true;
            startBtn.visible = false;
        }
        private function onClick(e:MouseEvent):void{
            if( e.stageY < video.height ){
                if( mpA.parent == null ){
                    this.addChild( mpA );
                    mpA.x = e.stageX;
                    mpA.y = e.stageY;
                } else if( mpB.parent == null ){
                    this.addChild( mpB );
                    mpB.x = e.stageX;
                    mpB.y = e.stageY;
                    this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
                }
            }
        }
        private function onEnterFrame(e:Event):void{
            drawingLayer.graphics.clear();
            drawingLayer.graphics.lineStyle(0, 0x888888);
            drawingLayer.graphics.moveTo(0, 0.5*(mpA.y+mpB.y));
            drawingLayer.graphics.lineTo(465, 0.5*(mpA.y+mpB.y));
            drawingLayer.graphics.lineStyle(2, 0xFF00FF);
            drawingLayer.graphics.moveTo(mpA.x, mpA.y);
            drawingLayer.graphics.lineTo(mpB.x, mpB.y);
            var lean:String = String(0.01*Math.round(100*180*((mpB.x>mpA.x)?Math.atan2(-mpB.y+mpA.y, mpB.x-mpA.x):Math.atan2(-mpA.y+mpB.y, mpA.x-mpB.x))/Math.PI));
            if( lean.length > 5 ){
                lean = lean.substr(0,4);
            }
            infoTxt.text = "このラインの傾きは" + lean + "度です。";
        }
        private function startCamera():void{
            this.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            infoTxt.text = "stop cameraを押すと画面を静止して点を配置できます。";
            drawingLayer.graphics.clear();
            if( mpA.parent ) mpA.parent.removeChild(mpA);
            if( mpB.parent ) mpB.parent.removeChild(mpB);
            var camera:Camera = Camera.getCamera();
            if(camera != null){
                video.attachCamera(camera);
            } else {
                addChild( makeNoCamera() );
            }
        }
        private function onStop(event:MouseEvent):void{
            bmp.visible = true;
            bmp.bitmapData.draw(video);
            startBtn.visible = true;
            stopBtn.visible = false;
            video.attachCamera(null);
            this.stage.addEventListener(MouseEvent.CLICK, onClick);
            infoTxt.text = "画面をクリックして点を配置してください";
        }
        private function onStart(event:MouseEvent):void{
            bmp.visible = false;
            startBtn.visible = false;
            stopBtn.visible = true;
            startCamera();
            this.stage.removeEventListener(MouseEvent.CLICK, onClick);
        }
        private function makeNoCamera():TextField{
            var tf:TextField = new TextField();
            tf.text = "カメラが接続されていません。接続して再読み込みしてください。";
            tf.autoSize = "left";
            tf.x = 0.5*(465-tf.textWidth);
            tf.y = 50;
            return tf;
        }
    }
}

import flash.display.*;
import flash.events.*;
// ドラッグで移動する点
class MovablePoint extends Sprite{
    public function MovablePoint(radius:Number, color:uint, isMovable:Boolean){
        this.graphics.lineStyle(1, color);
        this.graphics.beginFill(color & 0xFFFFFF, 0.75);
        this.graphics.drawCircle(0, 0, radius);
        
        if( isMovable ){
            this.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
            this.buttonMode = true;
        }
    }
    private function onDown(e:MouseEvent):void{
        this.startDrag();
        this.dispatchEvent(new Event("startRefresh"));
        this.addEventListener(MouseEvent.MOUSE_UP, onUp);
        this.stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
    }
    private function onUp(e:MouseEvent):void{
        this.stopDrag();
        this.dispatchEvent(new Event("stopRefresh"));
        this.removeEventListener(MouseEvent.MOUSE_UP, onUp);
        this.stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
    }
}