/**
 * Copyright Andras ( http://wonderfl.net/user/Andras )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3oCZ
 */

package {
    import flash.display.GraphicsGradientFill;
    import flash.display.IGraphicsFill;
    import flash.display.Sprite;
    import flash.events.Event;
    /**
     * ...
     * @author Polgár András
     */
    public class Lang extends Sprite
    {
        private var Langnyelvek:Vector.<Langnyelv>
        private var Fills:Vector.<IGraphicsFill>
        private var FillsDark:Vector.<IGraphicsFill>
        
        public function Lang() 
        {
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init)
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init)
            
            var s:Number = 1
            setupStyleVectors()
            
            
            Langnyelvek = new Vector.<Langnyelv>
            
            for (var i:uint = 0; i < 32; i++)
            {
                s -= s / 6
                
                var l:Langnyelv
                l = new Langnyelv(.025 + rand(.005)
                                 ,4 + rand(1.2) + s * 4
                                 ,78 + s * 62 + rand(40)
                                 ,.3 + rand(.04)
                                 ,rand(Math.PI)
                                 ,23 + rand(12) + s * 33
                                 ,Math.PI/2 + rand(.2) + s * .2
                                 ,Fills[uint(Fills.length * Math.random())]
                                 )
                l.x = stage.stageWidth / 2 + rand(40)
                l.rotation = -90
                l.y = stage.stageHeight
                l.scaleX = l.scaleY = 2
                Langnyelvek.push(l)
                addChild(l)
            }
            
            for(var j:uint = Langnyelvek.length; j > Langnyelvek.length - 7; j++)
            {
                
            }
 
            
            addEventListener(Event.ENTER_FRAME, refresh)
            
            function rand(r:Number):Number
            { return 2 * r * Math.random() - r }
        }
        
        private function refresh(e:Event):void
        {
            for (var i:uint = 0; i < Langnyelvek.length; i++)
            {
                Langnyelvek[i].render()
            }
        }
        
        private function setupStyleVectors():void
        {
            Fills = new Vector.<IGraphicsFill>
            Fills.push(new GraphicsGradientFill('linear', [0xCC0000, 0xDDDD00]))
            Fills.push(new GraphicsGradientFill('linear', [0x970000, 0xF87A00]))
            Fills.push(new GraphicsGradientFill('linear', [0xE40000, 0xFFD200]))
            Fills.push(new GraphicsGradientFill('linear', [0xFC7000, 0xFDE75A]))
            
            FillsDark = new Vector.<IGraphicsFill>
            FillsDark.push(new GraphicsGradientFill('linear', [0x4E0000, 0x380001]))
        } 
    }
}

import flash.display.GraphicsGradientFill;
import flash.display.GraphicsPath;
import flash.display.GraphicsPathCommand
import flash.display.GraphicsSolidFill;
import flash.display.GraphicsStroke;
import flash.display.IGraphicsData;
import flash.display.IGraphicsFill;
import flash.display.IGraphicsStroke;
import flash.display.Shape;
import flash.display.GradientType
import flash.events.Event;
/**
 * ...
 * @author Polgár András
 */
class Langnyelv extends Shape
{
    private var Density:Number
    private var Grossness:Number
    private var FlamWidth:Number
    private var WaveSpeed:Number
    private var WaveStart:Number
    private var Amplitude:Number
    private var AmpLength:Number
    
    private var ActualFlamWidth:Number
    private var TargetFlamWidth:Number
    
    private var BaseCurve:Vector.<Number>
    private var FillType:IGraphicsFill
    private var StrokeType:IGraphicsStroke
    private var DrawCommans:GraphicsPath
    private var GraphisDatas:Vector.<IGraphicsData>
    
    public function Langnyelv(density:Number = .023,
                              grossness:Number = 8,
                              flamWidth:Number = 180,
                              waveSpeed:Number = .32,
                              waveStart:Number = 0,
                              amplitude:Number = 46,
                              ampLength:Number = 1.8,
                              fillType:IGraphicsFill = null,
                              strokeType:IGraphicsStroke = null)
    {
        Density = density
        Grossness = grossness
        FlamWidth = flamWidth
        WaveSpeed = waveSpeed
        WaveStart = waveStart
        Amplitude = amplitude
        AmpLength = ampLength
        
        ActualFlamWidth = 0
        TargetFlamWidth = FlamWidth
        
        FillType = fillType;
        StrokeType = strokeType;
        DrawCommans = new GraphicsPath
        
        GraphicsGradientFill(FillType).ratios = [163, 255]
        
        StrokeType = new GraphicsStroke(1)
        GraphicsStroke(StrokeType).fill = new GraphicsSolidFill(0xffaa00)
        
        GraphisDatas = new Vector.<IGraphicsData>
        if (FillType) { GraphisDatas.push(FillType) }
        if (StrokeType) { GraphisDatas.push(StrokeType) }
        GraphisDatas.push(DrawCommans)
    }
    
    public function render():void
    {
        var i:int
        var w:Number
        var pos:Number
        DrawCommans.commands = new Vector.<int>
        DrawCommans.data = new Vector.<Number>
        
        if (Math.abs(TargetFlamWidth - ActualFlamWidth) < 1)
        {
            TargetFlamWidth = FlamWidth * (1 + (.5 * Math.random() - .25))
        } else {
            ActualFlamWidth += (TargetFlamWidth - ActualFlamWidth) / 2
        }
        
        WaveStart -= WaveSpeed
        
        for (i = uint(ActualFlamWidth); i >= 0; --i)
        {
            pos = Math.sin(WaveStart + i * Density)
            pos *= Math.sin(AmpLength * i / ActualFlamWidth) * Amplitude
            w = Grossness * (1 - i / ActualFlamWidth)
            
            DrawCommans.commands.push(2)
            DrawCommans.data.push(i, pos + w)
            DrawCommans.commands.unshift(2)
            DrawCommans.data.unshift(i, pos - w)
            
        }
        
        DrawCommans.commands[0] = 1
        graphics.clear()
        graphics.drawGraphicsData(GraphisDatas)
        
    }
    
}
