/**
 * Copyright code ( http://wonderfl.net/user/code )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3noP
 */

// forked from Event's Simple MediaRSS Viewer

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	import flash.system.LoaderContext;
	import org.libspark.betweenas3.BetweenAS3;

	
	/**
	 * ...
	 * @author code
	 */
	public class Main_T extends Sprite 
	{
		/*******************************************************
		* 変数
		********************************************************/
		//MedisRSS
		private var feed:String = "http://api.flickr.com/services/feeds/photos_public.gne?tags=kamakura&format=rss_200";
		private var media:Namespace = new Namespace("http://search.yahoo.com/mrss/");
		
		//ImageBall用
		private var stageW:Number;
		private var stageH:Number;
		private var interBase:Sprite;
		private var picBase:Sprite;
		private var base:Sprite;
		private var picLength:uint;
		private var thumbs:Array;
		private var isMouseOut:Boolean=true;
		private var myAngle:Number=Math.PI/100;
		private var axisAngle:Number = Math.PI * 2 / 3;
		private var vx:Number;
		private var vy:Number;
		private var myCos:Number;
		private var mySin:Number;
		private var posX:Number;
		private var posY:Number;
		private var posZ:Number;
		private var RADIUS:Number = 200;
		private var urls:Array;
		private var isShow:Boolean = false;
		private var picLoader:Loader;
		private var progBar:Shape;
		private var par:Number;
		
		/*******************************************************
		* コンストラクタ
		********************************************************/
		public function Main_T()
		{	
			init();
		}
		
		/*******************************************************
		* 関数
		********************************************************/
		private function init():void
		{
			//ステージ設定
			stage.quality = StageQuality.MEDIUM;
			stage.quality = StageAlign.TOP_LEFT;
			stageW = stage.stageWidth;
			stageH = stage.stageHeight;
			
			//ベース作成
			createBases();
			
			//プログレスバー作成
			createProgressBar();
			
			//MediaRSS読込
			mediaRSSReader();
			
			//イベントリスナー登録
			stage.addEventListener(MouseEvent.MOUSE_OVER, onMouseOverHandler);
			stage.addEventListener(MouseEvent.MOUSE_OUT, onMouseOutHandler);
			
		}
		
		//プログレスバー作成
		private function createProgressBar():void
		{
			progBar = new Shape();
			var g:Graphics = progBar.graphics;
			g.beginFill(0xffffff);
			g.drawRect(0, 0, stageW - 50, 5);
			g.endFill();
			progBar.scaleX = 0;
		}
		
		//ベース作成
		private function createBases():void 
		{
			//マウス操作用ベース作成
			interBase = new Sprite();
			var g:Graphics = interBase.graphics;
			g.beginFill(0x000000,0);
			g.drawRect(0, 0, stageW, stageH);
			g.endFill();
			addChild(interBase);
			
			//サムネイル配置用ベース作成
			base = new Sprite();
			base.x = stageW / 2;
			base.y = stageH / 2;
			base.z=RADIUS;
			interBase.addChild(base);
			
			//通常画像配置用ベース作成
			picBase = new Sprite();
			var pg:Graphics = picBase.graphics;
			pg.beginFill(0x000000, 0.8);
			pg.drawRect(0, 0, stageW, stageH);
			pg.endFill();
			picBase.x = picBase.y = 0;
			picBase.addEventListener(MouseEvent.CLICK, forRemovePicHandler);
		}
		
		/*******************************************************
		* MedisRSS読込処理
		********************************************************/
		private function mediaRSSReader():void
		{
			var ldr:URLLoader = new URLLoader();
			ldr.addEventListener(Event.COMPLETE, onLoadedHandler);
			ldr.load(new URLRequest(feed));
		}

		private function onLoadedHandler(e:Event):void 
		{
			var myTarget:Object = e.currentTarget;
			//サムネイルＵＲＬ格納・座標設定
			setImage(XML(myTarget.data)..media::thumbnail.@url.toXMLString().split('\n'));
			//通常画像ＵＲＬ格納
			urls = [];
			urls=XML(myTarget.data)..media::content.@url.toXMLString().split('\n');
			//リスナー解放
			myTarget.removeEventListener(Event.COMPLETE, onLoadedHandler);
		}
		
		//座標設定
		private function setImage(pics:Array):void 
		{
			//画像数格納
			picLength = pics.length;
			
			//サムネイル画像格納用配列初期化
			thumbs = [];
			
			//角度格納用変数
			var angAlpha:Number;
			var angBeta:Number;
			
			//画像配置
			for (var i:int = 0; i < picLength; i++) 
			{
				//サムネイル読込・初期設定
				var thumbLoader:Loader = new Loader();
				thumbLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onThumbLoaderCompleteHandler);
				thumbLoader.load(new URLRequest(pics[i]), new LoaderContext(true));
				thumbLoader.addEventListener(MouseEvent.CLICK, onClickHandler);
				thumbLoader.name = i.toString();
				thumbs.push(thumbLoader);
				base.addChild(thumbs[i]);
				
				//座標決定
				angAlpha = Math.acos((2 * (i + 1) - 1) /picLength - 1);
				angBeta = Math.sqrt(picLength * Math.PI) * angAlpha;
				thumbs[i].x = RADIUS * Math.cos(angBeta) * Math.sin(angAlpha);
				thumbs[i].y = RADIUS * Math.cos(angAlpha);
				thumbs[i].z = RADIUS * Math.sin(angBeta) * Math.sin(angAlpha);
            }
			
			//ループ処理用イベント登録
			addEventListener(Event.ENTER_FRAME, loopHandler);
 		
		}
		
		

		
		private function onThumbLoaderCompleteHandler(e:Event):void 
		{
			//サムネイルの基準点を自身の中心へ
			var bmp:Bitmap = e.currentTarget.content;
			bmp.x = -bmp.width / 2;
			bmp.y = -bmp.height / 2;
			//イベントリスナー解放
			e.currentTarget.loader.removeEventListener(Event.COMPLETE, onThumbLoaderCompleteHandler);	
		}
		
		/*******************************************************
		* ループ処理
		********************************************************/
		private function loopHandler(e:Event):void 
		{
			if(!isShow){
				if (isMouseOut) {
					myAngle *= 0.97;
				}else {
					myAngle = -Math.min(RADIUS, Math.max(Math.abs(mouseY - stageH / 2), Math.abs(mouseX - stageW / 2))) / 4000;
				}
				
				//回転軸計算
				axisAngle = Math.PI / 2 + Math.atan2((mouseY - stageH / 2), (mouseX - stageW / 2));
				
				//軸の単位ベクトル
				vx = Math.cos(axisAngle);
				vy = Math.sin(axisAngle);
				
				//角度
				myCos = Math.cos(myAngle);
				mySin = Math.sin(myAngle);
				
				//深度ソート１
				thumbs.sortOn("z", Array.NUMERIC | Array.DESCENDING);
				
				//座標計算
				for (var i:uint = 0; i < picLength; i++)
				{
					//深度ソート２
					base.setChildIndex(thumbs[i], i);
					
					//座標計算
					posX = thumbs[i].x*((1 - myCos) *Math.pow(vx,2) + myCos) + thumbs[i].y*(vx * vy*(1 - myCos)) - thumbs[i].z*vy * mySin;
					posY= thumbs[i].x*(vx * vy*(1 - myCos)) +thumbs[i].y*((1 - myCos) * Math.pow(vy,2) + myCos) +thumbs[i].z*vx* mySin;
					posZ = thumbs[i].x * vy * mySin - thumbs[i].y * vx * mySin +thumbs[i].z * myCos;
					
					//移動後の座標を登録
					thumbs[i].x = posX;
					thumbs[i].y = posY;
					thumbs[i].z = posZ;
					
					//透過度 これだけで負荷が２倍程高くなるー！
					thumbs[i].alpha = 1.1 - (thumbs[i].z / RADIUS);
				}
			}
		}
		
		
		/*******************************************************
		* マウスイベント
		********************************************************/
		private function onMouseOutHandler(e:MouseEvent):void 
		{
			isMouseOut = true;
		}
		
		private function onMouseOverHandler(e:MouseEvent):void 
		{
			isMouseOut = false;
		}
		//サムネイルクリック
		private function onClickHandler(e:MouseEvent):void 
		{
			//ベース登録
			addChild(picBase);
			
			//プログレスバー登録
			picBase.addChild(progBar);
			progBar.alpha = 1;
			progBar.x = 25;
			progBar.y = stageH / 2 - 10;
			
			//通常画像読込フラグ
			isShow = true;
			
			//index捜索
			var picIndex:uint = e.currentTarget.name;
			
			//通常画像ＵＲＬ格納
			var picURL:String = urls[picIndex];

			//画像読込
			if (picLoader != null)
			{
				picLoader = null;
			}
			picLoader = new Loader();
			picLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onPicLoadedHandler);
			picLoader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, onProgressHandler);
			picLoader.load(new URLRequest(picURL),new LoaderContext(true));
			
			//画像登録
			picBase.addChild(picLoader);
			
		}
		
		private function onProgressHandler(e:ProgressEvent):void 
		{
			par = (e.bytesLoaded / e.bytesTotal) * 100;
			progBar.scaleX = par / 100;
		}
		
		private function onPicLoadedHandler(e:Event):void 
		{
			//プログレスバー削除
			picBase.removeChild(progBar);
			progBar.scaleX = 0;
			
			//スケール調整
			var bmp:Bitmap = e.currentTarget.content;
			if (bmp.width > stageW - 50 || bmp.height > stageH - 50)
			{
				var myScale:Number=1;
				if (bmp.width > bmp.height) {
					myScale = bmp.width / (stageW - 50);
				}else {
					myScale = bmp.height / (stageH - 50);
				}
				bmp.scaleX = bmp.scaleY = 1/myScale;
			}
			
			bmp.x = -bmp.width / 2 + stageW / 2;
			bmp.y = -bmp.height / 2 + stageH / 2;
			
			//アニメーション
			BetweenAS3.tween(bmp, { alpha:1 }, { alpha:0 }, 0.3, null).play();
			
			//リスナー解放
			picLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onPicLoadedHandler);
			picLoader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS, onProgressHandler);
		}
		//通常画像解放用
		private function forRemovePicHandler(e:MouseEvent):void 
		{
			
			picBase.removeChild(picLoader);
			removeChild(picBase);
			isShow = false;	
		}
	}
	
}