/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3nhD
 */

// forked from John_Blackburne's Quaternion rotation shader
// circular gradient filter with a shader
// http://johnblackburne.blogspot.co.uk/2012/04/circular-gradient-shader.html
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;
    import flash.net.*;
    import flash.system.LoaderContext;
    import mx.utils.*;

	public class ShaderTest extends Sprite {
		public static const asShader:Vector.<String> = Vector.<String>([
"pQEAAACkBQB0d2lybKAMbmFtZXNwYWNlADEAoAx2ZW5kb3IASldCAKAIdmVyc2lv",
"bgABAKAMZGVzY3JpcHRpb24AZ3JhZGllbnQgaW50ZXJwb2xhdGlvbgChAQIAAAxf",
"T3V0Q29vcmQAoQEDAQAOY29sMQCiA2RlZmF1bHRWYWx1ZQAAAAAAAAAAAAAAAACh",
"AQMCAA5jb2wyAKIDZGVmYXVsdFZhbHVlAAAAAAA/gAAAAAAAAKEBAwMADmNvbDMA",
"ogNkZWZhdWx0VmFsdWUAAAAAAAAAAAA/gAAAoQEDBAAOY29sNACiA2RlZmF1bHRW",
"YWx1ZQA/gAAAP4AAAAAAAAChAQIAAANjZW50ZXIAogJtaW5WYWx1ZQAAAAAAAAAA",
"AKICbWF4VmFsdWUAQ/oAAEP6AACiAmRlZmF1bHRWYWx1ZQBDegAAQ3oAAKEBAQEA",
"AXN0YXJ0QW5nbGUAogFtaW5WYWx1ZQAAAAAAogFtYXhWYWx1ZQBAyQ/bogFkZWZh",
"dWx0VmFsdWUAAAAAAKECBAUAD2RzdAAdBgDBAAAQAAIGAMEAALAAHQYAMQYAEAAd",
"AgAQBgDAAAYCABAGAIAAHQMAEAIAwAAdAgAQAwDAAAICABABAMAAHQMAEAIAwAAy",
"AgAQQMkP2x0EABADAMAAAQQAEAIAwAAdAgAQBADAADIEABDASQ/bKgMAEAQAwAAd",
"AYCAAIAAADMEABABgAAAAgDAAAMAwAAdAwAQBADAADIEABBAgAAAHQYAgAMAwAAD",
"BgCABADAADIEABBAyQ/bBAYAQAQAwAADBgBABgAAAB0DABAGAEAAMgQAEAAAAAAq",
"AwAQBADAAB0BgIAAgAAANAAAAAGAAAAyBAAQv4AAACoDABAEAMAAHQGAQACAAAA0",
"AAAAAYBAADIEABBAAAAAHQYAgAMAwAABBgCABADAAB0CABAGAAAAHQcA4gEAGAAd",
"CADiAgAYADUAAAAAAAAAMgQAED+AAAAdBgCAAwDAAAEGAIAEAMAAHQIAEAYAAAAd",
"BwDiAgAYAB0IAOIDABgANgAAAAAAAAA1AAAAAAAAADIEABA/gAAAKgMAEAQAwAAd",
"AYBAAIAAADQAAAABgEAAHQIAEAMAwAAdBwDiAwAYAB0IAOIEABgANQAAAAAAAAAy",
"BAAQP4AAAB0GAIADAMAAAgYAgAQAwAAdAgAQBgAAAB0HAOIEABgAHQgA4gEAGAA2",
"AAAAAAAAADYAAAAAAAAAHQkAgAIAwAAdCQBAAgDAAB0JACACAMAAMgoA4D+AAAAC",
"CgDiCQAYAB0LAOIHABgAAwsA4goAGAAdDADiCAAYAAMMAOIJABgAAQsA4gwAGAAd",
"CQDiCwAYAB0KAOIIABgAAgoA4gcAGAAyCwDgAAAAADIMAOA/gAAAHQ0A4gkAGAAC",
"DQDiBwAYAB0OAOIIABgAAg4A4gcAGAAEDwDiDgAYAAMNAOIPABgACg0A4gsAGAAJ",
"DQDiDAAYADIOAOBAAAAAAw4A4g0AGAAyDwDgQEAAAAIPAOIOABgAHQ4A4g0AGAAD",
"DgDiDQAYAAMOAOIPABgAHQsA4goAGAADCwDiDgAYAB0KAOIHABgAAQoA4gsAGAAd",
"CQDiCgAYAB0KAIAJAAAAHQoAQAkAQAAdCgAgCQCAADIEABA/gAAAHQoAEAQAwAAd",
"BQDzCgAbAA=="])
		public var shader:Shader;
                public var bd:BitmapData, fAngle:Number;		

		function ShaderTest() {
			Make();
		}
		
		public function Make():void {
                        bd = new BitmapData(stage.stageWidth,stage.stageHeight, true, 0xff8080ff);
                        var bitmap :Bitmap = new Bitmap( bd );
                        addChild( bitmap );

                	var dec:Base64Decoder = new Base64Decoder;
			dec.decode(asShader.join(""));
                        shader = new Shader(dec.drain());
			stage.addEventListener(MouseEvent.MOUSE_MOVE, Move);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, Down);
                        fAngle = 0;
		}
		
		public function UpdateShader():void {
                        var shape:Shape = new Shape();
                        shape.graphics.beginShaderFill(shader);
                        shape.graphics.drawRect(0, 0, stage.stageWidth,stage.stageHeight);
                        bd.draw(shape);
		}
		
		public function Move(ev:MouseEvent):void {
			shader.data.center.value = [ev.stageX, ev.stageY];
			UpdateShader();
		}

		public function Down(ev:MouseEvent):void {
                        shader.data.startAngle.value = [fAngle];
                        fAngle += 0.5;
                        if (fAngle > 6.283) fAngle -= 6.283;
			UpdateShader();
		}
	}
}

/*

<languageVersion: 1.0;> 

kernel circGrad
<   namespace : "1";
    vendor : "JWB";
    version : 1;
    description : "gradient interpolation"; >
{
    // define PI
    const float PI    = 3.14159265;
    const float TWOPI = 6.28318530;
    
    parameter float3 col1
    <
        defaultValue:float3(0.0, 0.0, 0.0);
    >;
    parameter float3 col2
    <
        defaultValue:float3(0.0, 1.0, 0.0);
    >;
    parameter float3 col3
    <
        defaultValue:float3(0.0, 0.0, 1.0);
    >;
    parameter float3 col4
    <
        defaultValue:float3(1.0, 1.0, 0.0);
    >;

    parameter float2 center
    <
        minValue:float2(0.0, 0.0);
        maxValue:float2(500.0, 500.0);
        defaultValue:float2(250.0, 250.0);
    >;
    
    parameter float startAngle
    <
        minValue:float(0.0);
        maxValue:float(6.28318530);
        defaultValue:float(0.0);
    >;

    output pixel4 dst;

    void
    evaluatePixel()
    {
        // calculate where we are relative to the center
        float2 relativePos = outCoord() - center;
        // get our bearing relative to start angle, wrap it and scale to (-2, 2)
        float dir = atan(relativePos.y, relativePos.x);
        dir = dir - startAngle;
        float dir2 = dir + TWOPI;
        dir = dir < -PI ? dir2 : dir;
        dir = dir * 4.0 / TWOPI;

        // get colours to interpolate between and how far to interpolate
        float3 colFrom, colTo;
        if (dir < 0.0) {
            if (dir < -1.0) {
                dir2 = dir + 2.0;
                colFrom = col1;
                colTo = col2;
            } else {
                dir2 = dir + 1.0;
                colFrom = col2;
                colTo = col3;
            }
        } else {
            if (dir < 1.0) {
                dir2 = dir;
                colFrom = col3;
                colTo = col4;
            } else {
                dir2 = dir - 1.0;
                colFrom = col4;
                colTo = col1;
            }
        }
        // linearly interpolate
        float3 interp = mix(colFrom, colTo, float3(dir2, dir2, dir2));
        // convert to smooth interpolation through colours
        interp = colFrom + (colTo - colFrom) * smoothStep(colFrom, colTo, interp);
        dst = pixel4(interp.x, interp.y, interp.z, 1.0);
    }
}

*/