/**
 * Copyright godspeed1977max ( http://wonderfl.net/user/godspeed1977max )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3nXX
 */

// forked from hacker_0wi_qnc7's forked from: PaperVision3D × YouTube Player API 3.0
// forked from nijitaro's PaperVision3D × YouTube Player API 3.0
/**
 * PaperVision3D × YouTube Player API 3.0
 * 
 * MovieMaterialはBitmapData.draw()しているので
 * セキュリティSandboxエラーになってしまいました。
 * DOWNLOADボタンから落としたファイルを再生するしかない。。。
 *
 * - PV3D BasicView
 * - PV3D Plane
 * - PV3D MovieMaterial
 * - YouTube API 3.0
 *
 * [Movie]
 * KNOTS DANCE 002 (http://www.youtube.com/watch?v=Z3LUhwgGPxw)
 */
package {
    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Rectangle;
    import flash.system.Security;

    import org.papervision3d.materials.MovieMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    
    [SWF(backgroundColor="0x000000", frameRate="50")]
    /* --------------------------------------------------
    [MEMO]
        SpriteではなくBasicViewをextendsする。BasicViewはSpriteのサブクラス
    -------------------------------------------------- */
    public class PV3DYouTube extends BasicView {
        // Planeを使う
        private var plane:Plane;
        
        // コンストラクタ
        public function PV3DYouTube ()
        {
            Security.allowDomain("http://www.youtube.com");
            
            // materialをMovieMaterialから作成
            var material:MovieMaterial = new MovieMaterial(new YoutubePlayer("Z3LUhwgGPxw"), false, true);
            // マテリアルの描画領域を指定する
            material.rect = new Rectangle(0,0,320,180);
            // 両面にテクスチャを貼る
            material.doubleSided = true;
            // テクスチャの歪み防止
            material.precise = true;
            
            // 新規Planeオブジェクトを作成
            plane = new Plane( material, 800, 450, 16, 16 );
            
            // scene(予めBasicViewで定義されている表示エリア)に作成したplaneを追加する
            scene.addChild(plane);
            
            // cameraのズームを80%に指定
            camera.zoom = 80;
            
            // BasicViewの描画を開始する
            startRendering();
        }
        
        /* --------------------------------------------------
        [MEMO]
            BasicViewのEvent.ENTER_FRAMEのようなもの。
            これをoverrideしてフレーム毎の挙動を定義する。
        -------------------------------------------------- */
        override protected function onRenderTick (event :Event = null):void
        {
            /* --------------------------------------------------
            [MEMO]
                Papervision3dは左手座標系。
                左手をGoodの状態(親指を立てる)にして
                親指を正の方向に向けた際の、4本指指の巻き方向がそれぞれ回転方向となる
            -------------------------------------------------- */
            // Y軸回転はyaw
            plane.yaw(2);
            /* --------------------------------------------------
            [MEMO]
                BasicViewのonRenderTickも実行する。
                これがないと、onRenderTickが単純に上書きされてしまうので、
                もともともonRenderTickの機能を果たさない。
            -------------------------------------------------- */
            super.onRenderTick(event);
        }
    }
}
    
import flash.display.*;
import flash.events.Event;
import flash.net.URLRequest;
import flash.system.Security;

class YoutubePlayer extends Sprite {
    private var player:Object;
    private var loader:Loader;
    private var _videoID:String;
    
    /// init
    public function YoutubePlayer(videoID:String) {
        loader = addChild(new Loader()) as Loader;
        loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit, false, 0, true);
        loader.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));
        _videoID = videoID;
    }
    /// events
    private function onLoaderInit(event:Event):void {
        player = loader.content;
        player.addEventListener("onReady", onPlayerReady);
    }
    private function onPlayerReady(event:Event):void {
        player.setSize(320, 180);
        player.loadVideoById(_videoID, 0, "low");
    }
}