/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3nUH
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.Sprite;
    
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
  
            deb = new TextField();
            deb.mouseEnabled = false;
            deb.width = 320;
            deb.height = 240;
            addChild(deb);
            
            
            
            myShape = new xShape();
            myShape.cx = 200;
            myShape.cy = 200;
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, kup);           
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mdown);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
        public function kdown(e:KeyboardEvent):void { if (e.keyCode > 511) { return;}vecKey[e.keyCode]=true; }
        public function kup(e:KeyboardEvent):void { if (e.keyCode > 511) { return;}vecKey[e.keyCode]=false; }
        
        public function isKeyDown(k:int):Boolean { return vecKey[k];  }
        
        public function mdown(e:MouseEvent):void
        {
           myShape.genShape();
           cx = 200;
           cy =  50;
           vx =0; vy =0;
           
        }//mdown
   
         public var myShape:xShape;
          public var deb:TextField;
 
         public var dir:int = 0;
 
         
        public function onEnter(e:Event):void
        {
            
            movePlat();
            
            myShape.ma = myShape.roll;
            myShape.mx = myShape.cx;
            myShape.my = myShape.cy;
            
            
                  if (dir == 0)
            { myShape.cx += 1; }
            else { myShape.cx -= 1;}
            
            if (myShape.cx > 300) { dir = 1;}
            else if (myShape.cx < 100) { dir = 0;}
 
             myShape.roll += 0.01;

            
            myShape.ma = angDiff(myShape.roll, myShape.ma);
            myShape.mx = myShape.cx - myShape.mx;
            myShape.my = myShape.cy - myShape.my;
            
            deb.text = " " + myShape.ma + " " + myShape.mx + " " + myShape.my;
 
             //when travelling on the shape ->
             // transform us by the change in the shapes position/rotation
             
             var bnear:Boolean;
             bnear = nearLeft || nearRight || nearUp;
             
             if (bStartGround || bnear)
             {
                 cx += myShape.mx;
                 cy += myShape.my;
                 
                 var kx:Number;
                 var ky:Number;
                 var rx:Number;
                 var ry:Number;
                 var ma:Number;
                 var ca:Number;
                 var sa:Number;
                 ma = myShape.ma;
                 kx = cx - myShape.cx;
                 ky = cy - myShape.cy;
                 ca = Math.cos(ma);
                 sa = Math.sin(ma);
                 rx = kx * ca - ky * sa;
                 ry = kx * sa + ky * ca;
                 rx += myShape.cx;
                 ry += myShape.cy;
                 cx = rx;
                cy = ry; 
                //graphics.drawCircle(rx,ry, xrad); 
              }
 
            graphics.clear();
            
            graphics.lineStyle(2, 0);
            myShape.drawShape(graphics, 0);
            
            graphics.beginFill(0xFF,0.5);
            //graphics.drawCircle(cx,cy, xrad);
            graphics.drawEllipse(cx-xrad,cy-yrad,xrad+xrad,yrad+yrad);
            graphics.endFill();
        }//onenter
  
        public function isWall(wx:Number, wy:Number):Boolean
        {
            return myShape.isPointInside(wx,wy);
        }//iswall
           
        public static function angDiff(a:Number, b:Number):Number
        {
          a -= b;
          if (a > 3.14) { a -= 6.28; }
          if (a < -3.14) { a += 6.28;}
          return a;
        }//angdiff
      
        public var keyLeft:Boolean = false;
        public var keyRight:Boolean = false;
        public var keyDown:Boolean = false;
        public var keyUp:Boolean = false;
        public var bStartGround:Boolean = false;
        public var cx:Number = 200;
        public var cy:Number = 50;
        public var vx:Number = 0;
        public var vy:Number = 0;
        public var xrad:Number = 8;
        public var yrad:Number = 16;  
        
        public var nearUp:Boolean = false;
        public var nearLeft:Boolean = false;
        public var nearRight:Boolean = false;
        
  
        public function movePlat():void
        {
          keyLeft = (isKeyDown(Keyboard.A) || isKeyDown(Keyboard.LEFT));
          keyRight = (isKeyDown(Keyboard.D) || isKeyDown(Keyboard.RIGHT));
          keyUp = (isKeyDown(Keyboard.W) || isKeyDown(Keyboard.UP));
          keyDown = (isKeyDown(Keyboard.S) || isKeyDown(Keyboard.DOWN));

          bStartGround = isWall(cx,cy+yrad+1) || isWall(cx,cy+yrad);
          var s:Number;
          var maxs:Number;
          s = 1;
          maxs = 4;
          
          vy += 0.4;

          if (keyDown) { vy += s; }
          if (keyUp) { vy -= s; }
          if (keyLeft) { if (vx > -maxs) { vx -= s; }  }
          if (keyRight) { if (vx < maxs) { vx += s; } }
          
          if (vx < 0 && isWall(cx - xrad, cy)) { vx = 0; }
          else if (vx > 0 && isWall(cx + xrad, cy)) { vx = 0; }
          if (vy < 0 && isWall(cx, cy - yrad)) { vy = 0; }
          else if (vy > 0 && isWall(cx, cy + yrad)) { vy = 0; }
          
          vx *= 0.9;
          vy *= 0.98;
          
          cx += vx;
          cy += vy;
          
          if (cy > 250 && vy >= 0) { vy = 0; cy = 250; }
            
           if (bStartGround && vy >= 0) { checkSlope(12); }
  
          if (isWall(cx-xrad+1, cy)) { cx+= 1; }
          if (isWall(cx+xrad-1, cy)) { cx-= 1; }
          
  
           nearLeft = isWall(cx-xrad, cy);
           nearRight = isWall(cx+xrad, cy);
           nearUp = isWall(cx, cy-yrad);
        }//moveplat
        
  
      public function checkSlope(pow:int = 8):void
      {
        var i:int;
      
        if (isWall(cx,cy+yrad+pow)==true)
        for (i = 0; i < pow; i++)
        {
          if (isWall(cx, cy + yrad + 1) == true) { break;  }
          cy += 1;
        }
        
        if (isWall(cx,cy+yrad-pow)==false)
        for (i = 0; i < pow; i++)
        {
          if (isWall(cx, cy + yrad - 1) == false) { break;  }
          cy -= 1;
        }
      
    }//checkslop
       
    }//classend
}
import flash.display.Graphics;

internal class xShape
{
  public var vecLine:Vector.<xLine>;
    
  public var cx:Number = 0;
  public var cy:Number = 0;
  public var roll:Number = 0;
  
  public var mx:Number = 0;
  public var my:Number = 0;
  public var ma:Number = 0;
  
  public function xShape()
  { 
      genShape(); 
  }//ctor

  //see  http://wonderfl.net/c/n5Ja
  //for readable version
  public function isPointInside(kx:Number, ky:Number):Boolean
  {
     var a:xLine;     var i:int;         var num:int;
     var w:int;       var wz:Number;     var ax:Number;
     var ay:Number;   var bx:Number;     var by:Number;
     var kx:Number; var ky:Number;
     var c:uint;
     var ca:Number; var sa:Number;
     var px:Number; var py:Number;
     
     //transform point to the shape's space
     kx -= cx;
     ky -= cy;
     ca = Math.cos(-roll);
     sa = Math.sin(-roll);
     px = ca*kx - sa*ky;
     py = sa*kx + ca*ky;
     
     
       w = 0;       
       num = vecLine.length;       
       for (i = 0; i < num; i++)
       {
           a = vecLine[i];                   
           if (a.y0 <= py && a.y1 <= py) { continue; }
           if (a.y0 > py && a.y1 > py) { continue; }           
           //which side of the line we are on?
           //(using cross product)              
           ax = px - a.x0;           ay = py - a.y0;
           bx = a.x1 - a.x0;           by = a.y1 - a.y0; 
           wz = (ax*by)-(ay*bx);     
           if (wz > 0) { c = 0x0000FF; w+= 1;}
           else if (wz < 0) { c = 0xFF0000; w -= 1;}       
       }//nexti      
      return (w != 0);
  }//ispointin
  
  public function drawShape(g:Graphics, c:uint=0):void
  {
     var i:int; var num:int; var a:xLine;
     var rx:Number;
     var ry:Number;
     var ca:Number;
     var sa:Number;
     
     ca = Math.cos(roll);
     sa = Math.sin(roll);
     
     g.beginFill(c,0.5);
     //g.lineStyle();
     num = vecLine.length;
     for (i = 0; i < num; i++)
     {
       a = vecLine[i];
          if (i == 0)
         {
           rx = a.x0*ca - a.y0*sa+cx;
           ry = a.x0*sa + a.y0*ca+cy;  
             
          g.moveTo(rx, ry);
          
           rx = a.x1*ca - a.y1*sa+cx;
           ry = a.x1*sa + a.y1*ca+cy;  
          
          g.lineTo(rx, ry);
         }
         else
         { 
           rx = a.x1*ca - a.y1*sa+cx;
           ry = a.x1*sa + a.y1*ca+cy;          
           g.lineTo(rx, ry);
        
           //g.lineTo(a.x1+cx, a.y1+cy);
         
         }//endif
              
     }//nexti
     /*a = vecLine[0];
     
     rx = a.x0*ca - a.y0*sa+cx;
     ry = a.x0*sa + a.y0*ca+cy;  
      
     g.lineTo(a.x0+cx, a.y0+cy);    
      */   
     g.endFill();
  }//drawshape
    
    
         
 public function genShape():void
 {           
     vecLine = new Vector.<xLine>(0,false);
     
     var ang:Number;
     var kx:Number;     var ky:Number;
     var px:Number;     var py:Number;
     var d:Number;
     var nx:Number;     var ny:Number;
     var mag:Number;
     px = 0; py = 0;
     for (ang = 0; ang < 6.28; ang+=0.5)
     {
         d = (Math.random()*60 + 30);

         kx = Math.cos(ang) * d;
         ky = Math.sin(ang) * d;
         
         if (ang == 0) { px =kx; py= ky; continue; }
         
         vecLine.push(new xLine(px,py,kx,ky) );
        
         nx = -(py - ky);
         ny = px - kx;
         mag = Math.sqrt(nx*nx+ny*ny);
         if (mag == 0) { mag =0.00001;}
         nx /= mag;         ny /= mag;
         px = kx;         py = ky;
     }//nextang
     
     vecLine.push(new xLine(kx,ky,vecLine[0].x0,vecLine[0].y0));
       
 }//genshape
         
    
}//xshape



internal class xLine
{
    public var x0:Number = 0;
    public var y0:Number = 0;
    public var x1:Number = 0;
    public var y1:Number = 0;
    
    public function xLine(ax:Number,ay:Number, bx:Number, by:Number):void
    {
        x0 = ax; y0 = ay;  x1 = bx; y1 = by;
        
        //calc normal (and midpoint) only needed for debugging
        var mag:Number;
        nx = -(y0 - y1);
        ny = (x0 - x1);
        mag = Math.sqrt(nx*nx+ny*ny);
        if (mag == 0) { mag = 0.00001;}
        nx /= mag;
        ny /= mag;
        cx = x0 +(x1-x0)*0.5;
        cy = y0 +(y1-y0)*0.5;
    }//xline
    
    public var cx:Number = 0;
    public var cy:Number = 0;
    public var nx:Number = 0;
    public var ny:Number = 0;
    
    
    
}//xline