/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3muf
 */

package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flashx.textLayout.container.ContainerController;
    import flashx.textLayout.elements.TextFlow;
    import flashx.textLayout.elements.ParagraphElement;
    import flashx.textLayout.elements.SpanElement;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.core.easing.SineEaseOut;
    import spark.utils.TextFlowUtil;
    import flashx.textLayout.compose.IFlowComposer;
    import flashx.textLayout.compose.TextFlowLine;
    

    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private const FONT_FAMILY:String = '"ヒラギノ角ゴ Pro W3","Hiragino Kaku Gothic Pro","メイリオ",Meiryo,Osaka,"ＭＳ Ｐゴシック","MS PGothic",sans-serif';
        private const SAMPLE_TEXT:String = "吾輩（わがはい）は猫である。名前はまだ無い。\nどこで生れたかとんと見当（けんとう）がつかぬ。何でも薄暗いじめじめした所でニャーニャー泣いていた事だけは記憶している。吾輩はここで始めて人間というものを見た。しかもあとで聞くとそれは書生という人間中で一番獰悪（どうあく）な種族であったそうだ。この書生というのは時々我々を捕（つかま）えて煮（に）て食うという話である。しかしその当時は何という考もなかったから別段恐しいとも思わなかった。ただ彼の掌（てのひら）に載せられてスーと持ち上げられた時何だかフワフワした感じがあったばかりである。掌の上で少し落ちついて書生の顔を見たのがいわゆる人間というものの見始（みはじめ）であろう。この時妙なものだと思った感じが今でも残っている。第一毛をもって装飾されべきはずの顔がつるつるしてまるで薬缶（やかん）だ。その後（ご）猫にもだいぶ逢（あ）ったがこんな片輪（かたわ）には一度も出会（でく）わした事がない。のみならず顔の真中があまりに突起している。そうしてその穴の中から時々ぷうぷうと煙（けむり）を吹く。どうも咽（む）せぽくて実に弱った。これが人間の飲む煙草（たばこ）というものである事はようやくこの頃知った。\nこの書生の掌の裏（うち）でしばらくはよい心持に坐っておったが、しばらくすると非常な速力で運転し始めた。書生が動くのか自分だけが動くのか分らないが無暗（むやみ）に眼が廻る。胸が悪くなる。到底（とうてい）助からないと思っていると、どさりと音がして眼から火が出た。それまでは記憶しているがあとは何の事やらいくら考え出そうとしても分らない。"
        
        private var textFlow:TextFlow;
        
        public function Main() 
        {
            setup();
            
            var flowComposer:IFlowComposer = textFlow.flowComposer;
            var numLines:uint = textFlow.flowComposer.numLines;
            var textYs:Array = new Array();
            for ( var i:uint = 0; i < numLines; i++ ) {
                var textFlowLine:TextFlowLine = flowComposer.getLineAt( i );
                textYs.push( textFlowLine.y );
            }
            var textHeight:Number = textFlowLine.textHeight;
            flowComposer.removeControllerAt( 0 );
            
            for ( i = 0; i < numLines; i++ ) {
                
                var sprite:Sprite = new Sprite();
                addChild( sprite );
                
                BetweenAS3.delay( BetweenAS3.tween( sprite, { y:textYs[ i ], alpha:1 }, { y:textYs[ i ] + textHeight / 2, alpha:0 }, 1, new SineEaseOut() ), i * 0.2 ).play();
                
                textFlow.flowComposer.addController( new ContainerController( sprite, stage.stageWidth, textHeight ) );
            }
            flowComposer.updateAllControllers();
        }
        
        private function setup():void 
        {
            var container:Sprite = new Sprite();
            container.x = 100;
            addChild( container );
            
            var containerController:ContainerController = new ContainerController( container, stage.stageWidth, stage.stageHeight );
            
            textFlow = new TextFlow();
            textFlow.fontFamily = FONT_FAMILY;
            
            var p:ParagraphElement = new ParagraphElement();
            var span:SpanElement = new SpanElement();
            span.text = SAMPLE_TEXT;
            p.addChild( span );
            textFlow.addChild( p );
            textFlow.flowComposer.addController( containerController );
            
            textFlow.flowComposer.updateAllControllers();
        }
    }

}