/**
 * Copyright naokey0221 ( http://wonderfl.net/user/naokey0221 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3mp9Q
 */

// forked from naokey0221's PV3Dマウス移動
// forked from clockmaker's [PV3D] サンプル2 (3Dのアニメーション) 
package {
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.KeyboardEvent;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;
    
    public class Sample2 extends BasicView {
       private var isMouseDown:Boolean = false; // マウスを押してるかのフラグ
       private var isKeyboardDown:Boolean = false;// キ―ボードを押してるかのフラグ
        public var keyboard:Vector.<Boolean> = new Vector.<Boolean>(255);
        private var sphere:Sphere; // 球面のインスタンス
        private var sphere2:Sphere; // 球面のインスタンス
        public function Sample2():void {
            // マテリアルを作成
            var material:WireframeMaterial = new WireframeMaterial(0xFF0000);
            var material2:WireframeMaterial = new WireframeMaterial(0x0000ff);
            // 3Dオブジェクトを作成
            sphere = new Sphere(material, 300, 20, 10);
            sphere2=new Sphere(material2, 300, 20, 10);
            // 3Dシーンに追加して、表示させる
            scene.addChild(sphere);
            scene.addChild(sphere2);
            // レンダリングを開始
            startRendering();
            
            // エンターフレームを設定
            addEventListener(Event.ENTER_FRAME, loop);
            //stage.addEventListener(KeyboardEvent.KEY_UP, onKeyboardEvent);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kD);
            stage.addEventListener(KeyboardEvent.KEY_UP, kU);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
        }
        
        private function loop(e:Event):void {
            // 球面をY軸方向に回転
           // sphere.rotationY += 10;
            sphere.rotationZ += 10;
            if(isMouseDown){
            sphere2.x = mouseX - viewport.width / 2;
            sphere2.y = -(mouseY - viewport.height / 2);
            } 
            
            if(keyboard[37]) {
                sphere.x -= 50;
            }
            
            if(keyboard[39]) {
                sphere.x += 50;
            }
            
            if(keyboard[38]) {  //上
                //camera.x += 50;
                 sphere.y += 50;
            }
            
            if(keyboard[40]) { //下
                 //camera.x -= 50;
                 sphere.y -= 50;          
            }
                    
        }
       private function upHandler(e:MouseEvent):void {
            isMouseDown = false;
        }

        private function downHandler(e:MouseEvent):void {
            isMouseDown = true;
        }
        
        public function kD(e:KeyboardEvent):void {
            if(e.keyCode < 255) {
                keyboard[e.keyCode] = true;
            }
        }
        
        public function kU(e:KeyboardEvent):void {
            if(e.keyCode < 255) {
                keyboard[e.keyCode] = false;
            }
        }
        
        
        public function onKeyboardEvent(e : KeyboardEvent) : void
        {
             switch(e.type)
            {
                case KeyboardEvent.KEY_UP:

                    switch(e.keyCode)
                    {
                        // swap viewpoints
                        
                        case 39:    
                           sphere.x+=10;        
                            break;
                        case 37:    
                           sphere.x+=-10; 
                            break;
                        case 38:    
                           sphere.y+=10;        
                            break;
                        case 40:    
                           sphere.y+=-10; 
                            break;
                    }

                    break;
            }
            
        }
        
        
        
        
    }
}