/**
 * Copyright PESakaTFM ( http://wonderfl.net/user/PESakaTFM )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3mfq
 */

/**
* Inpired by: YooouuuTuuube.com
* Created by David Kraftsow, dontsave.com 2009-2010.
* 
* I always liked that site and thought I would see if I understood correctly how he did it.
*/

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageDisplayState;
    import flash.display.StageScaleMode;
    import flash.events.ActivityEvent;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;
    
    [SWF(backgroundColor=0x000000, frameRate=20)]
    public class Main extends Sprite
    {
        public var video:Video;
        public var camera:Camera;
        public var w:int=0;
        public var h:int=0;
        public var count:int=0;
        public var bmp:Bitmap;
        public var bmd:BitmapData;
        public static const WIDTH:int = 465;//2560;
        public static const HEIGHT:int = 465;//1440;
        
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            bmd = new BitmapData(Main.WIDTH, Main.HEIGHT, false, 0xFF0000);
            bmp = new Bitmap(bmd);
            addChild(bmp);
            
            onResize();
            stage.addEventListener(Event.RESIZE, onResize);
            
            stage.doubleClickEnabled = true;
            stage.addEventListener(MouseEvent.DOUBLE_CLICK, onDblClick);
            
            camera = Camera.getCamera();
            camera.setMode(160, 120, 15);
            
            if (camera != null) {
                video = new Video(camera.width, camera.height);
                video.attachCamera(camera);
                
                addEventListener(Event.ENTER_FRAME, onEnter);
            } else {
                trace("You need a camera.");
            }
        }
        
        protected function onDblClick(event:MouseEvent):void
        {
            stage.displayState = StageDisplayState.FULL_SCREEN;
        }
        
        protected function onEnter(event:Event):void
        {
            var matrix:Matrix = new Matrix();
            matrix.tx = -camera.width;
            matrix.ty = 0;
            bmd.draw(bmd, matrix);
            
            matrix.tx = Main.WIDTH - camera.width;
            matrix.ty = -camera.height;
            bmd.draw(bmd, matrix);
            
            matrix.tx = Main.WIDTH - camera.width;
            matrix.ty = Main.HEIGHT - camera.height;
            bmd.draw(video, matrix);
            
            count++;
            if(count>=w*h)
            {
                count = 0;
            }
        }
        
        protected function onResize(event:Event=null):void
        {
            bmp.x = stage.stageWidth - Main.WIDTH;
            bmp.y = stage.stageHeight - Main.HEIGHT;
        }
    }
}